<?php
namespace Core;
class YoozDB extends \PDO{
    private $ftpConfigs;
    private $connectStatus;
    /* override the PDO connection using parent::__construct function
     * the database information is read from config.php in the admin_panel root
     */
    public function __construct(){
        if(defined('CONF_PATH')){
            if(file_exists(CONF_PATH)){
                require_once CONF_PATH;
                if(defined('YOOZ_DB_HOST') && defined('YOOZ_DB_USER') && defined('YOOZ_DB_PASSWORD') && defined('YOOZ_DB_NAME')){
                    try{
                        $options = array(
                            \PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8",
                            \PDO::ATTR_DEFAULT_FETCH_MODE => \PDO::FETCH_ASSOC
                        );

                        parent::__construct("mysql:host=".YOOZ_DB_HOST.";dbname=".YOOZ_DB_NAME, YOOZ_DB_USER, YOOZ_DB_PASSWORD, $options);
                        $this->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
                        $this->connectStatus = true;

                        if(defined("YOOZ_FTP_CONFIG_DATA")){
                            $ftp_configs = [];
                            if(is_array(YOOZ_FTP_CONFIG_DATA) && count(YOOZ_FTP_CONFIG_DATA) > 0){
                                foreach (YOOZ_FTP_CONFIG_DATA as $confName => $confInfo){
                                    if(is_array($confInfo) && !empty($confInfo['server']) && !empty($confInfo['username']) &&
                                        !empty($confInfo['password']) && !empty($confInfo['port']) && !empty($confInfo['server_url']) && !empty($confInfo['home_directory'])){
                                        $ftp_configs[$confName] = $confInfo;
                                    }else{
                                        die("اطلاعات FTP داده شده ناقص است.");
                                    }
                                }
                            }
                            $this->ftpConfigs = $ftp_configs;
                        }

                    }catch(\PDOException $e){
                        $this->connectStatus = false;
                        return false;
                    }
                }else{
                    $this->connectStatus = false;
                }
            }else{
                die("مسیر وارد شده برای فایل کانفیگ اشتباه است.");
            }
        }else{
            die("مسیر فایل کانفیگ تعریف نشده است. لطفا آن را در ابتدای فایل index.php در مسیر روت تعریف کنید.");
        }
    }

    public function check_connection(){
        return $this->connectStatus;
    }

    public function get_ftp_configs(){
        return is_array($this->ftpConfigs) ? $this->ftpConfigs : [];
    }
    /* get the row count of query
     * @query = SELECT databse query
     */
    public function get_rows_count($query){
        $statement = $this->query($query);
        return $statement->rowCount();
    }

    /*
     * this function will select the data from table
     * @tabel = name of the table to catch data
     * @columns = needed columns and * in default to catch all columns
     * @where = WHERE clause for select data
     * @limit = limitation of select records
    */
    public function select(string $table, string $columns = "*", string $where = "", string $limit = ""){
        $query = "SELECT $columns FROM $table";
        $query .= !empty($where) ? " WHERE ".$where : "";
        $query .= !empty($limit) ? " LIMIT $limit" : "";
        $statement = $this->query($query);
        return $statement;
    }

    /*
     * this function will insert data to a table
     * @tabel = name of the table to insert data
     * @data = an array of column as key and value of column as value of array
    */
    public function insert(string $table, array $data){
        $keys = array_keys($data);
        $query = "INSERT INTO $table (" . implode(',', $keys) . ") VALUES (:" . implode(',:', $keys) . ")";
        $statement = $this->prepare($query);
        if($statement){
            $exec = $statement->execute($data);
            if($exec && $statement->rowCount() > 0){
                return true;
            }
        }
        return false;
    }

    /* get the last insert id*/
    public function get_insert_id(){
        return $this->lastInsertId();
    }

    /*
     * method to update the values of table
     * @table = name of table to update
     * @data  = an array of column as key and value of column as value of array
     * @where = WHERE clause for Update
     * */
    public function update(string $table, array $data, string $where = ""){
        $set = array();
        foreach ($data as $key => $value){
            $set[] = "$key = :$key";
        }
        $set = implode(',', $set);
        $query = "UPDATE $table SET $set";
        $query .= !empty($where) ? " WHERE ".$where : "";
        $statement = $this->prepare($query);
        if($statement){
            $exec = $statement->execute($data);
            if($exec){
                return true;
            }
        }
        return false;
    }

    /*
     * method to dalete record from a table
     * @table = name of table to update
     * @where = WHERE clause for Delete
     * */
    public function delete(string $table, string $where = ""){
        $query = "DELETE FROM $table";
        if (!empty($where)) {
            $query .= " WHERE $where";
        }
        $statement = $this->prepare($query);
        $statement->execute();
        return $statement;
    }

    public function table_exists(string $table_name){
        $stmt = $this->prepare("SHOW TABLES LIKE :table");
        $stmt->execute([':table' => $table_name]);
        return $stmt->rowCount() > 0 ? true : false;
    }

    public function create_table(string $table_name , array $columns){
        $sql = "CREATE TABLE IF NOT EXISTS $table_name (".implode(',' , $columns).")";
        PDO::exec($sql);
    }

    /* this method will destroy the connection at the end of scripts */
    public function __destruct(){
        $this->connection = null;
    }

}