<?php
namespace Core\Validators;
use Core\ErrorsTrait;
use Core\ValidatorInterface;

class File_Validator implements ValidatorInterface {
    use ErrorsTrait;
    private $file;

    public function validate($input, array $options = []): bool
    {
        if(!empty($input) && !empty($input['name']) && !empty($input['size'])){
            $this->file = $input;
            if($this->file_has_no_error() && $this->has_correct_file_type() && $this->has_valid_name()){
                return true;
            }
        }else{
            $this->set_error("هیچ فایلی انتخاب نشده است.");
        }
        return false;
    }

    public function get_validated_file(){
        return $this->has_error() ? false : $this->file;
    }
    private function file_has_no_error(){
        $response = ($this->file['error'] == 0) ? true : false;
        $this->set_error_on_false($response , "فایل ارسال شده ایراد دارد.");
        return $response;
    }
    private function has_valid_name() {
        $fileName = $this->file['name'];
        // Replace spaces with underscores
        $fileName = str_replace(' ', '_', $fileName);
        // Remove any non-alphanumeric characters except underscores, hyphens, and dots
        $fileName = preg_replace('/[^A-Za-z0-9_\-\.]/', '', $fileName);
        // Remove multiple consecutive dots
        $fileName = preg_replace('/\.+/', '.', $fileName);
        // Ensure the filename doesn't start or end with a dot
        $fileName = trim($fileName, '.');
        // Ensure the filename is not empty
        if (empty($fileName)) {
            return $this->set_error("نام فایل وارد نشده است. لطفا فایل را بررسی نمایید و سپس مجددا تلاش کنید.");
        }else{
            $this->file['name'] = $fileName;
            return true;
        }
    }

    protected $mimeTypeArray = array(
        "image/jpeg"            =>  "jpg",
        "image/png"             =>  "png",
        "image/webp"            =>  "webp",
        "image/gif"             =>  "gif",
        "video/mp4"             =>  "mp4",
        "video/mpeg"            =>  "mpeg",
        "audio/mpeg"            =>  "mp3",
        "audio/m4a"             =>  "m4a",
        "audio/wav"             =>  "wav",
        "audio/x-flac"          =>  "flac",
        "application/zip"       =>  "zip",
        "application/vnd.rar"   =>  "rar",
        "application/pdf"       =>  "pdf",
    );
    private function has_correct_file_type(){
        $response = true;
        $fileType = strtolower(pathinfo($this->file['name'],PATHINFO_EXTENSION));
        if($fileType === "jpeg"){$fileType = "jpg";}
        $fileMimeType = mime_content_type($this->file['tmp_name']);
        if(array_key_exists($fileMimeType , $this->mimeTypeArray)){
            if($this->mimeTypeArray[$fileMimeType] !== $fileType){
                $response = $this->set_error("پسوند واقعی این فایل از نوع ".$this->mimeTypeArray[$fileMimeType]." است. در حالی که در نام فایل از پسوند ".$fileType." استفاده شده است.");
            }
        }else{
            $response = $this->set_error("فایل ارسال شده دارای MIME TYPE برابر با ".$fileMimeType." می‌باشد. این مقدار در لیست MIME TYPE های پذیرفته شده نیست و نمی‌توان آن را اعتبار سنجی کرد.");
        }
        return $response;
    }
}
?>