<?php
namespace Core;
class Utils{
    public static function uri_array(){
        $data = array();
        $Request_URI = self::test_input($_SERVER['REQUEST_URI']);
        $URI_PATH = parse_url($Request_URI)['path'];
        $URI_PATH = str_replace("//" , "/" , $URI_PATH);
        if(!empty($URI_PATH)){
            $explodeURI = explode("/", $URI_PATH);
            foreach ($explodeURI as $value){
                if(!empty($value)){
                    array_push($data , $value);
                }
            }
        }
        return $data;
    }

    public static function get_back_url(){
        $backUrl = !empty($_GET['back_url']) ? filter_var(self::test_input($_GET['back_url']) , FILTER_VALIDATE_URL) : "";
        return !empty($_POST['back_url']) ? filter_var(self::test_input($_POST['back_url']) , FILTER_VALIDATE_URL) : $backUrl;
    }

    public static function test_input($data){
        return htmlspecialchars(stripslashes(trim($data)));
    }

    public static function PersianNumber($str){
        return str_replace(
            ["0","1","2","3","4","5","6","7","8","9"],
            ["۰","۱","۲","۳","۴","۵","۶","۷","۸","۹"],
            $str
        );
    }
    public static function EnglishNumber($str){
        return str_replace(
            ["۰","۱","۲","۳","۴","۵","۶","۷","۸","۹"],
            ["0","1","2","3","4","5","6","7","8","9"],
            $str
        );
    }
    public static function NumberFormat($val , string $lang = "fa"){
        if($lang == "en"){
            return self::EnglishNumber(number_format($val));
        }else{
            return self::PersianNumber(number_format($val));
        }
    }

    public static function CoinsFormat(int $coins_number , string $lang = "fa"): array|int|string
    {
        $response = $coins_number;
        if($coins_number >= 10000){
            $response = round($coins_number / 1000 , 1).($lang == "fa" ? " هزار" : "K");
        }
        if($coins_number >= 1000000){
            $response = round($coins_number / 1000000 , 1).($lang == "fa" ? " میلیون" : "M");
        }
        if($coins_number >= 1000000000){
            $response = round($coins_number / 1000000000 , 1).($lang == "fa" ? " میلیارد" : "B");
        }
        return $lang == "fa" ? self::PersianNumber($response) : $response;
    }

    public static function get_site_url(){
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
        return $protocol.$_SERVER['HTTP_HOST'];
    }
}