<?php
namespace Core;
use Core\JDate;

class User_Forms{
    private $inputItems = 0;
    private $acceptInputs = ['text', 'password' , 'number', 'url' , 'tel' , 'hidden' , 'select', 'textarea' , 'gender' , 'date' , 'color' , "multi_selection"];

    public function get_form(array $form_data , string $ajax_page , string $ajax_action , string $submit_text = "تایید" , string $submit_id = "", string $form_id = "" , string $before_submit_html = "", string $after_submit_html = "" , string $top_form_html = ""){
        $formHtml = $this->get_form_html($form_data);
        if($formHtml){
            $submit_id = !empty($submit_id) ? ' id="'.$submit_id.'"' : "";
            return '<div id="'.$form_id.'" class="yooz_json_form" data-page="'.$ajax_page.'" data-action="'.$ajax_action.'">
                        '.$top_form_html.$formHtml.$before_submit_html.'
                        <button'.$submit_id.' type="submit" tabindex="'.($this->inputItems + 1).'">'.$submit_text.'</button>
                        '.$after_submit_html.'
                    </div>';
        }
        return "ساختار آرایه فرم ایراد دارد.";
    }

    public function get_form_html(array $form_data){
        $form = "";$count=0;
        foreach ($form_data as $sectionID => $section){
            if(!empty($section['items']) && is_array($section['items']) && count($section['items']) > 0){
                $sectionHtml = "";
                foreach ($section['items'] as $item){
                    $count++;
                    $input = $this->validate_form_item($item);
                    $sectionHtml .= $this->get_input($input , $count);
                    if($input['type'] !== "hidden" && $input['type'] !== "color" && $input['type'] !== "image"){$this->inputItems++;}
                    if($input['type'] == "date"){$this->inputItems += 2;}
                }
                $sectionTitle = !empty($section['title']) ? '<h6 class="yoozFormSectionTitle">'.$section['title'].'</h6>' : "";
                $sectionClass = !empty($section['class']) && is_string($section['class']) ? $section['class'] : "";
                $sectionID = !empty($sectionID) ? ' id="yoozForm'.ucfirst($sectionID).'Section"' : "";
                $form .= '<div'.$sectionID.' class="yoozFormSectionItem '.$sectionClass.'">
                             '.$sectionTitle.'
                             <ul class="yoozFormSectionContainer">'.$sectionHtml.'</ul>
                          </div>';
            }

        }

        return $form;
    }

    private function get_form_item(string $input, string $type , string $label , string $input_id , string $item_id = "", string $item_class = ""){
        $item_id = !empty($item_id) ? ' id="'.$item_id.'"' : "";
        $item_class = !empty($item_class) ? " ".$item_class : "";
        $item_class = " yoozForm".ucfirst($type)."Type ".$item_class;
        $inputLabel = !empty($label) ? '<label for="'.$input_id.'" class="yoozFormLabel">'.$label.' :</label>' : "";
        return '<li'.$item_id.' class="yoozFormItem'.$item_class.'">
                    '.$inputLabel.'
                    <div class="yoozFormInputBox">'.$input.'</div>
                </li>';
    }
    private function get_form_input(string $inputHtml){
        return '<div class="yoozFormInputContainer">'.$inputHtml.'</div>';
    }
    private function validate_form_item($data){
        if(is_array($data)){
            $response = [];
            $response['type']           = !empty($data['type']) ? $data['type'] : "text";
            $response['name']           = !empty($data['name']) ? $data['name'] : "بدون عنوان";
            $response['label']          = !empty($data['label']) ? $data['label'] : "";
            $response['placeholder']    = !empty($data['placeholder']) ? $data['placeholder'] : $response['label'];
            $response['placeholder']    = isset($data['hide_placeholder']) && $data['hide_placeholder'] === true ? "" : $response['placeholder'];
            $response['value']          = !empty($data['value']) ? $data['value'] : "";
            if($response['type'] == "multi_selection"){
                $response['value']      = !empty($data['value']) && is_array($data['value']) ? $data['value'] : [];
            }
            $response['value']          = empty($data['value']) && $response['type'] == "image" ? "/public/uploads/emptyImage.jpg" : $response['value'];
            $response['file_id']        = !empty($data['file_id']) && $response['type'] == "image" ? intval($data['file_id']) : "";
            $response['required']       = !empty($data['required']) && $data['required'] === true ? "required" : "";
            $response['readonly']       = !empty($data['readonly']) && $data['readonly'] === true ? 'readonly' : "";
            $response['autocomplete']   = empty($data['autocomplete']) || $data['autocomplete'] === true ? 'on' : 'off';
            $response['input_class']    = !empty($data['input_class']) ? $data['input_class'] : "";
            $response['item_class']     = !empty($data['item_class']) ? $data['item_class'] : "";
            $response['input_id']       = !empty($data['input_id']) ? $data['input_id'] : $response['name']."_yooz_input";
            $response['pattern']        = !empty($data['pattern']) ? $data['pattern'] : "";
            $response['item_id']        = !empty($data['item_id']) ? $data['item_id'] : "";
            $response['options']        = !empty($data['options']) && $response['type'] == "select" ? $this->get_options($data['options'] , $response['value']) : [];
            if($response['type'] == "multi_selection"){
                $response['options']    = !empty($data['options']) ? $this->get_multi_select_options($data['options'] , $response['name'] ,$response['value']) : [];
            }
            $response['library_guide']  = !empty($data['library_guide']) ? $data['library_guide'] : "";
            return $response;
        }
        return false;
    }

    private function get_input(array $input , $index_number = 0){
        $response = "";
        if($input && !empty($input['type']) && in_array($input['type'] , $this->acceptInputs)) {
            if($input['type'] == "text" || $input['type'] == "number" || $input['type'] == "password"){
                $inputHtml = $this->get_input_item($input , $index_number);
            }
            if($input['type'] == "url" || $input['type'] == "tel"){
                $inputHtml = $this->get_input_item($input , $index_number);
            }
            if($input['type'] == "color"){
                $inputHtml = $this->get_color_item($input);
            }
            if($input['type'] == "select" && !empty($input['options'])){
                $inputHtml = $this->get_select_item($input , $index_number);
            }
            if($input['type'] == "multi_selection" && !empty($input['options'])){
                $inputHtml = $this->get_multi_selection_item($input , $index_number);
            }
            if($input['type'] == "textarea"){
                $inputHtml = $this->get_textarea_item($input , $index_number);
            }
            if($input['type'] == "gender"){
                $options = ["0"=>"انتخاب کنید...", "male"=>"آقا", "female"=>"خانم"];
                $input['options'] = $this->get_options($options , $input['value']);
                $inputHtml = $this->get_select_item($input , $index_number);
            }
            if($input['type'] == "date"){
                $inputHtml = $this->get_date_item($input , $index_number);
            }
            if(!empty($inputHtml)){
                $response = $this->get_form_item($inputHtml ,$input['type'] , $input['label'] , $input['input_id'], $input['item_id'] , $input['item_class']);
            }

            if($input['type'] == "hidden"){
                $response = $this->get_hidden_item($input);
            }
        }
        return $response;
    }

    private function get_input_item(array $input , int $index_number){
        $view_pass_icon = "";
        if($input['type'] == 'password'){
            $view_pass_icon = '<div class="showPasswordButton"><span class="fad fa-eye"></span></div>';
            $input['input_class'] = "secret_input ".$input['input_class'];
        }
        $inputClass = !empty($input['input_class']) ? 'class="'.$input['input_class'].'" ' : "";
        $attrs = !empty($input['required']) ? " ".$input['required'] : "";
        $attrs .= !empty($input['readonly']) ? " ".$input['readonly'] : "";
        $pattern = !empty($input['pattern']) ? ' pattern="'.$input['pattern'].'" ' : "";
        $inputHtml = '<input type="'.$input['type'].'" '.$inputClass.'id="'.$input['input_id'].'" name="'.$input['name'].'" value="'.$input['value'].'" tabindex="'.$index_number.'" placeholder="'.$input['placeholder'].'"'.$pattern.$attrs.' autocomplete="'.$input['autocomplete'].'">';
        $inputHtml .= $view_pass_icon;
        return $this->get_form_input($inputHtml);
    }
    private function get_hidden_item(array $input){
        $attrs = !empty($input['input_id']) ? ' id="'.$input['input_id'].'"' : "";
        return '<input type="'.$input['type'].'" name="'.$input['name'].'" value="'.$input['value'].'"'.$attrs.'>';
    }
    private function get_select_item(array $input , int $index_number = 0){
        $inputClass = !empty($input['input_class']) ? 'class="'.$input['input_class'].'" ' : "";
        $inputHtml = '<select type="select" '.$inputClass.'id="'.$input['input_id'].'" name="'.$input['name'].'" tabindex="'.$index_number.'" autocomplete="'.$input['autocomplete'].'">
                         '.$input['options'].'
                      </select>';
        return $this->get_form_input($inputHtml);
    }
    public function get_options($options , string $selected = ""){
        $response = "";
        if(is_array($options)){
            foreach ($options as $value => $text){
                $selectAttr = $selected == $value ? 'selected' : "";
                $response .= '<option value="'.$value.'" '.$selectAttr.'>'.$text.'</option>';
            }
        }
        return $response;
    }
    private function get_multi_selection_item(array $input , int $index_number = 0){
        $html = '<div class="multi_select_container">
                    <div class="multi_select_search_box">
                        <input type="text" class="multi_select_search_input" value="" data-target="'.$input['name'].'_multi_selection" placeholder="جستجو کنید..." tabindex="'.$index_number.'">
                    </div>
                    <ul class="multi_select_items_list" id="'.$input['name'].'_multi_selection">
                        '.$input['options'].'
                    </ul>
                </div>';
        return $this->get_form_input($html);
    }

    private function get_multi_select_options($options , $inputName , array $checked_options = []){
        $response = "";
        if(is_array($options)){
            $counter = 0;
            foreach ($options as $value => $text){
                $counter++;
                $checkedAttr = !empty($checked_options[$value]) ? 'checked' : "";
                $response .= '<li class="multi_select_item" data-text="'.$text.'">
                                  <input type="checkbox" name="'.$inputName.'[]" id="'.$inputName.'-'.$counter.'" value="'.$value.'" '.$checkedAttr.'>
                                  <label for="'.$inputName.'-'.$counter.'">'.$text.'</label>
                              </li>';
            }
        }
        return $response;
    }

    private function get_date_item(array $input , int $index_number = 0){
        $selectedYear = $selectedMonth = $selectedDay = 0;
        if(!empty($input['value'])){
            $timestamp = strtotime($input['value']);
            if($timestamp){
                $selectedYear = JDate::date("Y" , $timestamp);
                $selectedMonth = JDate::date("m" , $timestamp);
                $selectedDay = JDate::date("d" , $timestamp);
            }
        }

        $response = "";
        $years = range(JDate::date('Y') + 5 , 1200);
        $yearsOpts = array_combine($years , $years);
        $yearsOpts = ['0'=>'سال'] + $yearsOpts;
        $monthesOpts = ['0'=>'ماه','1'=>'فروردین','2'=>'اردیبهشت','3'=>'خرداد','4'=>'تیر','5'=>'مرداد','6'=>'شهریور',
                        '7'=>'مهر','8'=>'آبان','9'=>'آذر','10'=>'دی','11'=>'بهمن','12'=>'اسفند'];
        $days = range(1 , 31);
        $daysOpts = array_combine($days , $days);
        $daysOpts = ['0'=>'روز'] + $daysOpts;
        $dateItems = [
            'year'  =>array('options'=>$yearsOpts   , "selected" =>$selectedYear),
            'month' =>array('options'=>$monthesOpts , "selected" =>$selectedMonth),
            'day'   =>array('options'=>$daysOpts    , "selected" =>$selectedDay)
        ];
        $inputName = $input['name'];
        foreach ($dateItems as $dateName => $date_data){
            $input['options'] = $this->get_options($date_data['options'] , $date_data['selected']);
            $input['name'] = $inputName."[$dateName]";
            $response .= $this->get_select_item($input , $index_number);
        }
        return $response;
    }

    private function get_textarea_item(array $input , int $index_number = 0){
        $inputClass = !empty($input['input_class']) ? 'class="'.$input['input_class'].'" ' : "";
        $attrs = !empty($input['required']) ? " ".$input['required'] : "";
        $attrs .= !empty($input['readonly']) ? " ".$input['readonly'] : "";
        $inputHtml = '<textarea '.$inputClass.'id="'.$input['input_id'].'" name="'.$input['name'].'" tabindex="'.$index_number.'" placeholder="'.$input['placeholder'].'"'.$attrs.' autocomplete="'.$input['autocomplete'].'">'.$input['value'].'</textarea>';
        return $this->get_form_input($inputHtml);
    }

    private function get_color_item(array $input){
        $inputClass = !empty($input['input_class']) ? 'class="'.$input['input_class'].'" ' : "";
        $inputHtml = '<input type="color" '.$inputClass.'id="'.$input['input_id'].'" name="'.$input['name'].'" value="'.$input['value'].'">';
        return $this->get_form_input($inputHtml);
    }
}
?>