<?php
namespace Core;
class Site_Options{
    private static $db;
    public static function init(){
        self::$db = new YoozDB();
    }

    public static function get(string $option_name){
        $optionResult = self::$db->select("yooz_options" , "*" , "option_key='$option_name'");
        if($optionResult->rowCount() == 1){
            return $optionResult->fetchObject()->option_value;
        }elseif($optionResult->rowCount() > 1){
            return $optionResult->fetchObject();
        }
        return false;
    }

    public static function update(string $option_name , string|int|float $option_value){
        $checkResult = self::$db->select("yooz_options" , "*" , "option_key='$option_name'");
        if($checkResult->rowCount() > 0){
            $data = array("option_value"=>$option_value);
            $result = self::$db->update("yooz_options" , $data , "option_key='$option_name'");
        }else{
            $data = array("option_key" => $option_name,"option_value"=>$option_value);
            $result = self::$db->insert("yooz_options" , $data);
        }
        return (bool)$result;
    }

    public static function update_all(array $data){
        $updateCount = 0;
        foreach ($data as $option_name => $option_value){
            if(!empty($option_name) && !empty($option_value)){
                $result = self::update($option_name , $option_value);
                if($result){$updateCount++;}
            }
        }
        return array("update_number"=>$updateCount);
    }
}
Site_Options::init();