<?php
namespace Core;

class SMS{
    use ErrorsTrait;
    private string $api_key;
    private string $login_template_id;

    public function __construct(){
        $sms_data = Site_Options::get("app_sms_api");
        if($sms_data && is_array(unserialize($sms_data))){
            $sms_data = unserialize($sms_data);
            if(!empty($sms_data['sms_api_key'])){
                $this->api_key = $sms_data['sms_api_key'];
            }
            if(!empty($sms_data['login_body_id'])){
                $this->login_template_id = $sms_data['login_body_id'];
            }
        }
    }

    public function send_auth_code($phone_number , $otp_code): bool
    {
        if(!empty($this->login_template_id)){
            $patternArguments = '{"name": "code","value": "'.$otp_code.'"}';
            return $this->send_sms($this->login_template_id , $phone_number , $patternArguments);
        }
        return false;
    }
    private function send_sms($templateID , $phoneNumber , $patternArguments){
        if(!empty($this->api_key)){
            $curl = curl_init();
            curl_setopt_array(
                $curl,
                array(
                    CURLOPT_URL => 'https://api.sms.ir/v1/send/verify',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS =>
                    '{
                        "mobile":"'.$phoneNumber.'",
                        "templateId": '.$templateID.',
                        "parameters":['.$patternArguments.']
                    }',
                    CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json',
                        'Accept: text/plain',
                        'x-api-key: '.$this->api_key
                    ),
                )
            );
            $response = curl_exec($curl);
            curl_close($curl);
            $result = json_decode($response);
            if($result && !empty($result->status) && $result->status == '1'){
                return true;
            }
        }
        return false;
    }
}