<?php
namespace Core;

use App\Models\Admin;
use App\Models\UserModel;

class Router {
    private static $ROUTE_SLUG;
    private static $APP_TYPE;
    private static $ROUTE_CONTROLLER;
    private $routes = [];

    public function __construct(){
        $this->add("/notfound" , "notfound" , "index");
    }

    public function add($path, $controller , $action , $login_force = false , $uri_has_parts = false){
        $this->routes[$path] = [
            "path"              => $path,
            "controller"        => $controller,
            "action"            => $action,
            "uri_has_parts"     => $uri_has_parts,
            "login_force"       => $login_force
        ];
    }

    public function dispatch(){
        $route = $this->get_route();
        $controller = $route['controller'];
        $method = $route['action'];
        if(class_exists($controller) && method_exists($controller, $method)){
            if(License::has_access()){
                $controllerInstance = new $controller();
                $controllerInstance->$method();
                echo License::alert_html();
            }
        }
    }

    public function get_route(bool $return_uri = false){
        $route = false;
        $URI_PATH = $this->get_uri();
        foreach ($this->routes as $route_key => $args){
            if(($args['uri_has_parts'] == true && strpos($URI_PATH , $args['path'] , 0) === 0)
                || ($args['uri_has_parts'] == false && $args["path"] === $URI_PATH))
            {
                $route = $this->routes[$route_key];
                if($args["login_force"]){
                    $controller_parts = $this->get_controller_parts($route['controller']);
                    if($controller_parts['app_type'] == "Admin"){
                        $logModel = new Admin();
                        if(!$logModel->is_login()){
                            header("Location: ".ADMIN_URL."/login?back_url=".REQUEST_URL);
                        }
                    }else{
                        $logModel = new UserModel();
                        if(!$logModel->is_login()){
                            header("Location: ".LOGIN_PAGE."?back_url=".REQUEST_URL);
                        }
                    }
                }
                break;
            }
        }
        if($route == false){ $route = $this->routes['/notfound'];}

        $controller_parts = $this->get_controller_parts($route['controller']);
        self::$APP_TYPE = $controller_parts['app_type'];
        self::$ROUTE_SLUG = $controller_parts['app_slug'];
        self::$ROUTE_CONTROLLER = $controller_parts['controller'];

        return ($return_uri) ? $route['uri'] : $route;
    }

    public function get_controller_parts(string $controller){
        $response = ['app_type' => '' , 'app_slug' => '', 'controller' => ''];
        $controllerParts = explode("\\" ,$controller);
        if(!empty($controllerParts[2])){
            $response['controller'] = !empty($controllerParts[3]) ? strtolower(str_replace("_Controller" , "" ,$controllerParts[3])) : "";
            $response['app_type'] = $controllerParts[2];
            $appTypeForSlug = $controllerParts[2] == "Admin" ? "Admin" : strtolower($controllerParts[2]);
            $response['app_slug'] = strtolower($appTypeForSlug."_".str_replace("_Controller" , "",end($controllerParts)));
        }
        return $response;
    }
    public static function get_route_slug(){
        return self::$ROUTE_SLUG;
    }
    public static function set_route_slug(string $slug): void{
        self::$ROUTE_SLUG = $slug;
    }
    public static function get_controller(){
        return self::$ROUTE_CONTROLLER;
    }
    public static function get_app_type(){
        return self::$APP_TYPE;
    }


    private function get_uri(){
        $Request_URI = $this->clear_uri($_SERVER['REQUEST_URI']);
        $URI_PATH = parse_url($Request_URI)['path'];
        $URI_PATH = str_replace("//" , "/" , $URI_PATH);

        $PATH = "/";
        $explodeURI = explode("/" , $URI_PATH);
        foreach ($explodeURI as $uri_component){
            if(!empty($uri_component)){
                $PATH .= ($PATH == "/") ? $uri_component : "/".$uri_component;
            }
        }
        return mb_strtolower($PATH);
    }

    /* this function is declared to remove illegal and special characters from url */
    private function clear_uri($uri){
        return htmlspecialchars(stripslashes(trim($uri)));
    }
}
?>