<?php
if(!empty("YOOZ_ROOT")){
    function get_license_alert_html($expireDistance){
        $expireDistance = \Core\Utils::PersianNumber($expireDistance);
        $api_link = \Core\License::url();
        return <<<HTML
            <div id="license_alert_popup_container" class="isActive">
                <div id="license_alert_popup">
                    <div id="license_popup_header">
                        <p>اخطار</p>
                        <span id="license_popup_closer"></span>
                    </div>
                    <div id="license_popup_text">
                        <h3>اتمام تاریخ لایسنس</h3>
                        <p><strong>مدیریت محترم</strong></p>
                        <p>{$expireDistance} روز تا انقضای لایسنس شما زمان باقی مانده است. لطفا نسبت به تمدید پنل خود از طریق لینک زیر اقدام نمایید. درصورت عدم تمدید ، پنل شما پس از رسیدن به تاریخ انقضا، مسدود خواهد شد.</p>
                        <p style="text-align:left;">
                           <a href="{$api_link}">{$api_link}</a> 
                        </p>
                    </div>
                </div>
            </div>
            <style>
                #license_alert_popup_container{display:none;position:fixed;z-index:199000;width:100%;height:100%;top:0;right:0;background-color:rgba(0,0,0,0.6);}
                #license_alert_popup_container.isActive{display:block !important;}
                #license_alert_popup{
                    position:absolute;z-index:200000;width:600px;
                    max-width:96%;max-height:96%;top:50%;left:50%;transform:translate(-50%,-50%);
                    padding:10px;background-color:var(--panel-boxes-bg);
                    border-radius:15px;overflow-y:auto;overflow-x:hidden;user-select:none;
                }
                #license_alert_popup.isActive{display:block !important;}
                #license_popup_header{position:relative;height:40px;border-radius:10px;background-color:rgba(0,0,0,0.03);text-align:center;line-height:40px;}
                #license_popup_closer{position:absolute;width:30px;height:30px;top:5px;left:5px;border-radius:10px;cursor:pointer;}
                #license_popup_closer::before, #license_popup_closer::after {
                    position:absolute;content:"";width:80%;height:2px;top:50%;left:50%;
                    transform:translate(-50%,-50%) rotate(45deg);background-color:#cd1818;
                }
                #license_popup_closer::after {transform:translate(-50%,-50%) rotate(-45deg);}
                #license_popup_header p{font-size:1.3em;font-weight:700;color:#cd1818;}
                #license_popup_text{margin-top:20px;text-align:center;}
                #license_popup_text h3{font-size:1.3em;text-align:center;}
                #license_popup_text p{margin-top:15px;font-size:1.2em;text-align:center;}
                #license_popup_text a{color:#0098ff;text-align:center;}
            </style>
            
            <script>
                document.getElementById('license_popup_closer').addEventListener('click', function() {
                    let licenseAlertPopup = document.getElementById('license_alert_popup_container');
                    if (licenseAlertPopup) {
                        licenseAlertPopup.classList.remove('isActive');
                    }
                });
            </script>
        HTML;
    }
}
?>
