<?php
namespace Core;
require_once __DIR__."/../vendor/jdf.php";
class JDate{
    public static function date($format,$timestamp='',$none='',$time_zone='Asia/Tehran',$tr_num='en'){
        return jdate($format,$timestamp,$none,$time_zone,$tr_num);
    }
    public static function getDate($timestamp='',$none='',$timezone='Asia/Tehran',$tn='en'){
        return jgetdate($timestamp,$none,$timezone,$tn);
    }
    public static function getFullDate($timestamp='',$none='',$timezone='Asia/Tehran',$tn='en'){
        $date = jgetdate($timestamp,$none,$timezone,$tn);
        foreach ($date as $key => $val){
            if(is_numeric($val)){$date["f_".$key] = $val < 10 ? "0".$val : $val;}
        }
        return $date;
    }
    public static function to_greg_date(int $Y, int $m, int $d, int|null $H = null, int|null $i = null, int|null $s = null , string $format = "Y-m-d H:i:s"){
        $dateArray = jalali_to_gregorian($Y , $m , $d);
        $g_H = !empty($H) && $H < 24 && $H >= 0 ? $H : date("H");
        $g_i = !empty($i) && $i < 60 && $i >= 0 ? $i : date("i");
        $g_s = !empty($s) && $s < 60 && $s >= 0 ? $s : date("s");
        $g_d = !empty($dateArray[2]) ? $dateArray[2] : date("d");
        $g_m = !empty($dateArray[1]) ? $dateArray[1] : date("m");
        $g_Y = !empty($dateArray[0]) ? $dateArray[0] : date("Y");
        return date($format ,  mktime($g_H,$g_i,$g_s,$g_m,$g_d,$g_Y));
    }
}