<?php
namespace Core;

use Core\Validators\Phone_Validator;

class Installer{
    use ErrorsTrait;
    private string $installer_config_path = __DIR__."/../config/Installer_Conf.php";
    public function __construct($config_file_path)
    {
        if(!file_exists($config_file_path)){
            $page = "index";
            if(!empty($_GET['page'])){
                if($_GET['page'] == "admin_info"){
                    $page = "admin_info";
                }
                if($_GET['page'] == "complete_installation"){
                    $page = "complete_installation";
                }
            }
            $this->$page();
        }else{
            header("Location: ".ADMIN_URL."/login");
        }
    }

    private function index(){
        require_once __DIR__."/installer_view/installer_index.php";
    }

    private function admin_info(){
        if(!empty($_POST['db_name']) && !empty($_POST['db_user']) && isset($_POST['db_password']) && !empty($_POST['db_host'])){
            $db_name        = Utils::test_input($_POST['db_name']);
            $db_user        = Utils::test_input($_POST['db_user']);
            $db_password    = Utils::test_input($_POST['db_password']);
            $db_host        = Utils::test_input($_POST['db_host']);
            if($this->check_database($db_name , $db_user , $db_password , $db_host)){
                require_once __DIR__."/installer_view/installer_admin_info.php";
            }
        }else{
            $this->set_error("تمام اطلاعات مربوط به دیتابیس را وارد نمایید.");
        }

        if($this->has_error()){
            $message = $this->get_errors_text();
            echo '<script>alert("'.$message.'");history.go(-1);</script>';
        }
    }

    private function complete_installation(){
        if(file_exists($this->installer_config_path)){
            if(!empty($_POST['license_key']) && !empty($_POST['display_name']) && !empty($_POST['username']) && !empty($_POST['password']) && !empty($_POST['phone'])){
                $phoneValidator = new Phone_Validator();
                $license_key = Utils::test_input($_POST['license_key']);
                $display_name = Utils::test_input($_POST['display_name']);
                $username = Utils::EnglishNumber(Utils::test_input($_POST['username']));
                $password = Utils::EnglishNumber(Utils::test_input($_POST['password']));
                $phone = Utils::EnglishNumber(Utils::test_input($_POST['phone']));

                /* validate data */
                if(!preg_match("/^[a-zA-Z0-9]{5,}$/" , $username)){
                    $this->set_error("نام کاربری باید شامل حروف و اعداد انگلیسی بوده و تعداد کاراکتر های آن ۵ کاراکتر و یا بیشتر باشد.");
                }
                if(!$phoneValidator->validate($phone)){
                    $this->set_error("شماره موبایل معتبر نیست. شماره موبایل باید با 09 آغاز شود و ۱۱ رقمی باشد.");
                }
                if(!$this->is_acceptable_password($password)){
                    $this->set_error("رمز عبور باید شامل اعداد، حروف بزرگ و کوچک انگلیسی به همراه کاراکتر های خاص باشد. همچنین تعداد کاراکتر های آن باید بین ۶ تا ۱۸ عدد باشد.");
                }
                define("DONT_INIT_LICENCE" , false);
                if(!License::check_license_key($license_key)){
                    $this->set_error("کلید لایسنس نامعتبر است.");
                }

                if(!$this->has_error()){
                    $admin_data = [
                        'display_name'  => $display_name,
                        'username'      => $username,
                        'password'      => md5($password),
                        'phone'         => $phone,
                    ];
                    $db_creation = $this->create_database($admin_data , $license_key);
                    if($db_creation){
                        //rename the installer config file to main config file
                        $mainConfigPath = __DIR__."/../config/config.php";
                        rename($this->installer_config_path , $mainConfigPath);
                        require_once __DIR__."/installer_view/installer_welcome.php";
                    }
                }

            }else{
                $this->set_error("اطلاعات خواسته شده را به طور کامل وارد کنید.");
            }
        }else{
            $this->set_error("فایل کانفیگ مربوط به نصب کننده یافت نشد! لطفا فرآیند نصب را دوباره تکرار کنید.");
        }

        if($this->has_error()){
            $message = $this->get_errors_text();
            echo '<script>alert("'.$message.'");history.go(-1);</script>';
        }
    }

    private function check_database($db_name , $db_user , $db_password , $db_host){
        $installerConfPath = $this->installer_config_path;
        $file = fopen($installerConfPath , "w");
        if($file){
            $content = "<?php\n";
            $content .= "/* enter the host name and don't remove or change the name of constant */\n";
            $content .= "define(\"YOOZ_DB_HOST\", \"$db_host\");\n";
            $content .= "/* enter admin username of database and don't remove or change the name of constant */\n";
            $content .= "define(\"YOOZ_DB_USER\", \"$db_user\");\n";
            $content .= "/* enter password of admin user and don't remove or change the name of constant */\n";
            $content .= "define(\"YOOZ_DB_PASSWORD\", \"$db_password\");\n";
            $content .= "/* enter the name of database and don't remove or change the name of constant */\n";
            $content .= "define(\"YOOZ_DB_NAME\", \"$db_name\");\n";
            $content .= "?>";

            fwrite($file, $content);
            fclose($file);

            define("CONF_PATH" , $installerConfPath);
            $yooz_db = new YoozDB();
            if($yooz_db->check_connection()){
                return true;
            }else{
                $this->set_error("اتصال به دیتابیس ناموفق بود! لطفا اطلاعات وارد شده را مجددا بررسی نمایید.");
            }
        }else{
            $this->set_error("ایجاد فایل کانفیگ با شکست مواجه شد. لطفا دوباره امتحان کنید.");
        }
        return false;
    }
    private function is_acceptable_password($password):bool{
        $pattern = '/^(?=.*[A-Z])(?=.*[\W_])(?=^[^ ]+$).{6,18}$/';
        return (bool)preg_match($pattern, $password);
    }

    private function create_database($admin_data , $license_key){
        if(file_exists($this->installer_config_path)){
            define("CONF_PATH" , $this->installer_config_path);
            $yooz_db = new YoozDB();
            if($yooz_db->check_connection()){
                require_once __DIR__."/Database/database.php";
                if(!empty($_YOOZ_DB_QUERIES) && is_array($_YOOZ_DB_QUERIES) && !empty($_YOOZ_DB_INDEXES) && is_array($_YOOZ_DB_INDEXES)){
                    foreach ($_YOOZ_DB_QUERIES as $table_name => $QUERY){
                        if(!$yooz_db->table_exists($table_name)){
                            $yooz_db->exec($QUERY);
                        }
                    }
                    foreach ($_YOOZ_DB_INDEXES as $INDEX){
                        $yooz_db->exec($INDEX);
                    }
                    
                    if($yooz_db->table_exists("yooz_options")){
                        $upldate_result = Site_Options::update("_yooz_app_license_key_" , $license_key);
                        if($upldate_result){
                            if($yooz_db->table_exists("yooz_admins")){
                                $result = $yooz_db->insert("yooz_admins" , $admin_data);
                                if($result){
                                    return true;
                                }else{
                                    $this->set_error("افزودن اطلاعات مدیر سایت با شکست مواجه شد. لطفا دوباره تلاش کنید.");
                                }
                            }else{
                                $this->set_error("ساخت جداول در پایگاه داده با شکست مواجه شد. لطفا دوباره تلاش کنید.");
                            }
                        }else{
                            $this->set_error("تنظیم کلید لایسنس ناموفق بود");
                        }
                    }else{
                        $this->set_error("جدول تنظیمات ایجاد نشد!");
                    }
                }else{
                    $this->set_error("اطلاعات جداول دیتابیس یافت نشد!");
                }
            }else{
                $this->set_error("اتصال به دیتابیس ناموفق بود! لطفا دوباره تلاش کنید.");
            }
        }else{
            $this->set_error("فایل کانفیگ مربوط به نصب کننده یافت نشد.");
        }
    }
}



