<?php
$_YOOZ_DB_QUERIES = [
    "city" =>
        "CREATE TABLE `city` (
            `id` INT NOT NULL AUTO_INCREMENT,
            `province` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            `city` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            `province_id` INT NOT NULL DEFAULT 0,
            PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",

    "yooz_admins" =>
        "CREATE TABLE `yooz_admins` (
            `admin_ID` INT NOT NULL AUTO_INCREMENT,
            `display_name` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            `username` VARCHAR(64) COLLATE utf8mb4_persian_ci NOT NULL,
            `phone` VARCHAR(256) COLLATE utf8mb4_persian_ci NOT NULL,
            `password` VARCHAR(512) COLLATE utf8mb4_persian_ci NOT NULL,
            `reset_password_token` VARCHAR(512) COLLATE utf8mb4_persian_ci DEFAULT NULL,
            `reset_token_expire` DATETIME DEFAULT NULL,
            `session_token` VARCHAR(512) COLLATE utf8mb4_persian_ci NOT NULL,
            `privileges` MEDIUMTEXT COLLATE utf8mb4_persian_ci NOT NULL,
            `profile_image_id` INT NOT NULL DEFAULT 0,
            PRIMARY KEY (`admin_ID`),
            UNIQUE KEY `username` (`username`),
            UNIQUE KEY `phone` (`phone`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",

    "yooz_file_manager" =>
        "CREATE TABLE `yooz_file_manager` (
            `file_ID` INT UNSIGNED NOT NULL AUTO_INCREMENT,
            `file_type` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            `file_name` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            `file_title` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            `file_url` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            `file_path` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            `server_url` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            `file_data` LONGTEXT COLLATE utf8mb4_persian_ci NOT NULL,
            PRIMARY KEY (`file_ID`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",

    "yooz_game_cards" =>
        "CREATE TABLE `yooz_game_cards` (
            `card_ID` INT NOT NULL AUTO_INCREMENT,
            `card_name` VARCHAR(256) COLLATE utf8mb4_persian_ci NOT NULL,
            `card_text` TEXT COLLATE utf8mb4_persian_ci NOT NULL,
            `card_title` TEXT COLLATE utf8mb4_persian_ci NOT NULL,
            `card_description` TEXT COLLATE utf8mb4_persian_ci NOT NULL,
            `card_coins` INT NOT NULL DEFAULT 0,
            `card_bg_color` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            `recharge_time` INT NOT NULL DEFAULT 0,
            `recharge_timing` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            `card_image_id` INT NOT NULL DEFAULT 0,
            `display_status` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            PRIMARY KEY (`card_ID`),
            UNIQUE KEY `card_name` (`card_name`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",

    "yooz_game_events" =>
        "CREATE TABLE `yooz_game_events` (
            `event_ID` INT NOT NULL AUTO_INCREMENT,
            `event_name` VARCHAR(256) COLLATE utf8mb4_persian_ci NOT NULL,
            `event_title` TEXT COLLATE utf8mb4_persian_ci NOT NULL,
            `event_description` TEXT COLLATE utf8mb4_persian_ci NOT NULL,
            `required_coins` INT NOT NULL DEFAULT 0,
            `event_expire` DATETIME NOT NULL,
            `event_image_id` INT NOT NULL DEFAULT 0,
            `event_status` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            PRIMARY KEY (`event_ID`),
            UNIQUE KEY `event_name` (`event_name`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",

    "yooz_game_gifts" =>
        "CREATE TABLE `yooz_game_gifts` (
            `gift_ID` INT NOT NULL AUTO_INCREMENT,
            `gift_name` VARCHAR(256) COLLATE utf8mb4_persian_ci NOT NULL,
            `gift_description` TEXT COLLATE utf8mb4_persian_ci NOT NULL,
            `gift_claim_description` TEXT COLLATE utf8mb4_persian_ci NOT NULL,
            `required_coins` INT NOT NULL DEFAULT 0,
            `gift_expire_time` INT NOT NULL DEFAULT 0,
            `gift_expire_timing` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            `gift_image_id` INT NOT NULL DEFAULT 0,
            `gift_status` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            PRIMARY KEY (`gift_ID`),
            UNIQUE KEY `gift_name` (`gift_name`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",

    "yooz_game_missions" =>
        "CREATE TABLE `yooz_game_missions` (
            `mission_ID` INT NOT NULL AUTO_INCREMENT,
            `mission_title` VARCHAR(256) COLLATE utf8mb4_persian_ci NOT NULL,
            `mission_description` TEXT COLLATE utf8mb4_persian_ci NOT NULL,
            `mission_button_label` TEXT COLLATE utf8mb4_persian_ci NOT NULL,
            `mission_button_link` TEXT COLLATE utf8mb4_persian_ci NOT NULL,
            `mission_coins` INT NOT NULL DEFAULT 0,
            `mission_bg_color` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            `mission_image_id` INT NOT NULL DEFAULT 0,
            `display_status` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            PRIMARY KEY (`mission_ID`),
            UNIQUE KEY `mission_title` (`mission_title`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",

    "yooz_guess_codes" =>
        "CREATE TABLE `yooz_guess_codes` (
            `guess_ID` INT NOT NULL AUTO_INCREMENT,
            `guess_code` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            `guess_description` TEXT COLLATE utf8mb4_persian_ci NOT NULL,
            `fine_coins` INT NOT NULL DEFAULT 0,
            `gift_coins` INT NOT NULL DEFAULT 0,
            `guess_image_id` INT NOT NULL DEFAULT 0,
            `expiration_date` DATETIME NOT NULL,
            `display_status` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            PRIMARY KEY (`guess_ID`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",

    "yooz_interactive_messages" =>
        "CREATE TABLE `yooz_interactive_messages` (
            `message_ID` INT NOT NULL AUTO_INCREMENT,
            `message_title` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            `message_text` TEXT COLLATE utf8mb4_persian_ci NOT NULL,
            `gift_coins` INT NOT NULL DEFAULT 0,
            `conditions` TEXT COLLATE utf8mb4_persian_ci NOT NULL,
            `message_image_id` INT NOT NULL DEFAULT 0,
            PRIMARY KEY (`message_ID`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",

    "yooz_options" =>
        "CREATE TABLE `yooz_options` (
            `option_ID` INT NOT NULL AUTO_INCREMENT,
            `option_key` VARCHAR(512) COLLATE utf8mb4_persian_ci NOT NULL,
            `option_value` LONGTEXT COLLATE utf8mb4_persian_ci NOT NULL,
            PRIMARY KEY (`option_ID`),
            UNIQUE KEY `option_key` (`option_key`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",

    "yooz_usermeta" =>
        "CREATE TABLE `yooz_usermeta` (
            `user_meta_ID` INT NOT NULL AUTO_INCREMENT,
            `user_ID` INT NOT NULL DEFAULT 0,
            `meta_key` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            `meta_value` TEXT COLLATE utf8mb4_persian_ci NOT NULL,
            PRIMARY KEY (`user_meta_ID`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",

    "yooz_users" =>
        "CREATE TABLE `yooz_users` (
            `user_ID` INT NOT NULL AUTO_INCREMENT,
            `display_name` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            `phone` VARCHAR(256) COLLATE utf8mb4_persian_ci NOT NULL,
            `otp_token` VARCHAR(512) COLLATE utf8mb4_persian_ci NOT NULL,
            `otp_code` VARCHAR(256) COLLATE utf8mb4_persian_ci DEFAULT NULL,
            `otp_expire` DATETIME DEFAULT NULL,
            `session_token` VARCHAR(512) COLLATE utf8mb4_persian_ci DEFAULT NULL,
            `user_register_date` DATE DEFAULT NULL,
            `inviter_ID` INT NOT NULL DEFAULT 0,
            `total_score` INT NOT NULL DEFAULT 0,
            `tour_guide` INT NOT NULL DEFAULT 0,
            PRIMARY KEY (`user_ID`),
            UNIQUE KEY `phone` (`phone`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",

    "yooz_user_cards" =>
        "CREATE TABLE `yooz_user_cards` (
            `user_ID` INT NOT NULL DEFAULT 0,
            `card_ID` INT NOT NULL DEFAULT 0,
            `card_claim_time` DATETIME NOT NULL DEFAULT (CURRENT_TIMESTAMP()),
            `card_claim_coins` INT NOT NULL DEFAULT 0
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",

    "yooz_user_coins" =>
        "CREATE TABLE `yooz_user_coins` (
            `user_ID` INT NOT NULL DEFAULT 0,
            `get_coins` INT NOT NULL DEFAULT 0,
            `coins_achieve_time` DATETIME NOT NULL DEFAULT (CURRENT_TIMESTAMP())
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",

    "yooz_user_daily" =>
        "CREATE TABLE `yooz_user_daily` (
            `user_ID` INT NOT NULL DEFAULT 0,
            `daily_last_claim` DATE NOT NULL,
            `daily_claim_coins` INT NOT NULL DEFAULT 0
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",

    "yooz_user_events" =>
        "CREATE TABLE `yooz_user_events` (
            `user_ID` INT NOT NULL DEFAULT 0,
            `event_ID` INT NOT NULL DEFAULT 0,
            `claim_event_time` DATETIME NOT NULL DEFAULT (CURRENT_TIMESTAMP()),
            `event_spent_coins` INT NOT NULL DEFAULT 0,
            `event_usage_status` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",

    "yooz_user_gifts" =>
        "CREATE TABLE `yooz_user_gifts` (
            `user_gift_ID` INT NOT NULL AUTO_INCREMENT,
            `gift_ID` INT NOT NULL DEFAULT 0,
            `user_ID` INT NOT NULL DEFAULT 0,
            `claim_gift_time` DATETIME NOT NULL DEFAULT (CURRENT_TIMESTAMP()),
            `gift_expire` DATETIME NOT NULL DEFAULT (CURRENT_TIMESTAMP()),
            `gift_spent_coins` INT NOT NULL DEFAULT 0,
            `gift_usage_status` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            PRIMARY KEY (`user_gift_ID`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",

    "yooz_user_guess" =>
        "CREATE TABLE `yooz_user_guess` (
            `user_ID` INT NOT NULL DEFAULT 0,
            `guess_ID` INT NOT NULL DEFAULT 0,
            `guess_claim_time` DATETIME NOT NULL DEFAULT (CURRENT_TIMESTAMP()),
            `guess_claim_coins` INT NOT NULL DEFAULT 0
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",

    "yooz_user_medals" =>
        "CREATE TABLE `yooz_user_medals` (
            `user_medal_ID` INT NOT NULL AUTO_INCREMENT,
            `user_ID` INT NOT NULL DEFAULT 0,
            `medal_achieve_date` DATETIME NOT NULL DEFAULT (CURRENT_TIMESTAMP()),
            PRIMARY KEY (`user_medal_ID`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",

    "yooz_user_missions" =>
        "CREATE TABLE `yooz_user_missions` (
            `user_ID` INT NOT NULL DEFAULT 0,
            `mission_ID` INT NOT NULL DEFAULT 0,
            `mission_claim_time` DATETIME NOT NULL DEFAULT (CURRENT_TIMESTAMP()),
            `mission_claim_coins` INT NOT NULL DEFAULT 0,
            `claim_status` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",

    "yooz_user_notifications" =>
        "CREATE TABLE `yooz_user_notifications` (
            `notification_ID` INT NOT NULL AUTO_INCREMENT,
            `user_ID` INT NOT NULL DEFAULT 0,
            `message_ID` INT NOT NULL DEFAULT 0,
            `notification_title` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            `notification_text` TEXT COLLATE utf8mb4_persian_ci NOT NULL,
            `notification_image` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            `notification_coins` INT NOT NULL DEFAULT 0,
            `notification_status` VARCHAR(255) COLLATE utf8mb4_persian_ci NOT NULL,
            `create_time` DATETIME NOT NULL DEFAULT (CURRENT_TIMESTAMP()),
            PRIMARY KEY (`notification_ID`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci",
]; 

$_YOOZ_DB_INDEXES = [
    "INSERT INTO `city` (`id`, `province`, `city`, `province_id`) VALUES
        (9, 'آذربایجان شرقی', 'آذرشهر', 1),
        (10, 'آذربایجان شرقی', 'تیمورلو', 1),
        (11, 'آذربایجان شرقی', 'گوگان', 1),
        (12, 'آذربایجان شرقی', 'ممقان', 1),
        (13, 'آذربایجان شرقی', 'ایلخچی', 1),
        (14, 'آذربایجان شرقی', 'اسکو', 1),
        (15, 'آذربایجان شرقی', 'شهر جدید سهند', 1),
        (16, 'آذربایجان شرقی', 'اهر', 1),
        (17, 'آذربایجان شرقی', 'هوراند', 1),
        (18, 'آذربایجان شرقی', 'تیکمه داش', 1),
        (19, 'آذربایجان شرقی', 'بستان آباد', 1),
        (20, 'آذربایجان شرقی', 'بناب', 1),
        (21, 'آذربایجان شرقی', 'خسروشاه', 1),
        (22, 'آذربایجان شرقی', 'باسمنج', 1),
        (23, 'آذربایجان شرقی', 'تبریز', 1),
        (24, 'آذربایجان شرقی', 'سردرود', 1),
        (25, 'آذربایجان شرقی', 'سیه رود', 1),
        (26, 'آذربایجان شرقی', 'جلفا', 1),
        (27, 'آذربایجان شرقی', 'هادیشهر', 1),
        (28, 'آذربایجان شرقی', 'قره آغاج', 1),
        (29, 'آذربایجان شرقی', 'خمارلو', 1),
        (30, 'آذربایجان شرقی', 'سراب', 1),
        (31, 'آذربایجان شرقی', 'دوزدوزان', 1),
        (32, 'آذربایجان شرقی', 'شربیان', 1),
        (33, 'آذربایجان شرقی', 'مهربان', 1),
        (34, 'آذربایجان شرقی', 'تسوج', 1),
        (35, 'آذربایجان شرقی', 'صوفیان', 1),
        (36, 'آذربایجان شرقی', 'خامنه', 1),
        (37, 'آذربایجان شرقی', 'سیس', 1),
        (38, 'آذربایجان شرقی', 'شبستر', 1),
        (39, 'آذربایجان شرقی', 'شرفخانه', 1),
        (40, 'آذربایجان شرقی', 'شند آباد', 1),
        (41, 'آذربایجان شرقی', 'وایقان', 1),
        (42, 'آذربایجان شرقی', 'کوزه کنان', 1),
        (43, 'آذربایجان شرقی', 'جوان قلعه', 1),
        (44, 'آذربایجان شرقی', 'عجب شیر', 1),
        (45, 'آذربایجان شرقی', 'خداجو', 1),
        (46, 'آذربایجان شرقی', 'مراغه', 1),
        (47, 'آذربایجان شرقی', 'بناب مرند', 1),
        (48, 'آذربایجان شرقی', 'زنوز', 1),
        (49, 'آذربایجان شرقی', 'مرند', 1),
        (50, 'آذربایجان شرقی', 'کشکسرای', 1),
        (51, 'آذربایجان شرقی', 'یامچی', 1),
        (52, 'آذربایجان شرقی', 'لیلان', 1),
        (53, 'آذربایجان شرقی', 'مبارک شهر', 1),
        (54, 'آذربایجان شرقی', 'ملکان', 1),
        (55, 'آذربایجان شرقی', 'ترکمانچای', 1),
        (56, 'آذربایجان شرقی', 'آچاچی', 1),
        (57, 'آذربایجان شرقی', 'میانه', 1),
        (58, 'آذربایجان شرقی', 'آقکند', 1),
        (59, 'آذربایجان شرقی', 'ترک', 1),
        (60, 'آذربایجان شرقی', 'خواجه', 1),
        (61, 'آذربایجان شرقی', 'بخشایش', 1),
        (62, 'آذربایجان شرقی', 'زرنق', 1),
        (63, 'آذربایجان شرقی', 'هریس', 1),
        (64, 'آذربایجان شرقی', 'کلوانق', 1),
        (65, 'آذربایجان شرقی', 'هشترود', 1),
        (66, 'آذربایجان شرقی', 'نظرکهریزی', 1),
        (67, 'آذربایجان شرقی', 'خاروانا', 1),
        (68, 'آذربایجان شرقی', 'ورزقان', 1),
        (69, 'آذربایجان شرقی', 'آبش احمد', 1),
        (70, 'آذربایجان شرقی', 'کلیبر', 1),
        (71, 'آذربایجان شرقی', 'اغچه ریش', 1),
        (72, 'آذربایجان شرقی', 'خاتون اباد-آذربایجان شرقی', 1),
        (73, 'آذربایجان شرقی', 'شیخدراباد', 1),
        (74, 'آذربایجان شرقی', 'قره بلاغ-آذربایجان شرقی', 1),
        (75, 'آذربایجان شرقی', 'اچاچی', 1),
        (76, 'آذربایجان شرقی', 'گوندوغدی', 1),
        (77, 'آذربایجان شرقی', 'پورسخلو', 1),
        (78, 'آذربایجان شرقی', 'کنگاور-آذربایجان شرقی', 1),
        (79, 'آذربایجان شرقی', 'قویوجاق', 1),
        (80, 'آذربایجان شرقی', 'ارموداق', 1),
        (81, 'آذربایجان شرقی', 'کهنمو', 1),
        (82, 'آذربایجان شرقی', 'اربط', 1),
        (83, 'آذربایجان شرقی', 'خسرو شهر', 1),
        (84, 'آذربایجان شرقی', 'لاهیجان-آذربایجان شرقی', 1),
        (85, 'آذربایجان شرقی', 'خاص اباد (خاصبان )', 1),
        (86, 'آذربایجان شرقی', 'سرای (سرای ده )', 1),
        (87, 'آذربایجان شرقی', 'کجوار', 1),
        (88, 'آذربایجان شرقی', 'خلجان', 1),
        (89, 'آذربایجان شرقی', 'ینگی اسپران (سفیدان جد', 1),
        (90, 'آذربایجان شرقی', 'شادبادمشایخ (پینه شلوا', 1),
        (91, 'آذربایجان شرقی', 'کندرود', 1),
        (92, 'آذربایجان شرقی', 'مایان سفلی', 1),
        (93, 'آذربایجان شرقی', 'خراجو', 1),
        (94, 'آذربایجان شرقی', 'قدمگاه (بادام یار)', 1),
        (95, 'آذربایجان شرقی', 'شیرامین', 1),
        (96, 'آذربایجان شرقی', 'هفت چشمه-آذربایجان شرقی', 1),
        (97, 'آذربایجان شرقی', 'امند', 1),
        (98, 'آذربایجان شرقی', 'مینق', 1),
        (99, 'آذربایجان شرقی', 'سرند', 1),
        (100, 'آذربایجان شرقی', 'بیلوردی', 1),
        (101, 'آذربایجان شرقی', 'گلین قیه', 1),
        (102, 'آذربایجان شرقی', 'هرزندجدید (چای هرزند)', 1),
        (103, 'آذربایجان شرقی', 'بناب جدید', 1),
        (104, 'آذربایجان شرقی', 'دولت اباد-آذربایجان شرقی', 1),
        (105, 'آذربایجان شرقی', 'یکان کهریز', 1),
        (106, 'آذربایجان شرقی', 'شجاع', 1),
        (107, 'آذربایجان شرقی', 'داران-آذربایجان شرقی', 1),
        (108, 'آذربایجان شرقی', 'نوجه مهر', 1),
        (109, 'آذربایجان شرقی', 'چول قشلاقی', 1),
        (110, 'آذربایجان شرقی', 'ورگهان', 1),
        (111, 'آذربایجان شرقی', 'افیل', 1),
        (112, 'آذربایجان شرقی', 'اذغان (ازغان )', 1),
        (113, 'آذربایجان شرقی', 'سیه کلان', 1),
        (114, 'آذربایجان شرقی', 'اق براز', 1),
        (115, 'آذربایجان شرقی', 'مولان', 1),
        (116, 'آذربایجان شرقی', 'عاشقلو', 1),
        (117, 'آذربایجان شرقی', 'اسکلو (اسگلو)', 1),
        (118, 'آذربایجان شرقی', 'یوزبند', 1),
        (119, 'آذربایجان شرقی', 'شهرک صنعتی کاغذکنان', 1),
        (120, 'آذربایجان شرقی', 'کندوان', 1),
        (121, 'آذربایجان شرقی', 'تیل', 1),
        (122, 'آذربایجان شرقی', 'لاریجان', 1),
        (123, 'آذربایجان شرقی', 'اسبفروشان', 1),
        (124, 'آذربایجان شرقی', 'ابرغان', 1),
        (125, 'آذربایجان شرقی', 'رازلیق', 1),
        (126, 'آذربایجان شرقی', 'اغمیون', 1),
        (127, 'آذربایجان شرقی', 'اردها', 1),
        (128, 'آذربایجان شرقی', 'قره چای حاج علی', 1),
        (129, 'آذربایجان شرقی', 'قره بابا', 1),
        (130, 'آذربایجان شرقی', 'سعیداباد-آذربایجان شرقی', 1),
        (131, 'آذربایجان شرقی', 'الانق', 1),
        (132, 'آذربایجان شرقی', 'کردکندی', 1),
        (133, 'آذربایجان شرقی', 'قره چمن', 1),
        (134, 'آذربایجان شرقی', 'ورجوی', 1),
        (135, 'آذربایجان شرقی', 'گل تپه-آذربایجان شرقی', 1),
        (136, 'آذربایجان شرقی', 'داش اتان', 1),
        (137, 'آذربایجان شرقی', 'داش بلاغ بازار', 1),
        (138, 'آذربایجان شرقی', 'صومعه', 1),
        (139, 'آذربایجان شرقی', 'علویان', 1),
        (140, 'آذربایجان شرقی', 'شیراز-آذربایجان شرقی', 1),
        (141, 'آذربایجان شرقی', 'خضرلو', 1),
        (142, 'آذربایجان شرقی', 'ینگجه', 1),
        (143, 'آذربایجان شرقی', 'مهماندار', 1),
        (144, 'آذربایجان شرقی', 'خانیان', 1),
        (145, 'آذربایجان شرقی', 'دانالو', 1),
        (146, 'آذربایجان شرقی', 'رحمانلو', 1),
        (147, 'آذربایجان شرقی', 'زاوشت', 1),
        (148, 'آذربایجان شرقی', 'القو', 1),
        (149, 'آذربایجان شرقی', 'روشت بزرگ', 1),
        (150, 'آذربایجان شرقی', 'خوشه مهر (خواجه امیر)', 1),
        (151, 'آذربایجان شرقی', 'زوارق', 1),
        (152, 'آذربایجان شرقی', 'خانه برق قدیم (شورخانه ب', 1),
        (153, 'آذربایجان شرقی', 'لکلر', 1),
        (154, 'آذربایجان شرقی', 'بایقوت', 1),
        (155, 'آذربایجان شرقی', 'اروق', 1),
        (156, 'آذربایجان شرقی', 'اق منار', 1),
        (157, 'آذربایجان شرقی', 'طوراغای (طوراغایی )', 1),
        (158, 'آذربایجان شرقی', 'اوشندل', 1),
        (159, 'آذربایجان شرقی', 'علی ابادعلیا', 1),
        (160, 'آذربایجان شرقی', 'ذوالبین', 1),
        (161, 'آذربایجان شرقی', 'اتش بیگ', 1),
        (162, 'آذربایجان شرقی', 'سلوک', 1),
        (163, 'آذربایجان شرقی', 'نصیرابادسفلی', 1),
        (164, 'آذربایجان شرقی', 'ارسگنای سفلی', 1),
        (165, 'آذربایجان شرقی', 'سلطان اباد (س انمکزار', 1),
        (166, 'آذربایجان شرقی', 'قلعه حسین اباد', 1),
        (167, 'آذربایجان شرقی', 'ذاکرکندی', 1),
        (168, 'آذربایجان شرقی', 'قوچ احمد', 1),
        (169, 'آذربایجان شرقی', 'اغ زیارت', 1),
        (170, 'آذربایجان غربی', 'قوشچی', 2),
        (171, 'آذربایجان غربی', 'سیلوانه', 2),
        (172, 'آذربایجان غربی', 'سرو', 2),
        (173, 'آذربایجان غربی', 'ارومیه', 2),
        (174, 'آذربایجان غربی', 'نوشین', 2),
        (175, 'آذربایجان غربی', 'اشنویه', 2),
        (176, 'آذربایجان غربی', 'نالوس', 2),
        (177, 'آذربایجان غربی', 'سیمینه', 2),
        (178, 'آذربایجان غربی', 'بوکان', 2),
        (179, 'آذربایجان غربی', 'نازک علیا', 2),
        (180, 'آذربایجان غربی', 'پلدشت', 2),
        (181, 'آذربایجان غربی', 'گردکشانه', 2),
        (182, 'آذربایجان غربی', 'پیرانشهر', 2),
        (183, 'آذربایجان غربی', 'تکاب', 2),
        (184, 'آذربایجان غربی', 'آواجیق', 2),
        (185, 'آذربایجان غربی', 'سیه چشمه', 2),
        (186, 'آذربایجان غربی', 'قره ضیاء الدین', 2),
        (187, 'آذربایجان غربی', 'ایواوغلی', 2),
        (188, 'آذربایجان غربی', 'زرآباد', 2),
        (189, 'آذربایجان غربی', 'قطور', 2),
        (190, 'آذربایجان غربی', 'خوی', 2),
        (191, 'آذربایجان غربی', 'دیزج دیز', 2),
        (192, 'آذربایجان غربی', 'فیرورق', 2),
        (193, 'آذربایجان غربی', 'ربط', 2),
        (194, 'آذربایجان غربی', 'سردشت', 2),
        (195, 'آذربایجان غربی', 'میرآباد', 2),
        (196, 'آذربایجان غربی', 'تازه شهر', 2),
        (197, 'آذربایجان غربی', 'سلماس', 2),
        (198, 'آذربایجان غربی', 'شاهین دژ', 2),
        (199, 'آذربایجان غربی', 'محمود آباد', 2),
        (200, 'آذربایجان غربی', 'کشاورز', 2),
        (201, 'آذربایجان غربی', 'مرگنلر', 2),
        (202, 'آذربایجان غربی', 'شوط', 2),
        (203, 'آذربایجان غربی', 'بازرگان', 2),
        (204, 'آذربایجان غربی', 'ماکو', 2),
        (205, 'آذربایجان غربی', 'خلیفان', 2),
        (206, 'آذربایجان غربی', 'مهاباد', 2),
        (207, 'آذربایجان غربی', 'باروق', 2),
        (208, 'آذربایجان غربی', 'چهار برج', 2),
        (209, 'آذربایجان غربی', 'میاندوآب', 2),
        (210, 'آذربایجان غربی', 'محمد یار', 2),
        (211, 'آذربایجان غربی', 'نقده', 2),
        (212, 'آذربایجان غربی', 'باراندوز', 2),
        (213, 'آذربایجان غربی', 'دیزج دول', 2),
        (214, 'آذربایجان غربی', 'میاوق', 2),
        (215, 'آذربایجان غربی', 'ایبلو', 2),
        (216, 'آذربایجان غربی', 'دستجرد-آذربایجان غربی', 2),
        (217, 'آذربایجان غربی', 'طلاتپه', 2),
        (218, 'آذربایجان غربی', 'راژان', 2),
        (219, 'آذربایجان غربی', 'هاشم اباد', 2),
        (220, 'آذربایجان غربی', 'دیزج-آذربایجان غربی', 2),
        (221, 'آذربایجان غربی', 'زیوه', 2),
        (222, 'آذربایجان غربی', 'تویی', 2),
        (223, 'آذربایجان غربی', 'موانا', 2),
        (224, 'آذربایجان غربی', 'قره باغ', 2),
        (225, 'آذربایجان غربی', 'بهله', 2),
        (226, 'آذربایجان غربی', 'امام کندی', 2),
        (227, 'آذربایجان غربی', 'نازلو', 2),
        (228, 'آذربایجان غربی', 'کانسپی', 2),
        (229, 'آذربایجان غربی', 'ممکان', 2),
        (230, 'آذربایجان غربی', 'حسنلو', 2),
        (231, 'آذربایجان غربی', 'کهریزعجم', 2),
        (232, 'آذربایجان غربی', 'شیخ احمد', 2),
        (233, 'آذربایجان غربی', 'بیگم قلعه', 2),
        (234, 'آذربایجان غربی', 'راهدانه', 2),
        (235, 'آذربایجان غربی', 'شاهوانه', 2),
        (236, 'آذربایجان غربی', 'ده شمس بزرگ', 2),
        (237, 'آذربایجان غربی', 'گلاز', 2),
        (238, 'آذربایجان غربی', 'لولکان', 2),
        (239, 'آذربایجان غربی', 'سیاوان', 2),
        (240, 'آذربایجان غربی', 'کله کین', 2),
        (241, 'آذربایجان غربی', 'شین اباد', 2),
        (242, 'آذربایجان غربی', 'چیانه', 2),
        (243, 'آذربایجان غربی', 'بیکوس', 2),
        (244, 'آذربایجان غربی', 'هنگ اباد', 2),
        (245, 'آذربایجان غربی', 'پسوه', 2),
        (246, 'آذربایجان غربی', 'ریگ اباد', 2),
        (247, 'آذربایجان غربی', 'احمدغریب', 2),
        (248, 'آذربایجان غربی', 'سیه باز', 2),
        (249, 'آذربایجان غربی', 'بیله وار', 2),
        (250, 'آذربایجان غربی', 'ولدیان', 2),
        (251, 'آذربایجان غربی', 'قوروق', 2),
        (252, 'آذربایجان غربی', 'هندوان', 2),
        (253, 'آذربایجان غربی', 'بدلان', 2),
        (254, 'آذربایجان غربی', 'بلسورسفلی', 2),
        (255, 'آذربایجان غربی', 'استران', 2),
        (256, 'آذربایجان غربی', 'شیرین بلاغ', 2),
        (257, 'آذربایجان غربی', 'مراکان', 2),
        (258, 'آذربایجان غربی', 'چورس', 2),
        (259, 'آذربایجان غربی', 'قورول علیا', 2),
        (260, 'آذربایجان غربی', 'بسطام-آذربایجان غربی', 2),
        (261, 'آذربایجان غربی', 'قره تپه', 2),
        (262, 'آذربایجان غربی', 'ریحانلوی علیا', 2),
        (263, 'آذربایجان غربی', 'زاویه سفلی', 2),
        (264, 'آذربایجان غربی', 'قم قشلاق', 2),
        (265, 'آذربایجان غربی', 'یولاگلدی', 2),
        (266, 'آذربایجان غربی', 'قرنقو', 2),
        (267, 'آذربایجان غربی', 'حسن کندی', 2),
        (268, 'آذربایجان غربی', 'وردان', 2),
        (269, 'آذربایجان غربی', 'قره قشلاق', 2),
        (270, 'آذربایجان غربی', 'تمر', 2),
        (271, 'آذربایجان غربی', 'ابگرم-آذربایجان غربی', 2),
        (272, 'آذربایجان غربی', 'سرنق', 2),
        (273, 'آذربایجان غربی', 'چهریق علیا', 2),
        (274, 'آذربایجان غربی', 'داراب-آذربایجان غربی', 2),
        (275, 'آذربایجان غربی', 'دلزی', 2),
        (276, 'آذربایجان غربی', 'اغ برزه', 2),
        (277, 'آذربایجان غربی', 'سنجی', 2),
        (278, 'آذربایجان غربی', 'خاتون باغ', 2),
        (279, 'آذربایجان غربی', 'حاجی حسن', 2),
        (280, 'آذربایجان غربی', 'سوگلی تپه', 2),
        (281, 'آذربایجان غربی', 'گلیجه', 2),
        (282, 'آذربایجان غربی', 'حاجی کند', 2),
        (283, 'آذربایجان غربی', 'باغچه', 2),
        (284, 'آذربایجان غربی', 'خورخوره-آذربایجان غربی', 2),
        (285, 'آذربایجان غربی', 'کاولان علیا', 2),
        (286, 'آذربایجان غربی', 'سیاقول علیا', 2),
        (287, 'آذربایجان غربی', 'اگریقاش', 2),
        (288, 'آذربایجان غربی', 'اوزون دره علیا', 2),
        (289, 'آذربایجان غربی', 'یکشوه', 2),
        (290, 'آذربایجان غربی', 'جوانمرد', 2),
        (291, 'آذربایجان غربی', 'اختتر', 2),
        (292, 'آذربایجان غربی', 'رحیم خان', 2),
        (293, 'آذربایجان غربی', 'گل تپه قورمیش', 2),
        (294, 'آذربایجان غربی', 'شلماش', 2),
        (295, 'آذربایجان غربی', 'اسلام اباد-آذربایجان غربی', 2),
        (296, 'آذربایجان غربی', 'بیوران سفلی', 2),
        (297, 'آذربایجان غربی', 'زمزیران', 2),
        (298, 'آذربایجان غربی', 'اقبال', 2),
        (299, 'آذربایجان غربی', 'ملاشهاب الدین', 2),
        (300, 'آذربایجان غربی', 'للکلو', 2),
        (301, 'آذربایجان غربی', 'بگتاش', 2),
        (302, 'آذربایجان غربی', 'گوگ تپه خالصه', 2),
        (303, 'آذربایجان غربی', 'تک اغاج', 2),
        (304, 'آذربایجان غربی', 'هاچاسو', 2),
        (305, 'آذربایجان غربی', 'هولاسو', 2),
        (306, 'آذربایجان غربی', 'قوزلوی افشار', 2),
        (307, 'آذربایجان غربی', 'الی چین', 2),
        (308, 'آذربایجان غربی', 'حیدرباغی', 2),
        (309, 'آذربایجان غربی', 'حمزه قاسم', 2),
        (310, 'آذربایجان غربی', 'اوغول بیگ', 2),
        (311, 'آذربایجان غربی', 'دورباش', 2),
        (312, 'آذربایجان غربی', 'اقابیگ', 2),
        (313, 'آذربایجان غربی', 'احمدابادسفلی', 2),
        (314, 'آذربایجان غربی', 'سیلوه', 2),
        (315, 'آذربایجان غربی', 'جلدیان', 2),
        (316, 'آذربایجان غربی', 'گوگ تپه-آذربایجان غربی', 2),
        (317, 'اردبیل', 'اردبیل', 3),
        (318, 'اردبیل', 'هیر', 3),
        (319, 'اردبیل', 'جعفر آباد', 3),
        (320, 'اردبیل', 'بیله سوار', 3),
        (321, 'اردبیل', 'اسلام آباد', 3),
        (322, 'اردبیل', 'اصلاندوز', 3),
        (323, 'اردبیل', 'تازه کند', 3),
        (324, 'اردبیل', 'پارس آباد', 3),
        (325, 'اردبیل', 'هشتجین', 3),
        (326, 'اردبیل', 'کلور', 3),
        (327, 'اردبیل', 'خلخال', 3),
        (328, 'اردبیل', 'سرعین', 3),
        (329, 'اردبیل', 'تازه کند انگوت', 3),
        (330, 'اردبیل', 'گرمی', 3),
        (331, 'اردبیل', 'رضی', 3),
        (332, 'اردبیل', 'قصابه', 3),
        (333, 'اردبیل', 'مرادلو', 3),
        (334, 'اردبیل', 'مشگین شهر', 3),
        (335, 'اردبیل', 'فخرآباد', 3),
        (336, 'اردبیل', 'لاهرود', 3),
        (337, 'اردبیل', 'عنبران', 3),
        (338, 'اردبیل', 'نمین', 3),
        (339, 'اردبیل', 'آبی بیگلو', 3),
        (340, 'اردبیل', 'نیر', 3),
        (341, 'اردبیل', 'کورائیم', 3),
        (342, 'اردبیل', 'گیوی', 3),
        (343, 'اردبیل', 'ننه کران', 3),
        (344, 'اردبیل', 'گرده', 3),
        (345, 'اردبیل', 'ثمرین', 3),
        (346, 'اردبیل', 'اردیموسی', 3),
        (347, 'اردبیل', 'اسلام اباد-اردبیل', 3),
        (348, 'اردبیل', 'مهماندوست علیا', 3),
        (349, 'اردبیل', 'بقراباد', 3),
        (350, 'اردبیل', 'بودالالو', 3),
        (351, 'اردبیل', 'اراللوی بزرگ', 3),
        (352, 'اردبیل', 'دیزج-اردبیل', 3),
        (353, 'اردبیل', 'حمزه خانلو', 3),
        (354, 'اردبیل', 'زهرا', 3),
        (355, 'اردبیل', 'انی علیا', 3),
        (356, 'اردبیل', 'قاسم کندی', 3),
        (357, 'اردبیل', 'قره اغاج پایین', 3),
        (358, 'اردبیل', 'پریخان', 3),
        (359, 'اردبیل', 'قوشه سفلی', 3),
        (360, 'اردبیل', 'گنجوبه', 3),
        (361, 'اردبیل', 'گوگ تپه-اردبیل', 3),
        (362, 'اردبیل', 'انجیرلو', 3),
        (363, 'اردبیل', 'قشلاق اغداش کلام', 3),
        (364, 'اردبیل', 'خورخورسفلی', 3),
        (365, 'اردبیل', 'شورگل', 3),
        (366, 'اردبیل', 'نظرعلی بلاغی', 3),
        (367, 'اردبیل', 'لنبر', 3),
        (368, 'اردبیل', 'فیروزاباد', 3),
        (369, 'اردبیل', 'خلفلو', 3),
        (370, 'اردبیل', 'برندق', 3),
        (371, 'اردبیل', 'تازه کندجدید', 3),
        (372, 'اردبیل', 'گوشلو', 3),
        (373, 'اردبیل', 'اق قباق علیا', 3),
        (374, 'اردبیل', 'شهرک غفاری', 3),
        (375, 'اردبیل', 'بران علیا', 3),
        (376, 'اصفهان', 'آران و بیدگل', 4),
        (377, 'اصفهان', 'سفید شهر', 4),
        (378, 'اصفهان', 'نوش آباد', 4),
        (379, 'اصفهان', 'ابوزید آباد', 4),
        (380, 'اصفهان', 'زواره', 4),
        (381, 'اصفهان', 'اردستان', 4),
        (382, 'اصفهان', 'مهاباد', 4),
        (383, 'اصفهان', 'ورزنه', 4),
        (384, 'اصفهان', 'محمد آباد', 4),
        (385, 'اصفهان', 'نصرآباد', 4),
        (386, 'اصفهان', 'نیک آباد', 4),
        (387, 'اصفهان', 'حسن آباد', 4),
        (388, 'اصفهان', 'اژیه', 4),
        (389, 'اصفهان', 'هرند', 4),
        (390, 'اصفهان', 'اصفهان', 4),
        (391, 'اصفهان', 'بهارستان', 4),
        (392, 'اصفهان', 'زیار', 4),
        (393, 'اصفهان', 'قهجاورستان', 4),
        (394, 'اصفهان', 'تودشک', 4),
        (395, 'اصفهان', 'سگزی', 4),
        (396, 'اصفهان', 'کوهپایه', 4),
        (397, 'اصفهان', 'حبیب آباد', 4),
        (398, 'اصفهان', 'شاپورآباد', 4),
        (399, 'اصفهان', 'کمشجه', 4),
        (400, 'اصفهان', 'خورزوق', 4),
        (401, 'اصفهان', 'دستگرد', 4),
        (402, 'اصفهان', 'دولت آباد', 4),
        (403, 'اصفهان', 'سین', 4),
        (404, 'اصفهان', 'افوس', 4),
        (405, 'اصفهان', 'بوئین میاندشت', 4),
        (406, 'اصفهان', 'تیران', 4),
        (407, 'اصفهان', 'رضوانشهر', 4),
        (408, 'اصفهان', 'عسگران', 4),
        (409, 'اصفهان', 'چادگان', 4),
        (410, 'اصفهان', 'رزوه', 4),
        (411, 'اصفهان', 'اصغرآباد', 4),
        (412, 'اصفهان', 'خمینی شهر', 4),
        (413, 'اصفهان', 'درچه پیاز', 4),
        (414, 'اصفهان', 'کوشک', 4),
        (415, 'اصفهان', 'خوانسار', 4),
        (416, 'اصفهان', 'جندق', 4),
        (417, 'اصفهان', 'خور', 4),
        (418, 'اصفهان', 'فرخی', 4),
        (419, 'اصفهان', 'دهاقان', 4),
        (420, 'اصفهان', 'گلشن', 4),
        (421, 'اصفهان', 'کمه', 4),
        (422, 'اصفهان', 'حنا', 4),
        (423, 'اصفهان', 'سمیرم', 4),
        (424, 'اصفهان', 'ونک', 4),
        (425, 'اصفهان', 'شاهین شهر', 4),
        (426, 'اصفهان', 'گرگاب', 4),
        (427, 'اصفهان', 'گز برخوار', 4),
        (428, 'اصفهان', 'لای بید', 4),
        (429, 'اصفهان', 'میمه', 4),
        (430, 'اصفهان', 'وزوان', 4),
        (431, 'اصفهان', 'شهرضا', 4),
        (432, 'اصفهان', 'منظریه', 4),
        (433, 'اصفهان', 'داران', 4),
        (434, 'اصفهان', 'دامنه', 4),
        (435, 'اصفهان', 'برف انبار', 4),
        (436, 'اصفهان', 'فریدونشهر', 4),
        (437, 'اصفهان', 'بهاران شهر', 4),
        (438, 'اصفهان', 'پیر بکران', 4),
        (439, 'اصفهان', 'زازران', 4),
        (440, 'اصفهان', 'ابریشم', 4),
        (441, 'اصفهان', 'ایمانشهر', 4),
        (442, 'اصفهان', 'فلاورجان', 4),
        (443, 'اصفهان', 'قهدریجان', 4),
        (444, 'اصفهان', 'کلیشاد و سودرجان', 4),
        (445, 'اصفهان', 'گلپایگان', 4),
        (446, 'اصفهان', 'گلشهر', 4),
        (447, 'اصفهان', 'گوگد', 4),
        (448, 'اصفهان', 'باغ بهادران', 4),
        (449, 'اصفهان', 'چرمهین', 4),
        (450, 'اصفهان', 'باغشاد', 4),
        (451, 'اصفهان', 'چمگردان', 4),
        (452, 'اصفهان', 'زاینده رود', 4),
        (453, 'اصفهان', 'زرین شهر', 4),
        (454, 'اصفهان', 'سده لنجان', 4),
        (455, 'اصفهان', 'فولادشهر', 4),
        (456, 'اصفهان', 'ورنامخواست', 4),
        (457, 'اصفهان', 'زیباشهر', 4),
        (458, 'اصفهان', 'دیزیچه', 4),
        (459, 'اصفهان', 'طالخونچه', 4),
        (460, 'اصفهان', 'مبارکه', 4),
        (461, 'اصفهان', 'کرکوند', 4),
        (462, 'اصفهان', 'انارک', 4),
        (463, 'اصفهان', 'بافران', 4),
        (464, 'اصفهان', 'نائین', 4),
        (465, 'اصفهان', 'جوزدان', 4),
        (466, 'اصفهان', 'گلدشت', 4),
        (467, 'اصفهان', 'نجف آباد', 4),
        (468, 'اصفهان', 'کهریزسنگ', 4),
        (469, 'اصفهان', 'دهق', 4),
        (470, 'اصفهان', 'علویچه', 4),
        (471, 'اصفهان', 'بادرود', 4),
        (472, 'اصفهان', 'خالد آباد', 4),
        (473, 'اصفهان', 'طرق رود', 4),
        (474, 'اصفهان', 'نطنز', 4),
        (475, 'اصفهان', 'برزک', 4),
        (476, 'اصفهان', 'جوشقان قالی', 4),
        (477, 'اصفهان', 'قمصر', 4),
        (478, 'اصفهان', 'کامو و چوگان', 4),
        (479, 'اصفهان', 'مشکات', 4),
        (480, 'اصفهان', 'کاشان', 4),
        (481, 'اصفهان', 'نیاسر', 4),
        (482, 'اصفهان', 'سعادت اباد', 4),
        (483, 'اصفهان', 'فتح اباد-اصفهان', 4),
        (484, 'اصفهان', 'سن سن', 4),
        (485, 'اصفهان', 'ده زیره', 4),
        (486, 'اصفهان', 'رحق', 4),
        (487, 'اصفهان', 'اب شیرین', 4),
        (488, 'اصفهان', 'نشلج', 4),
        (489, 'اصفهان', 'مزرعه صدر', 4),
        (490, 'اصفهان', 'کاغذی', 4),
        (491, 'اصفهان', 'قهرود', 4),
        (492, 'اصفهان', 'جوشقان و کامو', 4),
        (493, 'اصفهان', 'اسحق اباد-اصفهان', 4),
        (494, 'اصفهان', 'وادقان', 4),
        (495, 'اصفهان', 'اذان', 4),
        (496, 'اصفهان', 'اریسمان', 4),
        (497, 'اصفهان', 'ابیانه', 4),
        (498, 'اصفهان', 'اوره', 4),
        (499, 'اصفهان', 'ملازجان', 4),
        (500, 'اصفهان', 'سعیداباد-اصفهان', 4),
        (501, 'اصفهان', 'مرغ', 4),
        (502, 'اصفهان', 'قرغن', 4),
        (503, 'اصفهان', 'کوچری', 4),
        (504, 'اصفهان', 'کلوچان', 4),
        (505, 'اصفهان', 'زرنجان', 4),
        (506, 'اصفهان', 'وانشان', 4),
        (507, 'اصفهان', 'تیکن', 4),
        (508, 'اصفهان', 'سنگ سفید', 4),
        (509, 'اصفهان', 'رحمت اباد', 4),
        (510, 'اصفهان', 'خم پیچ', 4),
        (511, 'اصفهان', 'مهراباد', 4),
        (512, 'اصفهان', 'تیدجان', 4),
        (513, 'اصفهان', 'خشکرود-اصفهان', 4),
        (514, 'اصفهان', 'ویست', 4),
        (515, 'اصفهان', 'منطقه صنعتی محموداباد', 4),
        (516, 'اصفهان', 'مورچه خورت', 4),
        (517, 'اصفهان', 'علویجه', 4),
        (518, 'اصفهان', 'اسفرجان', 4),
        (519, 'اصفهان', 'مهرگرد', 4),
        (520, 'اصفهان', 'جوشقان استرک', 4),
        (521, 'اصفهان', 'خوراسگان', 4),
        (522, 'اصفهان', 'گورت', 4),
        (523, 'اصفهان', 'دستجا', 4),
        (524, 'اصفهان', 'پادگان اموزشی امام ص', 4),
        (525, 'اصفهان', 'پالایشگاه اصفهان', 4),
        (526, 'اصفهان', 'کلهرود', 4),
        (527, 'اصفهان', 'موته', 4),
        (528, 'اصفهان', 'رباطاقاکمال', 4),
        (529, 'اصفهان', 'خسرواباد-اصفهان', 4),
        (530, 'اصفهان', 'کمشچه', 4),
        (531, 'اصفهان', 'مزیک', 4),
        (532, 'اصفهان', 'مهرجان', 4),
        (533, 'اصفهان', 'بیاضه', 4),
        (534, 'اصفهان', 'چوپانان', 4),
        (535, 'اصفهان', 'بلان', 4),
        (536, 'اصفهان', 'حسن اباد-اصفهان', 4),
        (537, 'اصفهان', 'کچومثقال', 4),
        (538, 'اصفهان', 'ظفرقند', 4),
        (539, 'اصفهان', 'نهوج', 4),
        (540, 'اصفهان', 'نیسیان', 4),
        (541, 'اصفهان', 'ومکان', 4),
        (542, 'اصفهان', 'همسار', 4),
        (543, 'اصفهان', 'فسخود', 4),
        (544, 'اصفهان', 'فوداز', 4),
        (545, 'اصفهان', 'اشکستان', 4),
        (546, 'اصفهان', 'کجان', 4),
        (547, 'اصفهان', 'نیستانک', 4),
        (548, 'اصفهان', 'تیرانچی', 4),
        (549, 'اصفهان', 'قلعه امیریه', 4),
        (550, 'اصفهان', 'درقه', 4),
        (551, 'اصفهان', 'شهراب-اصفهان', 4),
        (552, 'اصفهان', 'تورزن', 4),
        (553, 'اصفهان', 'کریم اباد-اصفهان', 4),
        (554, 'اصفهان', 'تلک اباد', 4),
        (555, 'اصفهان', 'موغار', 4),
        (556, 'اصفهان', 'خوانسارک', 4),
        (557, 'اصفهان', 'کرسگان', 4),
        (558, 'اصفهان', 'سهروفیروزان', 4),
        (559, 'اصفهان', 'شرودان', 4),
        (560, 'اصفهان', 'جوجیل', 4),
        (561, 'اصفهان', 'نوگوران', 4),
        (562, 'اصفهان', 'کرچگان', 4),
        (563, 'اصفهان', 'باغ ملک-اصفهان', 4),
        (564, 'اصفهان', 'دهسرخ', 4),
        (565, 'اصفهان', 'پلی اکریل', 4),
        (566, 'اصفهان', 'فولادمبارکه', 4),
        (567, 'اصفهان', 'چم نور', 4),
        (568, 'اصفهان', 'کچوییه', 4),
        (569, 'اصفهان', 'اشیان', 4),
        (570, 'اصفهان', 'تاسیسات سدنکواباد', 4),
        (571, 'اصفهان', 'ورپشت', 4),
        (572, 'اصفهان', 'عزیزاباد-اصفهان', 4),
        (573, 'اصفهان', 'میراباد-اصفهان', 4),
        (574, 'اصفهان', 'حاجی اباد', 4),
        (575, 'اصفهان', 'خیراباد-اصفهان', 4),
        (576, 'اصفهان', 'اشن', 4),
        (577, 'اصفهان', 'خونداب', 4),
        (578, 'اصفهان', 'حسین اباد-اصفهان', 4),
        (579, 'اصفهان', 'غرغن', 4),
        (580, 'اصفهان', 'بوئین و میاندشت', 4),
        (581, 'اصفهان', 'زرنه-اصفهان', 4),
        (582, 'اصفهان', 'بلطاق', 4),
        (583, 'اصفهان', 'کرچ', 4),
        (584, 'اصفهان', 'قره بلطاق', 4),
        (585, 'اصفهان', 'سازمان عمران زاینده رود', 4),
        (586, 'اصفهان', 'مشهدکاوه', 4),
        (587, 'اصفهان', 'اسکندری', 4),
        (588, 'اصفهان', 'نهرخلج', 4),
        (589, 'اصفهان', 'چاه غلامرضارحیمی', 4),
        (590, 'اصفهان', 'اورگان-اصفهان', 4),
        (591, 'اصفهان', 'نهضت اباد', 4),
        (592, 'اصفهان', 'قلعه سرخ', 4),
        (593, 'اصفهان', 'اسلام ابادموگویی', 4),
        (594, 'اصفهان', 'مصیر', 4),
        (595, 'اصفهان', 'قمشلو', 4),
        (596, 'اصفهان', 'پوده', 4),
        (597, 'اصفهان', 'مهیار', 4),
        (598, 'اصفهان', 'پرزان', 4),
        (599, 'اصفهان', 'منوچهراباد', 4),
        (600, 'اصفهان', 'شهرک صنایع شیمیایی ر', 4),
        (601, 'اصفهان', 'همگین', 4),
        (602, 'اصفهان', 'کهرویه', 4),
        (603, 'اصفهان', 'قصرچم', 4),
        (604, 'اصفهان', 'امین اباد', 4),
        (605, 'اصفهان', 'مقصودبیک', 4),
        (606, 'اصفهان', 'سولار', 4),
        (607, 'اصفهان', 'گرموک', 4),
        (608, 'اصفهان', 'هست', 4),
        (609, 'اصفهان', 'کهنگان', 4),
        (610, 'اصفهان', 'مورک', 4),
        (611, 'اصفهان', 'چهارراه', 4),
        (612, 'اصفهان', 'ده نسا سفلی', 4),
        (613, 'اصفهان', 'اغداش', 4),
        (614, 'اصفهان', 'چشمه رحمان', 4),
        (615, 'اصفهان', 'ورق', 4),
        (616, 'اصفهان', 'شهر ابریشم', 4),
        (617, 'اصفهان', 'سپاهان شهر', 4),
        (618, 'البرز', 'اشتهارد', 5),
        (619, 'البرز', 'کوهسار', 5),
        (620, 'البرز', 'چهارباغ', 5),
        (621, 'البرز', 'شهر جدید هشتگرد', 5),
        (622, 'البرز', 'گلسار', 5),
        (623, 'البرز', 'هشتگرد', 5),
        (624, 'البرز', 'طالقان', 5),
        (625, 'البرز', 'فردیس', 5),
        (626, 'البرز', 'تنکمان', 5),
        (627, 'البرز', 'نظر آباد', 5),
        (628, 'البرز', 'آسارا', 5),
        (629, 'البرز', 'گرمدره', 5),
        (630, 'البرز', 'ماهدشت', 5),
        (631, 'البرز', 'محمد شهر', 5),
        (632, 'البرز', 'مشکین دشت', 5),
        (633, 'البرز', 'کرج', 5),
        (634, 'البرز', 'کمال شهر', 5),
        (635, 'البرز', 'ادران', 5),
        (636, 'البرز', 'سولقان', 5),
        (637, 'البرز', 'کیانمهر', 5),
        (638, 'البرز', 'مارلیک', 5),
        (639, 'البرز', 'قزل حصار', 5),
        (640, 'ایلام', 'سراب باغ', 6),
        (641, 'ایلام', 'آبدانان', 6),
        (642, 'ایلام', 'مورموری', 6),
        (643, 'ایلام', 'چوار', 6),
        (644, 'ایلام', 'ایلام', 6),
        (645, 'ایلام', 'زرنه', 6),
        (646, 'ایلام', 'ایوان', 6),
        (647, 'ایلام', 'بدره', 6),
        (648, 'ایلام', 'بلاوه', 6),
        (649, 'ایلام', 'شباب', 6),
        (650, 'ایلام', 'آسمان آباد', 6),
        (651, 'ایلام', 'سرابله', 6),
        (652, 'ایلام', 'توحید', 6),
        (653, 'ایلام', 'ماژین', 6),
        (654, 'ایلام', 'دره شهر', 6),
        (655, 'ایلام', 'پهله', 6),
        (656, 'ایلام', 'میمه', 6),
        (657, 'ایلام', 'دهلران', 6),
        (658, 'ایلام', 'موسیان', 6),
        (659, 'ایلام', 'لومار', 6),
        (660, 'ایلام', 'دلگشا', 6),
        (661, 'ایلام', 'مهر', 6),
        (662, 'ایلام', 'ارکواز', 6),
        (663, 'ایلام', 'صالح آباد', 6),
        (664, 'ایلام', 'مهران', 6),
        (665, 'ایلام', 'سرآبله', 6),
        (666, 'ایلام', 'چنارباشی', 6),
        (667, 'ایلام', 'بیشه دراز', 6),
        (668, 'ایلام', 'چشمه کبود', 6),
        (669, 'ایلام', 'بانویزه', 6),
        (670, 'ایلام', 'چمن سیدمحمد', 6),
        (671, 'ایلام', 'هفت چشمه-ایلام', 6),
        (672, 'ایلام', 'شورابه ملک', 6),
        (673, 'ایلام', 'کلان', 6),
        (674, 'ایلام', 'بلاوه تره سفلی', 6),
        (675, 'ایلام', 'سراب کارزان', 6),
        (676, 'ایلام', 'شهرک سرتنگ', 6),
        (677, 'ایلام', 'علی اباد-ایلام', 6),
        (678, 'ایلام', 'ارمو', 6),
        (679, 'ایلام', 'چشمه شیرین', 6),
        (680, 'ایلام', 'شهرک ولیعصر', 6),
        (681, 'ایلام', 'گنداب', 6),
        (682, 'ایلام', 'ژیور', 6),
        (683, 'ایلام', 'سیاه گل', 6),
        (684, 'ایلام', 'اب انار', 6),
        (685, 'ایلام', 'چم هندی', 6),
        (686, 'ایلام', 'گولاب', 6),
        (687, 'ایلام', 'عین خوش', 6),
        (688, 'ایلام', 'دشت عباس', 6),
        (689, 'ایلام', 'شهرک اسلامیه', 6),
        (690, 'ایلام', 'دول کبودخوشادول', 6),
        (691, 'ایلام', 'پاریاب', 6),
        (692, 'بوشهر', 'خارک', 7),
        (693, 'بوشهر', 'بوشهر', 7),
        (694, 'بوشهر', 'چغادک', 7),
        (695, 'بوشهر', 'دلوار', 7),
        (696, 'بوشهر', 'آباد', 7),
        (697, 'بوشهر', 'اهرم', 7),
        (698, 'بوشهر', 'انارستان', 7),
        (699, 'بوشهر', 'ریز', 7),
        (700, 'بوشهر', 'جم', 7),
        (701, 'بوشهر', 'آبپخش', 7),
        (702, 'بوشهر', 'تنگ ارم', 7),
        (703, 'بوشهر', 'بوشکان', 7),
        (704, 'بوشهر', 'کلمه', 7),
        (705, 'بوشهر', 'سعد آباد', 7),
        (706, 'بوشهر', 'وحدتیه', 7),
        (707, 'بوشهر', 'شبانکاره', 7),
        (708, 'بوشهر', 'برازجان', 7),
        (709, 'بوشهر', 'دالکی', 7),
        (710, 'بوشهر', 'شنبه', 7),
        (711, 'بوشهر', 'خورموج', 7),
        (712, 'بوشهر', 'بادوله', 7),
        (713, 'بوشهر', 'کاکی', 7),
        (714, 'بوشهر', 'بردخون', 7),
        (715, 'بوشهر', 'آبدان', 7),
        (716, 'بوشهر', 'بردستان', 7),
        (717, 'بوشهر', 'بندر دیر', 7),
        (718, 'بوشهر', 'دوراهک', 7),
        (719, 'بوشهر', 'امام حسن', 7),
        (720, 'بوشهر', 'بندر دیلم', 7),
        (721, 'بوشهر', 'عسلویه', 7),
        (722, 'بوشهر', 'نخل تقی', 7),
        (723, 'بوشهر', 'بندر ریگ', 7),
        (724, 'بوشهر', 'بندر گناوه', 7),
        (725, 'بوشهر', 'بندر کنگان', 7),
        (726, 'بوشهر', 'بنک', 7),
        (727, 'بوشهر', 'سیراف', 7),
        (728, 'بوشهر', 'چهارروستایی', 7),
        (729, 'بوشهر', 'شول', 7),
        (730, 'بوشهر', 'بنه گز', 7),
        (731, 'بوشهر', 'اباد', 7),
        (732, 'بوشهر', 'ابگرمک', 7),
        (733, 'بوشهر', 'عالیشهر', 7),
        (734, 'تهران', 'چهاردانگه', 8),
        (735, 'تهران', 'اسلامشهر', 8),
        (736, 'تهران', 'نسیم شهر', 8),
        (737, 'تهران', 'صالحیه', 8),
        (738, 'تهران', 'گلستان', 8),
        (739, 'تهران', 'نصیرشهر', 8),
        (740, 'تهران', 'شریف آباد', 8),
        (741, 'تهران', 'پاکدشت', 8),
        (742, 'تهران', 'فرون آباد', 8),
        (743, 'تهران', 'پیشوا', 8),
        (744, 'تهران', 'بومهن', 8),
        (745, 'تهران', 'پردیس', 8),
        (746, 'تهران', 'تهران', 8),
        (747, 'تهران', 'آبعلی', 8),
        (748, 'تهران', 'رودهن', 8),
        (749, 'تهران', 'دماوند', 8),
        (750, 'تهران', 'کیلان', 8),
        (751, 'تهران', 'رباط کریم', 8),
        (752, 'تهران', 'شهر جدید پرند', 8),
        (753, 'تهران', 'حسن آباد', 8),
        (754, 'تهران', 'باقرشهر', 8),
        (755, 'تهران', 'کهریزک', 8),
        (756, 'تهران', 'شمشک', 8),
        (757, 'تهران', 'فشم', 8),
        (758, 'تهران', 'لواسان کوچک', 8),
        (759, 'تهران', 'اندیشه', 8),
        (760, 'تهران', 'باغستان', 8),
        (761, 'تهران', 'شاهدشهر', 8),
        (762, 'تهران', 'شهریار', 8),
        (763, 'تهران', 'صبا شهر', 8),
        (764, 'تهران', 'فردوسیه', 8),
        (765, 'تهران', 'وحیدیه', 8),
        (766, 'تهران', 'ارجمند', 8),
        (767, 'تهران', 'فیروزکوه', 8),
        (768, 'تهران', 'قدس', 8),
        (769, 'تهران', 'قرچک', 8),
        (770, 'تهران', 'صفادشت', 8),
        (771, 'تهران', 'ملارد', 8),
        (772, 'تهران', 'جواد آباد', 8),
        (773, 'تهران', 'ورامین', 8),
        (774, 'تهران', 'قلعه سین', 8),
        (775, 'تهران', 'عسگرابادعباسی', 8),
        (776, 'تهران', 'دهماسین', 8),
        (777, 'تهران', 'باغخواص', 8),
        (778, 'تهران', 'ایجدان', 8),
        (779, 'تهران', 'ابباریک', 8),
        (780, 'تهران', 'خاوه', 8),
        (781, 'تهران', 'جلیل اباد', 8),
        (782, 'تهران', 'کریم اباد', 8),
        (783, 'تهران', 'قلعه خواجه', 8),
        (784, 'تهران', 'شهرک عباس آباد', 8),
        (785, 'تهران', 'داوداباد', 8),
        (786, 'تهران', 'پارچین', 8),
        (787, 'تهران', 'حصارامیر', 8),
        (788, 'تهران', 'خاتون اباد', 8),
        (789, 'تهران', 'گرمدره', 8),
        (790, 'تهران', 'جاجرود(خسروآباد)', 8),
        (791, 'تهران', 'شهرصنعتی خرمدشت', 8),
        (792, 'تهران', 'جعفرابادباقراف', 8),
        (793, 'تهران', 'مرقدامام ره', 8),
        (794, 'تهران', 'طورقوزاباد', 8),
        (795, 'تهران', 'قاسم ابادشوراباد', 8),
        (796, 'تهران', 'قمصر', 8),
        (797, 'تهران', 'شمس اباد', 8),
        (798, 'تهران', 'ابراهیم اباد', 8),
        (799, 'تهران', 'چرمشهر', 8),
        (800, 'تهران', 'قلعه محمدعلی خان', 8),
        (801, 'تهران', 'فرودگاه امام خمینی', 8),
        (802, 'تهران', 'وهن اباد', 8),
        (803, 'تهران', 'قلعه نوخالصه', 8),
        (804, 'تهران', 'گل تپه کبیر', 8),
        (805, 'تهران', 'محمودابادپیرزاده', 8),
        (806, 'تهران', 'فرون اباد', 8),
        (807, 'تهران', 'خاورشهر', 8),
        (808, 'تهران', 'اسلام اباد', 8),
        (809, 'تهران', 'لپه زنگ', 8),
        (810, 'تهران', 'قیامدشت', 8),
        (811, 'تهران', 'قو,چ حصار', 8),
        (812, 'تهران', 'خلازیر', 8),
        (813, 'تهران', 'شهرک صنعتی نصیرشهر', 8),
        (814, 'تهران', 'شهرک قلعه میر', 8),
        (815, 'تهران', 'نصیرآباد', 8),
        (816, 'تهران', 'کلمه', 8),
        (817, 'تهران', 'پرند', 8),
        (818, 'تهران', 'شهر صنعتی پرند', 8),
        (819, 'تهران', 'سلطان اباد', 8),
        (820, 'تهران', 'حصارک پایین', 8),
        (821, 'تهران', 'حصارک بالا', 8),
        (822, 'تهران', 'سبزدشت', 8),
        (823, 'تهران', 'احمدآبادجانسپار', 8),
        (824, 'تهران', 'اسماعیل آباد', 8),
        (825, 'تهران', 'سعیدآباد', 8),
        (826, 'تهران', 'لواسان بزرگ', 8),
        (827, 'تهران', 'لم اباد', 8),
        (828, 'تهران', 'احمدابادمستوفی', 8),
        (829, 'تهران', 'فیروزبهرام', 8),
        (830, 'تهران', 'گلدسته', 8),
        (831, 'تهران', 'صالح آباد', 8),
        (832, 'تهران', 'شاطره', 8),
        (833, 'تهران', 'جابان', 8),
        (834, 'تهران', 'سربندان', 8),
        (835, 'تهران', 'مهرآباد', 8),
        (836, 'تهران', 'مشا', 8),
        (837, 'تهران', 'مرا', 8),
        (838, 'تهران', 'هرانده', 8),
        (839, 'تهران', 'درده', 8),
        (840, 'تهران', 'حصاربن', 8),
        (841, 'تهران', 'امیریه', 8),
        (842, 'تهران', 'شهرک صنعتی خاوران', 8),
        (843, 'تهران', 'گردنه تنباکویی', 8),
        (844, 'تهران', 'حسن آباد فشافویه', 8),
        (845, 'تهران', 'عباس آباد علاقبند', 8),
        (846, 'تهران', 'قیام دشت', 8),
        (847, 'تهران', 'شهرک صنعتی چهاردانگه', 8),
        (848, 'تهران', 'شهرک صنعتی گلگون', 8),
        (849, 'تهران', 'شهر قدس', 8),
        (850, 'تهران', 'سه راه سنگی', 8),
        (851, 'چهار محال و بختیاری', 'اردل', 9),
        (852, 'چهار محال و بختیاری', 'دشتک', 9),
        (853, 'چهار محال و بختیاری', 'کاج', 9),
        (854, 'چهار محال و بختیاری', 'سرخون', 9),
        (855, 'چهار محال و بختیاری', 'بلداجی', 9),
        (856, 'چهار محال و بختیاری', 'گندمان', 9),
        (857, 'چهار محال و بختیاری', 'بروجن', 9),
        (858, 'چهار محال و بختیاری', 'سفید دشت', 9),
        (859, 'چهار محال و بختیاری', 'فرادنبه', 9),
        (860, 'چهار محال و بختیاری', 'نقنه', 9),
        (861, 'چهار محال و بختیاری', 'بن', 9),
        (862, 'چهار محال و بختیاری', 'وردنجان', 9),
        (863, 'چهار محال و بختیاری', 'سامان', 9),
        (864, 'چهار محال و بختیاری', 'سودجان', 9),
        (865, 'چهار محال و بختیاری', 'سورشجان', 9),
        (866, 'چهار محال و بختیاری', 'هارونی', 9),
        (867, 'چهار محال و بختیاری', 'شهرکرد', 9),
        (868, 'چهار محال و بختیاری', 'طاقانک', 9),
        (869, 'چهار محال و بختیاری', 'فرخ شهر', 9),
        (870, 'چهار محال و بختیاری', 'نافچ', 9),
        (871, 'چهار محال و بختیاری', 'هفشجان', 9),
        (872, 'چهار محال و بختیاری', 'کیان', 9),
        (873, 'چهار محال و بختیاری', 'چلیچه', 9),
        (874, 'چهار محال و بختیاری', 'باباحیدر', 9),
        (875, 'چهار محال و بختیاری', 'پردنجان', 9),
        (876, 'چهار محال و بختیاری', 'جونقان', 9),
        (877, 'چهار محال و بختیاری', 'فارسان', 9),
        (878, 'چهار محال و بختیاری', 'گوجان', 9),
        (879, 'چهار محال و بختیاری', 'آلونی', 9),
        (880, 'چهار محال و بختیاری', 'سردشت لردگان', 9),
        (881, 'چهار محال و بختیاری', 'مال خلیفه', 9),
        (882, 'چهار محال و بختیاری', 'لردگان', 9),
        (883, 'چهار محال و بختیاری', 'منج', 9),
        (884, 'چهار محال و بختیاری', 'بازفت', 9),
        (885, 'چهار محال و بختیاری', 'صمصامی', 9),
        (886, 'چهار محال و بختیاری', 'چلگرد', 9),
        (887, 'چهار محال و بختیاری', 'دستناء', 9),
        (888, 'چهار محال و بختیاری', 'شلمزار', 9),
        (889, 'چهار محال و بختیاری', 'گهرو', 9),
        (890, 'چهار محال و بختیاری', 'ناغان', 9),
        (891, 'چهار محال و بختیاری', 'خراجی', 9),
        (892, 'چهار محال و بختیاری', 'مرغملک', 9),
        (893, 'چهار محال و بختیاری', 'شهریاری', 9),
        (894, 'چهار محال و بختیاری', 'اورگان-چهارمحال و بختیاری', 9),
        (895, 'چهار محال و بختیاری', 'امام قیس', 9),
        (896, 'چهار محال و بختیاری', 'گل سفید', 9),
        (897, 'چهار محال و بختیاری', 'چوله دان', 9),
        (898, 'چهار محال و بختیاری', 'چمن بید', 9),
        (899, 'چهار محال و بختیاری', 'سردشت-چهارمحال و بختیاری', 9),
        (900, 'چهار محال و بختیاری', 'دزک', 9),
        (901, 'خراسان جنوبی', 'ارسک', 10),
        (902, 'خراسان جنوبی', 'بشرویه', 10),
        (903, 'خراسان جنوبی', 'بیرجند', 10),
        (904, 'خراسان جنوبی', 'خوسف', 10),
        (905, 'خراسان جنوبی', 'محمدشهر', 10),
        (906, 'خراسان جنوبی', 'قهستان', 10),
        (907, 'خراسان جنوبی', 'طبس مسینا', 10),
        (908, 'خراسان جنوبی', 'گزیک', 10),
        (909, 'خراسان جنوبی', 'اسدیه', 10),
        (910, 'خراسان جنوبی', 'زهان', 10),
        (911, 'خراسان جنوبی', 'حاجی آباد', 10),
        (912, 'خراسان جنوبی', 'آیسک', 10),
        (913, 'خراسان جنوبی', 'سرایان', 10),
        (914, 'خراسان جنوبی', 'سه قلعه', 10),
        (915, 'خراسان جنوبی', 'سربیشه', 10),
        (916, 'خراسان جنوبی', 'مود', 10),
        (917, 'خراسان جنوبی', 'عشق آباد', 10),
        (918, 'خراسان جنوبی', 'دیهوک', 10),
        (919, 'خراسان جنوبی', 'طبس', 10),
        (920, 'خراسان جنوبی', 'اسلامیه', 10),
        (921, 'خراسان جنوبی', 'فردوس', 10),
        (922, 'خراسان جنوبی', 'آرین شهر', 10),
        (923, 'خراسان جنوبی', 'اسفدن', 10),
        (924, 'خراسان جنوبی', 'قائن', 10),
        (925, 'خراسان جنوبی', 'خضری دشت بیاض', 10),
        (926, 'خراسان جنوبی', 'نیمبلوک', 10),
        (927, 'خراسان جنوبی', 'شوسف', 10),
        (928, 'خراسان جنوبی', 'نهبندان', 10),
        (929, 'خراسان جنوبی', 'قاین', 10),
        (930, 'خراسان جنوبی', 'بیهود', 10),
        (931, 'خراسان جنوبی', 'گزو', 10),
        (932, 'خراسان رضوی', 'باخرز', 11),
        (933, 'خراسان رضوی', 'بجستان', 11),
        (934, 'خراسان رضوی', 'یونسی', 11),
        (935, 'خراسان رضوی', 'انابد', 11),
        (936, 'خراسان رضوی', 'شهرآباد', 11),
        (937, 'خراسان رضوی', 'بردسکن', 11),
        (938, 'خراسان رضوی', 'شاندیز', 11),
        (939, 'خراسان رضوی', 'طرقبه', 11),
        (940, 'خراسان رضوی', 'تایباد', 11),
        (941, 'خراسان رضوی', 'کاریز', 11),
        (942, 'خراسان رضوی', 'مشهدریزه', 11),
        (943, 'خراسان رضوی', 'احمدآباد صولت', 11),
        (944, 'خراسان رضوی', 'نیل شهر', 11),
        (945, 'خراسان رضوی', 'صالح آباد', 11),
        (946, 'خراسان رضوی', 'تربت جام', 11),
        (947, 'خراسان رضوی', 'نصرآباد', 11),
        (948, 'خراسان رضوی', 'بایک', 11),
        (949, 'خراسان رضوی', 'رباط سنگ', 11),
        (950, 'خراسان رضوی', 'تربت حیدریه', 11),
        (951, 'خراسان رضوی', 'کدکن', 11),
        (952, 'خراسان رضوی', 'جغتای', 11),
        (953, 'خراسان رضوی', 'نقاب', 11),
        (954, 'خراسان رضوی', 'گلمکان', 11),
        (955, 'خراسان رضوی', 'چناران', 11),
        (956, 'خراسان رضوی', 'کندر', 11),
        (957, 'خراسان رضوی', 'خلیل آباد', 11),
        (958, 'خراسان رضوی', 'قاسم آباد', 11),
        (959, 'خراسان رضوی', 'سلامی', 11),
        (960, 'خراسان رضوی', 'سنگان', 11),
        (961, 'خراسان رضوی', 'خواف', 11),
        (962, 'خراسان رضوی', 'نشتیفان', 11),
        (963, 'خراسان رضوی', 'سلطان آباد', 11),
        (964, 'خراسان رضوی', 'داورزن', 11),
        (965, 'خراسان رضوی', 'چاپشلو', 11),
        (966, 'خراسان رضوی', 'لطف آباد', 11),
        (967, 'خراسان رضوی', 'درگز', 11),
        (968, 'خراسان رضوی', 'نوخندان', 11),
        (969, 'خراسان رضوی', 'جنگل', 11),
        (970, 'خراسان رضوی', 'رشتخوار', 11),
        (971, 'خراسان رضوی', 'دولت آباد', 11),
        (972, 'خراسان رضوی', 'روداب', 11),
        (973, 'خراسان رضوی', 'ششتمد', 11),
        (974, 'خراسان رضوی', 'سبزوار', 11),
        (975, 'خراسان رضوی', 'مزدآوند', 11),
        (976, 'خراسان رضوی', 'سرخس', 11),
        (977, 'خراسان رضوی', 'سفید سنگ', 11),
        (978, 'خراسان رضوی', 'قلندر آباد', 11),
        (979, 'خراسان رضوی', 'فرهاد گرد', 11),
        (980, 'خراسان رضوی', 'فریمان', 11),
        (981, 'خراسان رضوی', 'همت آباد', 11),
        (982, 'خراسان رضوی', 'فیروزه', 11),
        (983, 'خراسان رضوی', 'باجگیران', 11),
        (984, 'خراسان رضوی', 'قوچان', 11),
        (985, 'خراسان رضوی', 'بیدخت', 11),
        (986, 'خراسان رضوی', 'گناباد', 11),
        (987, 'خراسان رضوی', 'کاخک', 11),
        (988, 'خراسان رضوی', 'ملک آباد', 11),
        (989, 'خراسان رضوی', 'رضویه', 11),
        (990, 'خراسان رضوی', 'مشهد', 11),
        (991, 'خراسان رضوی', 'شادمهر', 11),
        (992, 'خراسان رضوی', 'فیض آباد', 11),
        (993, 'خراسان رضوی', 'خرو', 11),
        (994, 'خراسان رضوی', 'درود', 11),
        (995, 'خراسان رضوی', 'قدمگاه', 11),
        (996, 'خراسان رضوی', 'چکنه', 11),
        (997, 'خراسان رضوی', 'بار', 11),
        (998, 'خراسان رضوی', 'نیشابور', 11),
        (999, 'خراسان رضوی', 'عشق آباد', 11),
        (1000, 'خراسان رضوی', 'کاشمر', 11),
        (1001, 'خراسان رضوی', 'ریوش', 11),
        (1002, 'خراسان رضوی', 'شهر زو', 11),
        (1003, 'خراسان رضوی', 'کلات', 11),
        (1004, 'خراسان رضوی', 'حسن ابادلایین نو', 11),
        (1005, 'خراسان رضوی', 'کپکان', 11),
        (1006, 'خراسان رضوی', 'شهرک زیندانلو', 11),
        (1007, 'خراسان رضوی', 'محمدتقی', 11),
        (1008, 'خراسان رضوی', 'سیوکی', 11),
        (1009, 'خراسان رضوی', 'مهنه', 11),
        (1010, 'خراسان رضوی', 'عبدل اباد', 11),
        (1011, 'خراسان رضوی', 'چخماق', 11),
        (1012, 'خراسان رضوی', 'قلعه اقاحسن', 11),
        (1013, 'خراسان رضوی', 'زرغری', 11),
        (1014, 'خراسان رضوی', 'باسفر', 11),
        (1015, 'خراسان رضوی', 'یک لنگی علیا', 11),
        (1016, 'خراسان رضوی', 'کامه سفلی', 11),
        (1017, 'خراسان رضوی', 'رودخانه', 11),
        (1018, 'خراسان رضوی', 'اسداباد-خراسان رضوی', 11),
        (1019, 'خراسان رضوی', 'نصر', 11),
        (1020, 'خراسان رضوی', 'مژن اباد', 11),
        (1021, 'خراسان رضوی', 'چمن اباد', 11),
        (1022, 'خراسان رضوی', 'حسن اباد-خراسان رضوی', 11),
        (1023, 'خراسان رضوی', 'چشمه گل', 11),
        (1024, 'خراسان رضوی', 'ابدال اباد', 11),
        (1025, 'خراسان رضوی', 'کاریزنو', 11),
        (1026, 'خراسان رضوی', 'درزاب', 11),
        (1027, 'خراسان رضوی', 'محموداباد-خراسان رضوی', 11),
        (1028, 'خراسان رضوی', 'یاقوتین جدید', 11),
        (1029, 'خراسان رضوی', 'جنت اباد-خراسان رضوی', 11),
        (1030, 'خراسان رضوی', 'موسی اباد-خراسان رضوی', 11),
        (1031, 'خراسان رضوی', 'بنی تاک', 11),
        (1032, 'خراسان رضوی', 'ازاده', 11),
        (1033, 'خراسان رضوی', 'دوقارون', 11),
        (1034, 'خراسان رضوی', 'کرات', 11),
        (1035, 'خراسان رضوی', 'قلعه نو-خراسان رضوی', 11),
        (1036, 'خراسان رضوی', 'کوه سفید', 11),
        (1037, 'خراسان رضوی', 'مهر-خراسان رضوی', 11),
        (1038, 'خراسان رضوی', 'رباطسرپوشی', 11),
        (1039, 'خراسان رضوی', 'مشکان-خراسان رضوی', 11),
        (1040, 'خراسان رضوی', 'نامن', 11),
        (1041, 'خراسان رضوی', 'مزینان', 11),
        (1042, 'خراسان رضوی', 'دستوران', 11),
        (1043, 'خراسان رضوی', 'ازادوار', 11),
        (1044, 'خراسان رضوی', 'راه چمن', 11),
        (1045, 'خراسان رضوی', 'انداده', 11),
        (1046, 'خراسان رضوی', 'حکم اباد', 11),
        (1047, 'خراسان رضوی', 'برغمد', 11),
        (1048, 'خراسان رضوی', 'بلاشی اباد', 11),
        (1049, 'خراسان رضوی', 'نوده انقلاب', 11),
        (1050, 'خراسان رضوی', 'رباطجز', 11),
        (1051, 'خراسان رضوی', 'شامکان', 11),
        (1052, 'خراسان رضوی', 'تندک', 11),
        (1053, 'خراسان رضوی', 'شوراب', 11),
        (1054, 'خراسان رضوی', 'گلبوی پایین', 11),
        (1055, 'خراسان رضوی', 'مبارکه-خراسان رضوی', 11),
        (1056, 'خراسان رضوی', 'برزنون', 11),
        (1057, 'خراسان رضوی', 'فدیشه', 11),
        (1058, 'خراسان رضوی', 'میراباد-خراسان رضوی', 11),
        (1059, 'خراسان رضوی', 'فرخک', 11),
        (1060, 'خراسان رضوی', 'اسحق اباد-خراسان رضوی', 11),
        (1061, 'خراسان رضوی', 'خوجان', 11),
        (1062, 'خراسان رضوی', 'کورده', 11),
        (1063, 'خراسان رضوی', 'طوس سفلی', 11),
        (1064, 'خراسان رضوی', 'قرقی سفلی (شهیدکاوه )', 11),
        (1065, 'خراسان رضوی', 'کنه بیست', 11),
        (1066, 'خراسان رضوی', 'رادکان', 11),
        (1067, 'خراسان رضوی', 'سیداباد-خراسان رضوی', 11),
        (1068, 'خراسان رضوی', 'گلبهار', 11),
        (1069, 'خراسان رضوی', 'سلوگرد', 11),
        (1070, 'خراسان رضوی', 'ارداک', 11),
        (1071, 'خراسان رضوی', 'بقمج', 11),
        (1072, 'خراسان رضوی', 'میامی-خراسان رضوی', 11),
        (1073, 'خراسان رضوی', 'چاهک', 11),
        (1074, 'خراسان رضوی', 'گوش', 11),
        (1075, 'خراسان رضوی', 'نریمانی سفلی', 11),
        (1076, 'خراسان رضوی', 'تقی اباد-خراسان رضوی', 11),
        (1077, 'خراسان رضوی', 'کچولی', 11),
        (1078, 'خراسان رضوی', 'شیرتپه', 11),
        (1079, 'خراسان رضوی', 'پس کمر', 11),
        (1080, 'خراسان رضوی', 'بزنگان', 11),
        (1081, 'خراسان رضوی', 'گنبدلی', 11),
        (1082, 'خراسان رضوی', 'کندک لی', 11),
        (1083, 'خراسان رضوی', 'کته شمشیرسفلی', 11),
        (1084, 'خراسان رضوی', 'سنگ بست', 11),
        (1085, 'خراسان رضوی', 'زرکک', 11),
        (1086, 'خراسان رضوی', 'رویینی', 11),
        (1087, 'خراسان رضوی', 'اوندر', 11),
        (1088, 'خراسان رضوی', 'دهنو-خراسان رضوی', 11),
        (1089, 'خراسان رضوی', 'فدافن', 11),
        (1090, 'خراسان رضوی', 'بندقرا', 11),
        (1091, 'خراسان رضوی', 'کاسف', 11),
        (1092, 'خراسان رضوی', 'کبودان', 11),
        (1093, 'خراسان رضوی', 'شفیع اباد', 11),
        (1094, 'خراسان رضوی', 'رکن اباد', 11),
        (1095, 'خراسان رضوی', 'درونه', 11),
        (1096, 'خراسان رضوی', 'گیسوربالا', 11),
        (1097, 'خراسان رضوی', 'زیبد', 11),
        (1098, 'خراسان رضوی', 'جزین', 11),
        (1099, 'خراسان رضوی', 'شهرکهنه', 11),
        (1100, 'خراسان رضوی', 'قریه شرف', 11),
        (1101, 'خراسان رضوی', 'یدک', 11),
        (1102, 'خراسان رضوی', 'دیزادیز', 11),
        (1103, 'خراسان رضوی', 'شفیع', 11),
        (1104, 'خراسان رضوی', 'دوغایی', 11),
        (1105, 'خراسان رضوی', 'جوزان-خراسان رضوی', 11),
        (1106, 'خراسان رضوی', 'امامقلی', 11),
        (1107, 'خراسان شمالی', 'صفی آباد', 12),
        (1108, 'خراسان شمالی', 'اسفراین', 12),
        (1109, 'خراسان شمالی', 'حصارگرمخان', 12),
        (1110, 'خراسان شمالی', 'بجنورد', 12),
        (1111, 'خراسان شمالی', 'چناران شهر', 12),
        (1112, 'خراسان شمالی', 'سنخواست', 12),
        (1113, 'خراسان شمالی', 'شوقان', 12),
        (1114, 'خراسان شمالی', 'جاجرم', 12),
        (1115, 'خراسان شمالی', 'راز', 12),
        (1116, 'خراسان شمالی', 'لوجلی', 12),
        (1117, 'خراسان شمالی', 'قوشخانه', 12),
        (1118, 'خراسان شمالی', 'زیارت', 12),
        (1119, 'خراسان شمالی', 'شیروان', 12),
        (1120, 'خراسان شمالی', 'تیتکانلو', 12),
        (1121, 'خراسان شمالی', 'فاروج', 12),
        (1122, 'خراسان شمالی', 'ایور', 12),
        (1123, 'خراسان شمالی', 'درق', 12),
        (1124, 'خراسان شمالی', 'گرمه', 12),
        (1125, 'خراسان شمالی', 'آوا', 12),
        (1126, 'خراسان شمالی', 'قاضی', 12),
        (1127, 'خراسان شمالی', 'پیش قلعه', 12),
        (1128, 'خراسان شمالی', 'آشخانه', 12),
        (1129, 'خراسان شمالی', 'خرق', 12),
        (1130, 'خراسان شمالی', 'دوین', 12),
        (1131, 'خراسان شمالی', 'رباط-خراسان شمالی', 12),
        (1132, 'خراسان شمالی', 'رزق اباد', 12),
        (1133, 'خوزستان', 'اروند کنار', 13),
        (1134, 'خوزستان', 'آبادان', 13),
        (1135, 'خوزستان', 'چوئبده', 13),
        (1136, 'خوزستان', 'آغاجاری', 13),
        (1137, 'خوزستان', 'جایزان', 13),
        (1138, 'خوزستان', 'امیدیه', 13),
        (1139, 'خوزستان', 'بیدروبه', 13),
        (1140, 'خوزستان', 'حسینیه', 13),
        (1141, 'خوزستان', 'آزادی', 13),
        (1142, 'خوزستان', 'اندیمشک', 13),
        (1143, 'خوزستان', 'چم گلک', 13),
        (1144, 'خوزستان', 'آبژدان', 13),
        (1145, 'خوزستان', 'قلعه خواجه', 13),
        (1146, 'خوزستان', 'الهایی', 13),
        (1147, 'خوزستان', 'اهواز', 13),
        (1148, 'خوزستان', 'دهدز', 13),
        (1149, 'خوزستان', 'ایذه', 13),
        (1150, 'خوزستان', 'صیدون', 13),
        (1151, 'خوزستان', 'باغ ملک', 13),
        (1152, 'خوزستان', 'قلعه تل', 13),
        (1153, 'خوزستان', 'میداود', 13),
        (1154, 'خوزستان', 'شیبان', 13),
        (1155, 'خوزستان', 'ملاثانی', 13),
        (1156, 'خوزستان', 'ویس', 13),
        (1157, 'خوزستان', 'بندر امام خمینی', 13),
        (1158, 'خوزستان', 'بندر ماهشهر', 13),
        (1159, 'خوزستان', 'چمران', 13),
        (1160, 'خوزستان', 'تشان', 13),
        (1161, 'خوزستان', 'سردشت', 13),
        (1162, 'خوزستان', 'بهبهان', 13),
        (1163, 'خوزستان', 'منصوریه', 13),
        (1164, 'خوزستان', 'حمیدیه', 13),
        (1165, 'خوزستان', 'خرمشهر', 13),
        (1166, 'خوزستان', 'مقاومت', 13),
        (1167, 'خوزستان', 'مینوشهر', 13),
        (1168, 'خوزستان', 'چغامیش', 13),
        (1169, 'خوزستان', 'حمزه', 13),
        (1170, 'خوزستان', 'سالند', 13),
        (1171, 'خوزستان', 'دزفول', 13),
        (1172, 'خوزستان', 'سیاه منصور', 13),
        (1173, 'خوزستان', 'شمس آباد', 13),
        (1174, 'خوزستان', 'شهر امام', 13),
        (1175, 'خوزستان', 'صفی آباد', 13),
        (1176, 'خوزستان', 'میانرود', 13),
        (1177, 'خوزستان', 'بستان', 13),
        (1178, 'خوزستان', 'ابوحمیظه', 13),
        (1179, 'خوزستان', 'سوسنگرد', 13),
        (1180, 'خوزستان', 'کوت سیدنعیم', 13),
        (1181, 'خوزستان', 'رامشیر', 13),
        (1182, 'خوزستان', 'مشراگه', 13),
        (1183, 'خوزستان', 'رامهرمز', 13),
        (1184, 'خوزستان', 'خنافره', 13),
        (1185, 'خوزستان', 'دارخوین', 13),
        (1186, 'خوزستان', 'شادگان', 13),
        (1187, 'خوزستان', 'الوان', 13),
        (1188, 'خوزستان', 'شاوور', 13),
        (1189, 'خوزستان', 'فتح المبین', 13),
        (1190, 'خوزستان', 'حر', 13),
        (1191, 'خوزستان', 'شوش', 13),
        (1192, 'خوزستان', 'گوریه', 13),
        (1193, 'خوزستان', 'سرداران', 13),
        (1194, 'خوزستان', 'شرافت', 13),
        (1195, 'خوزستان', 'شوشتر', 13),
        (1196, 'خوزستان', 'ترکالکی', 13),
        (1197, 'خوزستان', 'سماله', 13),
        (1198, 'خوزستان', 'جنت مکان', 13),
        (1199, 'خوزستان', 'صالح شهر', 13),
        (1200, 'خوزستان', 'گتوند', 13),
        (1201, 'خوزستان', 'لالی', 13),
        (1202, 'خوزستان', 'گلگیر', 13),
        (1203, 'خوزستان', 'مسجد سلیمان', 13),
        (1204, 'خوزستان', 'هفتگل', 13),
        (1205, 'خوزستان', 'زهره', 13),
        (1206, 'خوزستان', 'هندیجان', 13),
        (1207, 'خوزستان', 'هویزه', 13),
        (1208, 'خوزستان', 'رفیع', 13),
        (1209, 'خوزستان', 'کوت عبدالله', 13),
        (1210, 'خوزستان', 'الهائی', 13),
        (1211, 'خوزستان', 'فیاضی', 13),
        (1212, 'خوزستان', 'تنگ یک', 13),
        (1213, 'خوزستان', 'نهرسلیم', 13),
        (1214, 'خوزستان', 'نهرابطر', 13),
        (1215, 'خوزستان', 'عین دو', 13),
        (1216, 'خوزستان', 'ام الطمیر (سیدیوسف )', 13),
        (1217, 'خوزستان', 'قلعه چنعان', 13),
        (1218, 'خوزستان', 'کریت برومی', 13),
        (1219, 'خوزستان', 'غیزانیه بزرگ', 13),
        (1220, 'خوزستان', 'چم کلگه', 13),
        (1221, 'خوزستان', 'اسیاب', 13),
        (1222, 'خوزستان', 'گروه پدافندهوایی بهبها', 13),
        (1223, 'خوزستان', 'شاه غالب ده ابراهیم', 13),
        (1224, 'خوزستان', 'کردستان بزرگ', 13),
        (1225, 'خوزستان', 'میانکوه', 13),
        (1226, 'خوزستان', 'رودزرد', 13),
        (1227, 'خوزستان', 'نفت سفید', 13),
        (1228, 'خوزستان', 'دره تونم نمی', 13),
        (1229, 'خوزستان', 'چنارستان', 13),
        (1230, 'خوزستان', 'پشت پیان', 13),
        (1231, 'خوزستان', 'عبودی', 13),
        (1232, 'خوزستان', 'درویشی', 13),
        (1233, 'خوزستان', 'بوزی سیف', 13),
        (1234, 'خوزستان', 'حفاری شرقی', 13),
        (1235, 'خوزستان', 'بروایه یوسف', 13),
        (1236, 'خوزستان', 'یزدنو', 13),
        (1237, 'خوزستان', 'سیدعباس', 13),
        (1238, 'خوزستان', 'شهرک نورمحمدی', 13),
        (1239, 'خوزستان', 'گاومیش اباد', 13),
        (1240, 'خوزستان', 'عرب حسن', 13),
        (1241, 'خوزستان', 'امام', 13),
        (1242, 'خوزستان', 'چلون', 13),
        (1243, 'خوزستان', 'مزرعه یک', 13),
        (1244, 'خوزستان', 'خسرجی راضی حمد', 13),
        (1245, 'خوزستان', 'علمه تیمورابوذرغفاری', 13),
        (1246, 'خوزستان', 'شهرک بهرام', 13),
        (1247, 'خوزستان', 'شهرک انصار', 13),
        (1248, 'خوزستان', 'خواجوی', 13),
        (1249, 'خوزستان', 'کلگه دره دو', 13),
        (1250, 'خوزستان', 'تله زنگ پایین', 13),
        (1251, 'خوزستان', 'روستای عنبر', 13),
        (1252, 'خوزستان', 'دره بوری', 13),
        (1253, 'خوزستان', 'کوشکک-خوزستان', 13),
        (1254, 'زنجان', 'ابهر', 14),
        (1255, 'زنجان', 'صائین قلعه', 14),
        (1256, 'زنجان', 'هیدج', 14),
        (1257, 'زنجان', 'حلب', 14),
        (1258, 'زنجان', 'زرین آباد', 14),
        (1259, 'زنجان', 'گرماب', 14),
        (1260, 'زنجان', 'زرین رود', 14),
        (1261, 'زنجان', 'سجاس', 14),
        (1262, 'زنجان', 'سهرورد', 14),
        (1263, 'زنجان', 'قیدار', 14),
        (1264, 'زنجان', 'نوربهار', 14),
        (1265, 'زنجان', 'کرسف', 14),
        (1266, 'زنجان', 'خرمدره', 14),
        (1267, 'زنجان', 'نیک پی', 14),
        (1268, 'زنجان', 'ارمخانخانه', 14),
        (1269, 'زنجان', 'زنجان', 14),
        (1270, 'زنجان', 'سلطانیه', 14),
        (1271, 'زنجان', 'چورزق', 14),
        (1272, 'زنجان', 'آب بر', 14),
        (1273, 'زنجان', 'دندی', 14),
        (1274, 'زنجان', 'ماه نشان', 14),
        (1275, 'زنجان', 'همایون', 14),
        (1276, 'زنجان', 'بوغداکندی', 14),
        (1277, 'زنجان', 'اژدهاتو', 14),
        (1278, 'زنجان', 'اسفجین', 14),
        (1279, 'زنجان', 'ارمغانخانه', 14),
        (1280, 'زنجان', 'قبله بلاغی', 14),
        (1281, 'زنجان', 'پری', 14),
        (1282, 'زنجان', 'اندابادعلیا', 14),
        (1283, 'زنجان', 'قره گل', 14),
        (1284, 'زنجان', 'سونتو', 14),
        (1285, 'زنجان', 'قلتوق', 14),
        (1286, 'زنجان', 'گوزلدره', 14),
        (1287, 'زنجان', 'سنبل اباد', 14),
        (1288, 'زنجان', 'درسجین', 14),
        (1289, 'زنجان', 'دولت اباد-زنجان', 14),
        (1290, 'زنجان', 'کینه ورس', 14),
        (1291, 'زنجان', 'اقبلاغ سفلی', 14),
        (1292, 'زنجان', 'محموداباد-زنجان', 14),
        (1293, 'زنجان', 'باش قشلاق', 14),
        (1294, 'زنجان', 'کهلا', 14),
        (1295, 'زنجان', 'گیلوان', 14),
        (1296, 'زنجان', 'دستجرده', 14),
        (1297, 'زنجان', 'سعیداباد-زنجان', 14),
        (1298, 'زنجان', 'درام', 14),
        (1299, 'سمنان', 'آرادان', 15),
        (1300, 'سمنان', 'کهن آباد', 15),
        (1301, 'سمنان', 'امیریه', 15),
        (1302, 'سمنان', 'دامغان', 15),
        (1303, 'سمنان', 'دیباج', 15),
        (1304, 'سمنان', 'کلاته', 15),
        (1305, 'سمنان', 'سرخه', 15),
        (1306, 'سمنان', 'سمنان', 15),
        (1307, 'سمنان', 'بسطام', 15),
        (1308, 'سمنان', 'مجن', 15),
        (1309, 'سمنان', 'کلاته خیج', 15),
        (1310, 'سمنان', 'بیارجمند', 15),
        (1311, 'سمنان', 'رودیان', 15),
        (1312, 'سمنان', 'شاهرود', 15),
        (1313, 'سمنان', 'ایوانکی', 15),
        (1314, 'سمنان', 'گرمسار', 15),
        (1315, 'سمنان', 'شهمیرزاد', 15),
        (1316, 'سمنان', 'درجزین', 15),
        (1317, 'سمنان', 'مهدی شهر', 15),
        (1318, 'سمنان', 'میامی', 15),
        (1319, 'سمنان', 'علا', 15),
        (1320, 'سمنان', 'ابخوری', 15),
        (1321, 'سمنان', 'خیراباد-سمنان', 15),
        (1322, 'سمنان', 'ایستگاه میان دره', 15),
        (1323, 'سمنان', 'اهوان', 15),
        (1324, 'سمنان', 'جام', 15),
        (1325, 'سمنان', 'دوزهیر', 15),
        (1326, 'سمنان', 'معدن نمک', 15),
        (1327, 'سمنان', 'نظامی', 15),
        (1328, 'سمنان', 'اسداباد-سمنان', 15),
        (1329, 'سمنان', 'لاسجرد', 15),
        (1330, 'سمنان', 'سیداباد-سمنان', 15),
        (1331, 'سمنان', 'عبدالله ابادپایین', 15),
        (1332, 'سمنان', 'بیابانک', 15),
        (1333, 'سمنان', 'مومن اباد-سمنان', 15),
        (1334, 'سمنان', 'دربند', 15),
        (1335, 'سمنان', 'گل رودبار', 15),
        (1336, 'سمنان', 'ابگرم-سمنان', 15),
        (1337, 'سمنان', 'افتر', 15),
        (1338, 'سمنان', 'فولادمحله', 15),
        (1339, 'سمنان', 'ده صوفیان', 15),
        (1340, 'سمنان', 'هیکو', 15),
        (1341, 'سمنان', 'چاشم', 15),
        (1342, 'سمنان', 'کردوان', 15),
        (1343, 'سمنان', 'مندولک', 15),
        (1344, 'سمنان', 'داوراباد', 15),
        (1345, 'سمنان', 'بن کوه', 15),
        (1346, 'سمنان', 'حسین ابادکوروس', 15),
        (1347, 'سمنان', 'کرک', 15),
        (1348, 'سمنان', 'گلستانک', 15),
        (1349, 'سمنان', 'لجران', 15),
        (1350, 'سمنان', 'جودانه', 15),
        (1351, 'سمنان', 'ابراهیم اباد-سمنان', 15),
        (1352, 'سمنان', 'بکران', 15),
        (1353, 'سمنان', 'کرداباد', 15),
        (1354, 'سمنان', 'نردین', 15),
        (1355, 'سمنان', 'سوداغلان', 15),
        (1356, 'سمنان', 'فرومد', 15),
        (1357, 'سمنان', 'ابرسیج', 15),
        (1358, 'سمنان', 'میغان', 15),
        (1359, 'سمنان', 'قلعه نوخرقان', 15),
        (1360, 'سمنان', 'چهلدخترپادگان', 15),
        (1361, 'سمنان', 'نگارمن', 15),
        (1362, 'سمنان', 'دهملا', 15),
        (1363, 'سمنان', 'رویان-سمنان', 15),
        (1364, 'سمنان', 'بدشت', 15),
        (1365, 'سمنان', 'سطوه', 15),
        (1366, 'سمنان', 'طرود', 15),
        (1367, 'سمنان', 'مغان', 15),
        (1368, 'سمنان', 'گیور', 15),
        (1369, 'سمنان', 'دستجرد-سمنان', 15),
        (1370, 'سمنان', 'مسیح اباد', 15),
        (1371, 'سمنان', 'احمداباد', 15),
        (1372, 'سمنان', 'زمان اباد', 15),
        (1373, 'سمنان', 'سلمرود', 15),
        (1374, 'سمنان', 'جزن', 15),
        (1375, 'سمنان', 'برم', 15),
        (1376, 'سمنان', 'محمداباد', 15),
        (1377, 'سمنان', 'معصوم اباد', 15),
        (1378, 'سمنان', 'فرات', 15),
        (1379, 'سمنان', 'علیان', 15),
        (1380, 'سمنان', 'عمروان', 15),
        (1381, 'سمنان', 'قوشه', 15),
        (1382, 'سمنان', 'دروار', 15),
        (1383, 'سمنان', 'استانه', 15),
        (1384, 'سمنان', 'طرزه', 15),
        (1385, 'سمنان', 'مهماندوست', 15),
        (1386, 'سمنان', 'کلاته ملا', 15),
        (1387, 'سمنان', 'قدرت اباد', 15),
        (1388, 'سیستان و بلوچستان', 'بزمان', 16),
        (1389, 'سیستان و بلوچستان', 'بمپور', 16),
        (1390, 'سیستان و بلوچستان', 'محمدان', 16),
        (1391, 'سیستان و بلوچستان', 'ایرانشهر', 16),
        (1392, 'سیستان و بلوچستان', 'نگور', 16),
        (1393, 'سیستان و بلوچستان', 'چاه بهار', 16),
        (1394, 'سیستان و بلوچستان', 'خاش', 16),
        (1395, 'سیستان و بلوچستان', 'نوک آباد', 16),
        (1396, 'سیستان و بلوچستان', 'گلمورتی', 16),
        (1397, 'سیستان و بلوچستان', 'بنجار', 16),
        (1398, 'سیستان و بلوچستان', 'زابل', 16),
        (1399, 'سیستان و بلوچستان', 'زاهدان', 16),
        (1400, 'سیستان و بلوچستان', 'نصرت آباد', 16),
        (1401, 'سیستان و بلوچستان', 'زهک', 16),
        (1402, 'سیستان و بلوچستان', 'سیرکان', 16),
        (1403, 'سیستان و بلوچستان', 'جالق', 16),
        (1404, 'سیستان و بلوچستان', 'سراوان', 16),
        (1405, 'سیستان و بلوچستان', 'گشت', 16),
        (1406, 'سیستان و بلوچستان', 'محمدی', 16),
        (1407, 'سیستان و بلوچستان', 'پیشین', 16),
        (1408, 'سیستان و بلوچستان', 'سرباز', 16),
        (1409, 'سیستان و بلوچستان', 'راسک', 16),
        (1410, 'سیستان و بلوچستان', 'سوران', 16),
        (1411, 'سیستان و بلوچستان', 'هیدوچ', 16),
        (1412, 'سیستان و بلوچستان', 'فنوج', 16),
        (1413, 'سیستان و بلوچستان', 'قصر قند', 16),
        (1414, 'سیستان و بلوچستان', 'مهرستان', 16),
        (1415, 'سیستان و بلوچستان', 'میرجاوه', 16),
        (1416, 'سیستان و بلوچستان', 'ادیمی', 16),
        (1417, 'سیستان و بلوچستان', 'بنت', 16),
        (1418, 'سیستان و بلوچستان', 'اسپکه', 16),
        (1419, 'سیستان و بلوچستان', 'نیک شهر', 16),
        (1420, 'سیستان و بلوچستان', 'علی اکبر', 16),
        (1421, 'سیستان و بلوچستان', 'محمد آباد', 16),
        (1422, 'سیستان و بلوچستان', 'دوست محمد', 16),
        (1423, 'سیستان و بلوچستان', 'زرآباد', 16),
        (1424, 'سیستان و بلوچستان', 'کنارک', 16),
        (1425, 'سیستان و بلوچستان', 'خواجه احمد', 16),
        (1426, 'سیستان و بلوچستان', 'چابهار', 16),
        (1427, 'سیستان و بلوچستان', 'حرمک', 16),
        (1428, 'سیستان و بلوچستان', 'گلوگاه-سیستان و بلوچستان', 16),
        (1429, 'سیستان و بلوچستان', 'انده قدیم', 16),
        (1430, 'سیستان و بلوچستان', 'لادیزعلیا', 16),
        (1431, 'سیستان و بلوچستان', 'هیرمند', 16),
        (1432, 'سیستان و بلوچستان', 'سیادک', 16),
        (1433, 'سیستان و بلوچستان', 'خمک', 16),
        (1434, 'سیستان و بلوچستان', 'تخت عدالت', 16),
        (1435, 'سیستان و بلوچستان', 'برجمیرگل', 16),
        (1436, 'سیستان و بلوچستان', 'جهان ابادعلیا', 16),
        (1437, 'سیستان و بلوچستان', 'تیموراباد', 16),
        (1438, 'سیستان و بلوچستان', 'دولت اباد-سیستان و بلوچستان', 16),
        (1439, 'سیستان و بلوچستان', 'لوتک', 16),
        (1440, 'سیستان و بلوچستان', 'سکوهه', 16),
        (1441, 'سیستان و بلوچستان', 'جزینک', 16),
        (1442, 'سیستان و بلوچستان', 'قلعه نو-سیستان و بلوچستان', 16),
        (1443, 'سیستان و بلوچستان', 'شهرک محمدشاه کرم', 16),
        (1444, 'سیستان و بلوچستان', 'ژاله ای', 16),
        (1445, 'سیستان و بلوچستان', 'کرباسک', 16),
        (1446, 'سیستان و بلوچستان', 'نوک اباد', 16),
        (1447, 'سیستان و بلوچستان', 'نوراباد', 16),
        (1448, 'سیستان و بلوچستان', 'کارواندر', 16),
        (1449, 'سیستان و بلوچستان', 'ناصراباد-سیستان و بلوچستان', 16),
        (1450, 'سیستان و بلوچستان', 'بالاقلعه', 16),
        (1451, 'سیستان و بلوچستان', 'گمن', 16),
        (1452, 'سیستان و بلوچستان', 'زیرکدان', 16),
        (1453, 'سیستان و بلوچستان', 'بیت اباد', 16),
        (1454, 'سیستان و بلوچستان', 'گوهرکوه', 16),
        (1455, 'سیستان و بلوچستان', 'ده پابید', 16),
        (1456, 'سیستان و بلوچستان', 'نازیل', 16),
        (1457, 'سیستان و بلوچستان', 'کوشه', 16),
        (1458, 'سیستان و بلوچستان', 'سنگان-سیستان و بلوچستان', 16),
        (1459, 'سیستان و بلوچستان', 'افضل اباد', 16),
        (1460, 'سیستان و بلوچستان', 'چانف', 16),
        (1461, 'سیستان و بلوچستان', 'اسماعیل کلگ', 16),
        (1462, 'سیستان و بلوچستان', 'پارود', 16),
        (1463, 'سیستان و بلوچستان', 'ایرافشان', 16),
        (1464, 'سیستان و بلوچستان', 'سرداب', 16),
        (1465, 'سیستان و بلوچستان', 'پیپ', 16),
        (1466, 'سیستان و بلوچستان', 'هودیان', 16),
        (1467, 'سیستان و بلوچستان', 'کوشکوک', 16),
        (1468, 'سیستان و بلوچستان', 'سردک', 16),
        (1469, 'سیستان و بلوچستان', 'اسفندک', 16),
        (1470, 'سیستان و بلوچستان', 'کوهک', 16),
        (1471, 'سیستان و بلوچستان', 'پسکوه', 16),
        (1472, 'سیستان و بلوچستان', 'طیس', 16),
        (1473, 'سیستان و بلوچستان', 'تلنگ', 16),
        (1474, 'سیستان و بلوچستان', 'پلان', 16),
        (1475, 'سیستان و بلوچستان', 'باهوکلات', 16),
        (1476, 'سیستان و بلوچستان', 'پسابندر', 16),
        (1477, 'سیستان و بلوچستان', 'پیرسهراب', 16),
        (1478, 'سیستان و بلوچستان', 'شهدادکهیر', 16),
        (1479, 'سیستان و بلوچستان', 'زراباد', 16),
        (1480, 'سیستان و بلوچستان', 'مسکوتان', 16),
        (1481, 'سیستان و بلوچستان', 'کتیج', 16),
        (1482, 'سیستان و بلوچستان', 'دستگرد-سیستان و بلوچستان', 16),
        (1483, 'سیستان و بلوچستان', 'محنت', 16),
        (1484, 'سیستان و بلوچستان', 'چاهان', 16),
        (1485, 'سیستان و بلوچستان', 'هیچان', 16),
        (1486, 'سیستان و بلوچستان', 'شگیم بالا', 16),
        (1487, 'سیستان و بلوچستان', 'کشیک', 16),
        (1488, 'سیستان و بلوچستان', 'ساربوک', 16);
        INSERT INTO `city` (`id`, `province`, `city`, `province_id`) VALUES
        (1489, 'فارس', 'آباده', 17),
        (1490, 'فارس', 'ایزد خواست', 17),
        (1491, 'فارس', 'بهمن', 17),
        (1492, 'فارس', 'سورمق', 17),
        (1493, 'فارس', 'صغاد', 17),
        (1494, 'فارس', 'ارسنجان', 17),
        (1495, 'فارس', 'رونیز', 17),
        (1496, 'فارس', 'استهبان', 17),
        (1497, 'فارس', 'ایج', 17),
        (1498, 'فارس', 'حسن آباد', 17),
        (1499, 'فارس', 'دژکرد', 17),
        (1500, 'فارس', 'سده', 17),
        (1501, 'فارس', 'اقلید', 17),
        (1502, 'فارس', 'حسامی', 17),
        (1503, 'فارس', 'کره ای', 17),
        (1504, 'فارس', 'بوانات', 17),
        (1505, 'فارس', 'مزایجان', 17),
        (1506, 'فارس', 'مادرسلیمان', 17),
        (1507, 'فارس', 'سعادت شهر', 17),
        (1508, 'فارس', 'باب انار', 17),
        (1509, 'فارس', 'خاوران', 17),
        (1510, 'فارس', 'دوزه', 17),
        (1511, 'فارس', 'جهرم', 17),
        (1512, 'فارس', 'قطب آباد', 17),
        (1513, 'فارس', 'خرامه', 17),
        (1514, 'فارس', 'سلطان شهر', 17),
        (1515, 'فارس', 'صفا شهر', 17),
        (1516, 'فارس', 'قادرآباد', 17),
        (1517, 'فارس', 'خنج', 17),
        (1518, 'فارس', 'دوبرجی', 17),
        (1519, 'فارس', 'فدامی', 17),
        (1520, 'فارس', 'جنت شهر', 17),
        (1521, 'فارس', 'داراب', 17),
        (1522, 'فارس', 'کوپن', 17),
        (1523, 'فارس', 'مصیری', 17),
        (1524, 'فارس', 'شهر پیر', 17),
        (1525, 'فارس', 'حاجی آباد', 17),
        (1526, 'فارس', 'دبیران', 17),
        (1527, 'فارس', 'بیضا', 17),
        (1528, 'فارس', 'اردکان', 17),
        (1529, 'فارس', 'هماشهر', 17),
        (1530, 'فارس', 'سروستان', 17),
        (1531, 'فارس', 'کوهنجان', 17),
        (1532, 'فارس', 'خانه زنیان', 17),
        (1533, 'فارس', 'زرقان', 17),
        (1534, 'فارس', 'لپوئی', 17),
        (1535, 'فارس', 'داریان', 17),
        (1536, 'فارس', 'شهر جدید صدرا', 17),
        (1537, 'فارس', 'شیراز', 17),
        (1538, 'فارس', 'دهرم', 17),
        (1539, 'فارس', 'فراشبند', 17),
        (1540, 'فارس', 'نوجین', 17),
        (1541, 'فارس', 'ششده', 17),
        (1542, 'فارس', 'قره بلاغ', 17),
        (1543, 'فارس', 'زاهد شهر', 17),
        (1544, 'فارس', 'میانشهر', 17),
        (1545, 'فارس', 'فسا', 17),
        (1546, 'فارس', 'نوبندگان', 17),
        (1547, 'فارس', 'فیروزآباد', 17),
        (1548, 'فارس', 'میمند', 17),
        (1549, 'فارس', 'افزر', 17),
        (1550, 'فارس', 'امام شهر', 17),
        (1551, 'فارس', 'قیر', 17),
        (1552, 'فارس', 'مبارک آباد', 17),
        (1553, 'فارس', 'کارزین', 17),
        (1554, 'فارس', 'گراش', 17),
        (1555, 'فارس', 'اوز', 17),
        (1556, 'فارس', 'بنارویه', 17),
        (1557, 'فارس', 'بیرم', 17),
        (1558, 'فارس', 'جویم', 17),
        (1559, 'فارس', 'عماد ده', 17),
        (1560, 'فارس', 'خور', 17),
        (1561, 'فارس', 'لار', 17),
        (1562, 'فارس', 'لطیفی', 17),
        (1563, 'فارس', 'اشکنان', 17),
        (1564, 'فارس', 'اهل', 17),
        (1565, 'فارس', 'علامرودشت', 17),
        (1566, 'فارس', 'لامرد', 17),
        (1567, 'فارس', 'رامجرد', 17),
        (1568, 'فارس', 'سیدان', 17),
        (1569, 'فارس', 'مرودشت', 17),
        (1570, 'فارس', 'کامفیروز', 17),
        (1571, 'فارس', 'خانیمن', 17),
        (1572, 'فارس', 'بابامنیر', 17),
        (1573, 'فارس', 'خومه زار', 17),
        (1574, 'فارس', 'نورآباد', 17),
        (1575, 'فارس', 'اسیر', 17),
        (1576, 'فارس', 'گله دار', 17),
        (1577, 'فارس', 'مهر', 17),
        (1578, 'فارس', 'خوزی', 17),
        (1579, 'فارس', 'وراوی', 17),
        (1580, 'فارس', 'آباده طشک', 17),
        (1581, 'فارس', 'مشکان', 17),
        (1582, 'فارس', 'قطرویه', 17),
        (1583, 'فارس', 'نی ریز', 17),
        (1584, 'فارس', 'بالاده', 17),
        (1585, 'فارس', 'قائمیه', 17),
        (1586, 'فارس', 'خشت', 17),
        (1587, 'فارس', 'کازرون', 17),
        (1588, 'فارس', 'کنار تخته', 17),
        (1589, 'فارس', 'نودان', 17),
        (1590, 'فارس', 'کوار', 17),
        (1591, 'فارس', 'بندامیر', 17),
        (1592, 'فارس', 'خیرابادتوللی', 17),
        (1593, 'فارس', 'کم جان', 17),
        (1594, 'فارس', 'شوریجه', 17),
        (1595, 'فارس', 'مهارلو', 17),
        (1596, 'فارس', 'سلطان آباد-فارس', 17),
        (1597, 'فارس', 'تفیهان', 17),
        (1598, 'فارس', 'طسوج', 17),
        (1599, 'فارس', 'اکبراباد', 17),
        (1600, 'فارس', 'مظفری', 17),
        (1601, 'فارس', 'کوشک بیدک', 17),
        (1602, 'فارس', 'فتح اباد-فارس', 17),
        (1603, 'فارس', 'دهفیش', 17),
        (1604, 'فارس', 'پاسگاه چنارراهدار', 17),
        (1605, 'فارس', 'موردراز', 17),
        (1606, 'فارس', 'کلاتون', 17),
        (1607, 'فارس', 'کلانی', 17),
        (1608, 'فارس', 'کمارج مرکزی', 17),
        (1609, 'فارس', 'مهبودی علیا', 17),
        (1610, 'فارس', 'حکیم باشی نصف میان (بالا)', 17),
        (1611, 'فارس', 'انارستان-فارس', 17),
        (1612, 'فارس', 'مهرنجان', 17),
        (1613, 'فارس', 'جره', 17),
        (1614, 'فارس', 'گویم', 17),
        (1615, 'فارس', 'اهنگری', 17),
        (1616, 'فارس', 'پرین', 17),
        (1617, 'فارس', 'حسین ابادرستم', 17),
        (1618, 'فارس', 'میشان سفلی', 17),
        (1619, 'فارس', 'بهرغان', 17),
        (1620, 'فارس', 'کمهر', 17),
        (1621, 'فارس', 'راشک علیا', 17),
        (1622, 'فارس', 'هرایجان', 17),
        (1623, 'فارس', 'بانش', 17),
        (1624, 'فارس', 'کوشک-فارس', 17),
        (1625, 'فارس', 'کوشکک-فارس', 17),
        (1626, 'فارس', 'خنجشت', 17),
        (1627, 'فارس', 'امامزاده اسماعیل', 17),
        (1628, 'فارس', 'اسپاس', 17),
        (1629, 'فارس', 'شهرمیان', 17),
        (1630, 'فارس', 'بندبست', 17),
        (1631, 'فارس', 'فیشور', 17),
        (1632, 'فارس', 'کهنه', 17),
        (1633, 'فارس', 'بنوان', 17),
        (1634, 'فارس', 'درب قلعه', 17),
        (1635, 'فارس', 'دنیان', 17),
        (1636, 'فارس', 'سروو', 17),
        (1637, 'فارس', 'مانیان', 17),
        (1638, 'فارس', 'به جان', 17),
        (1639, 'فارس', 'کوشک قاضی', 17),
        (1640, 'فارس', 'قاسم ابادسفلی', 17),
        (1641, 'فارس', 'میانده-فارس', 17),
        (1642, 'فارس', 'صحرارود', 17),
        (1643, 'فارس', 'بایگان', 17),
        (1644, 'فارس', 'جوکان', 17),
        (1645, 'فارس', 'مادوان-فارس', 17),
        (1646, 'فارس', 'ماه سالاری', 17),
        (1647, 'فارس', 'رستاق', 17),
        (1648, 'فارس', 'چمن مروارید', 17),
        (1649, 'فارس', 'لای حنا', 17),
        (1650, 'فارس', 'قطاربنه', 17),
        (1651, 'فارس', 'هرگان', 17),
        (1652, 'قزوین', 'خاکعلی', 18),
        (1653, 'قزوین', 'آبیک', 18),
        (1654, 'قزوین', 'آبگرم', 18),
        (1655, 'قزوین', 'آوج', 18),
        (1656, 'قزوین', 'بیدستان', 18),
        (1657, 'قزوین', 'شریفیه', 18),
        (1658, 'قزوین', 'محمدیه', 18),
        (1659, 'قزوین', 'الوند', 18),
        (1660, 'قزوین', 'ارداق', 18),
        (1661, 'قزوین', 'دانسفهان', 18),
        (1662, 'قزوین', 'شال', 18),
        (1663, 'قزوین', 'بوئین زهرا', 18),
        (1664, 'قزوین', 'سگز آباد', 18),
        (1665, 'قزوین', 'اسفرورین', 18),
        (1666, 'قزوین', 'خرمدشت', 18),
        (1667, 'قزوین', 'ضیاء آباد', 18),
        (1668, 'قزوین', 'تاکستان', 18),
        (1669, 'قزوین', 'نرجه', 18),
        (1670, 'قزوین', 'معلم کلایه', 18),
        (1671, 'قزوین', 'رازمیان', 18),
        (1672, 'قزوین', 'سیردان', 18),
        (1673, 'قزوین', 'اقبالیه', 18),
        (1674, 'قزوین', 'قزوین', 18),
        (1675, 'قزوین', 'محمود آباد نمونه', 18),
        (1676, 'قزوین', 'کوهین', 18),
        (1677, 'قزوین', 'نصرت آباد-قزوین', 18),
        (1678, 'قزوین', 'الولک', 18),
        (1679, 'قزوین', 'کاکوهستان', 18),
        (1680, 'قزوین', 'فلار', 18),
        (1681, 'قزوین', 'مینودشت', 18),
        (1682, 'قزوین', 'زوارک', 18),
        (1683, 'قزوین', 'صمغ اباد', 18),
        (1684, 'قزوین', 'ناصراباد-قزوین', 18),
        (1685, 'قزوین', 'رشتقون', 18),
        (1686, 'قزوین', 'قشلاق', 18),
        (1687, 'قزوین', 'شهرک صنعتی لیا (قدیم )', 18),
        (1688, 'قزوین', 'عصمت اباد', 18),
        (1689, 'قزوین', 'خرم اباد', 18),
        (1690, 'قزوین', 'کلنجین', 18),
        (1691, 'قزوین', 'استبلخ', 18),
        (1692, 'قزوین', 'نیارج', 18),
        (1693, 'قزوین', 'حصارولیعصر', 18),
        (1694, 'قزوین', 'ماهین', 18),
        (1695, 'قزوین', 'سیاهپوش', 18),
        (1696, 'قزوین', 'نیارک', 18),
        (1697, 'قزوین', 'اقابابا', 18),
        (1698, 'قزوین', 'حسین اباد-قزوین', 18),
        (1699, 'قزوین', 'رحیم اباد', 18),
        (1700, 'قزوین', 'مهرگان', 18),
        (1701, 'قزوین', 'یحیی اباد-قزوین', 18),
        (1702, 'قزوین', 'نیکویه', 18),
        (1703, 'قم', 'جعفریه', 19),
        (1704, 'قم', 'دستجرد', 19),
        (1705, 'قم', 'سلفچگان', 19),
        (1706, 'قم', 'قم', 19),
        (1707, 'قم', 'قنوات', 19),
        (1708, 'قم', 'کهک', 19),
        (1709, 'قم', 'امیرابادگنجی', 19),
        (1710, 'قم', 'قمرود', 19),
        (1711, 'قم', 'قلعه چم', 19),
        (1712, 'قم', 'قاهان', 19),
        (1713, 'قم', 'جنداب', 19),
        (1714, 'کردستان', 'آرمرده', 20),
        (1715, 'کردستان', 'بانه', 20),
        (1716, 'کردستان', 'کانی سور', 20),
        (1717, 'کردستان', 'بوئین سفلی', 20),
        (1718, 'کردستان', 'بابارشانی', 20),
        (1719, 'کردستان', 'پیرتاج', 20),
        (1720, 'کردستان', 'بیجار', 20),
        (1721, 'کردستان', 'توپ آغاج', 20),
        (1722, 'کردستان', 'یاسوکند', 20),
        (1723, 'کردستان', 'بلبان آباد', 20),
        (1724, 'کردستان', 'دهگلان', 20),
        (1725, 'کردستان', 'دیواندره', 20),
        (1726, 'کردستان', 'زرینه', 20),
        (1727, 'کردستان', 'اورامان تخت', 20),
        (1728, 'کردستان', 'سرو آباد', 20),
        (1729, 'کردستان', 'صاحب', 20),
        (1730, 'کردستان', 'سقز', 20),
        (1731, 'کردستان', 'سنندج', 20),
        (1732, 'کردستان', 'شویشه', 20),
        (1733, 'کردستان', 'دزج', 20),
        (1734, 'کردستان', 'سریش آباد', 20),
        (1735, 'کردستان', 'دلبران', 20),
        (1736, 'کردستان', 'قروه', 20),
        (1737, 'کردستان', 'برده رشه', 20),
        (1738, 'کردستان', 'چناره', 20),
        (1739, 'کردستان', 'مریوان', 20),
        (1740, 'کردستان', 'کانی دینار', 20),
        (1741, 'کردستان', 'کامیاران', 20),
        (1742, 'کردستان', 'موچش', 20),
        (1743, 'کردستان', 'شاهینی', 20),
        (1744, 'کردستان', 'طای', 20),
        (1745, 'کردستان', 'گازرخانی', 20),
        (1746, 'کردستان', 'نشورسفلی', 20),
        (1747, 'کردستان', 'شیروانه', 20),
        (1748, 'کردستان', 'خامسان', 20),
        (1749, 'کردستان', 'شریف اباد', 20),
        (1750, 'کردستان', 'کوله', 20),
        (1751, 'کردستان', 'هزارکانیان', 20),
        (1752, 'کردستان', 'گورباباعلی', 20),
        (1753, 'کردستان', 'گاوشله', 20),
        (1754, 'کردستان', 'خرکه', 20),
        (1755, 'کردستان', 'توپ اغاج', 20),
        (1756, 'کردستان', 'اق بلاغ طغامین', 20),
        (1757, 'کردستان', 'خسرواباد-کردستان', 20),
        (1758, 'کردستان', 'جعفراباد-کردستان', 20),
        (1759, 'کردستان', 'کانی گنجی', 20),
        (1760, 'کردستان', 'قوریچای', 20),
        (1761, 'کردستان', 'نی', 20),
        (1762, 'کردستان', 'پیرخضران', 20),
        (1763, 'کردستان', 'بیساران', 20),
        (1764, 'کردستان', 'سرا', 20),
        (1765, 'کردستان', 'گل تپه-کردستان', 20),
        (1766, 'کردستان', 'تیلکو', 20),
        (1767, 'کردستان', 'خورخوره-کردستان', 20),
        (1768, 'کردستان', 'کسنزان', 20),
        (1769, 'کردستان', 'میرده', 20),
        (1770, 'کردستان', 'ننور', 20),
        (1771, 'کردستان', 'بوالحسن', 20),
        (1772, 'کردستان', 'کوخان', 20),
        (1773, 'کردستان', 'شوی', 20),
        (1774, 'کرمان', 'ارزوئیه', 21),
        (1775, 'کرمان', 'امین شهر', 21),
        (1776, 'کرمان', 'انار', 21),
        (1777, 'کرمان', 'بافت', 21),
        (1778, 'کرمان', 'بزنجان', 21),
        (1779, 'کرمان', 'لاله زار', 21),
        (1780, 'کرمان', 'بردسیر', 21),
        (1781, 'کرمان', 'دشتکار', 21),
        (1782, 'کرمان', 'گلزار', 21),
        (1783, 'کرمان', 'نگار', 21),
        (1784, 'کرمان', 'بروات', 21),
        (1785, 'کرمان', 'بم', 21),
        (1786, 'کرمان', 'بلوک', 21),
        (1787, 'کرمان', 'جبالبارز', 21),
        (1788, 'کرمان', 'درب بهشت', 21),
        (1789, 'کرمان', 'جیرفت', 21),
        (1790, 'کرمان', 'رابر', 21),
        (1791, 'کرمان', 'هنزا', 21),
        (1792, 'کرمان', 'راور', 21),
        (1793, 'کرمان', 'هجدک', 21),
        (1794, 'کرمان', 'صفائیه', 21),
        (1795, 'کرمان', 'رفسنجان', 21),
        (1796, 'کرمان', 'مس سرچشمه', 21),
        (1797, 'کرمان', 'بهرمان', 21),
        (1798, 'کرمان', 'کشکوئیه', 21),
        (1799, 'کرمان', 'زهکلوت', 21),
        (1800, 'کرمان', 'رودبار', 21),
        (1801, 'کرمان', 'گنبکی', 21),
        (1802, 'کرمان', 'محمد آباد', 21),
        (1803, 'کرمان', 'خانوک', 21),
        (1804, 'کرمان', 'ریحان', 21),
        (1805, 'کرمان', 'زرند', 21),
        (1806, 'کرمان', 'یزدان شهر', 21),
        (1807, 'کرمان', 'بلورد', 21),
        (1808, 'کرمان', 'پاریز', 21),
        (1809, 'کرمان', 'هماشهر', 21),
        (1810, 'کرمان', 'خواجوشهر', 21),
        (1811, 'کرمان', 'زید آباد', 21),
        (1812, 'کرمان', 'سیرجان', 21),
        (1813, 'کرمان', 'نجف شهر', 21),
        (1814, 'کرمان', 'جوزم', 21),
        (1815, 'کرمان', 'دهج', 21),
        (1816, 'کرمان', 'خاتون آباد', 21),
        (1817, 'کرمان', 'خورسند', 21),
        (1818, 'کرمان', 'شهر بابک', 21),
        (1819, 'کرمان', 'مردهک', 21),
        (1820, 'کرمان', 'دوساری', 21),
        (1821, 'کرمان', 'عنبر آباد', 21),
        (1822, 'کرمان', 'فاریاب', 21),
        (1823, 'کرمان', 'فهرج', 21),
        (1824, 'کرمان', 'قلعه گنج', 21),
        (1825, 'کرمان', 'نودژ', 21),
        (1826, 'کرمان', 'منوجان', 21),
        (1827, 'کرمان', 'نظام شهر', 21),
        (1828, 'کرمان', 'نرماشیر', 21),
        (1829, 'کرمان', 'چترود', 21),
        (1830, 'کرمان', 'کاظم آباد', 21),
        (1831, 'کرمان', 'راین', 21),
        (1832, 'کرمان', 'اندوهجرد', 21),
        (1833, 'کرمان', 'شهداد', 21),
        (1834, 'کرمان', 'گلباف', 21),
        (1835, 'کرمان', 'جوپار', 21),
        (1836, 'کرمان', 'ماهان', 21),
        (1837, 'کرمان', 'محی آباد', 21),
        (1838, 'کرمان', 'اختیار آباد', 21),
        (1839, 'کرمان', 'باغین', 21),
        (1840, 'کرمان', 'زنگی آباد', 21),
        (1841, 'کرمان', 'کرمان', 21),
        (1842, 'کرمان', 'کهنوج', 21),
        (1843, 'کرمان', 'کیانشهر', 21),
        (1844, 'کرمان', 'کوهبنان', 21),
        (1845, 'کرمان', 'سرچشمه', 21),
        (1846, 'کرمان', 'ده بالا', 21),
        (1847, 'کرمان', 'جوشان', 21),
        (1848, 'کرمان', 'کشیت', 21),
        (1849, 'کرمان', 'فیض اباد', 21),
        (1850, 'کرمان', 'دریجان', 21),
        (1851, 'کرمان', 'برج معاز', 21),
        (1852, 'کرمان', 'خانه خاتون', 21),
        (1853, 'کرمان', 'ابارق', 21),
        (1854, 'کرمان', 'گروه', 21),
        (1855, 'کرمان', 'گزک', 21),
        (1856, 'کرمان', 'تهرود', 21),
        (1857, 'کرمان', 'میرابادارجمند', 21),
        (1858, 'کرمان', 'داوران', 21),
        (1859, 'کرمان', 'خنامان', 21),
        (1860, 'کرمان', 'کبوترخان', 21),
        (1861, 'کرمان', 'هرمزاباد', 21),
        (1862, 'کرمان', 'گلشن-کرمان', 21),
        (1863, 'کرمان', 'جوادیه الهیه نوق', 21),
        (1864, 'کرمان', 'محمدابادبرفه', 21),
        (1865, 'کرمان', 'خبر', 21),
        (1866, 'کرمان', 'کمسرخ', 21),
        (1867, 'کرمان', 'دشت خاک', 21),
        (1868, 'کرمان', 'حتکن', 21),
        (1869, 'کرمان', 'جرجافک', 21),
        (1870, 'کرمان', 'شعبجره', 21),
        (1871, 'کرمان', 'سیریز', 21),
        (1872, 'کرمان', 'جور', 21),
        (1873, 'کرمان', 'هوتک', 21),
        (1874, 'کرمان', 'حرجند', 21),
        (1875, 'کرمان', 'ملک اباد', 21),
        (1876, 'کرمان', 'عماداباد', 21),
        (1877, 'کرمان', 'قلعه عسکر', 21),
        (1878, 'کرمان', 'مومن اباد-کرمان', 21),
        (1879, 'کرمان', 'چناربرین', 21),
        (1880, 'کرمان', 'کمال اباد', 21),
        (1881, 'کرمان', 'امیراباد', 21),
        (1882, 'کرمان', 'پتکان', 21),
        (1883, 'کرمان', 'رضی ابادبالا', 21),
        (1884, 'کرمان', 'میجان علیا', 21),
        (1885, 'کرمان', 'حسین ابادجدید', 21),
        (1886, 'کرمان', 'سرخ قلعه', 21),
        (1887, 'کرمان', 'خیراباد-کرمان', 21),
        (1888, 'کرمانشاه', 'حمیل', 22),
        (1889, 'کرمانشاه', 'اسلام آباد غرب', 22),
        (1890, 'کرمانشاه', 'بانوره', 22),
        (1891, 'کرمانشاه', 'باینگان', 22),
        (1892, 'کرمانشاه', 'پاوه', 22),
        (1893, 'کرمانشاه', 'نودشه', 22),
        (1894, 'کرمانشاه', 'نوسود', 22),
        (1895, 'کرمانشاه', 'ازگله', 22),
        (1896, 'کرمانشاه', 'تازه آباد', 22),
        (1897, 'کرمانشاه', 'جوانرود', 22),
        (1898, 'کرمانشاه', 'گهواره', 22),
        (1899, 'کرمانشاه', 'ریجاب', 22),
        (1900, 'کرمانشاه', 'کرند غرب', 22),
        (1901, 'کرمانشاه', 'شاهو', 22),
        (1902, 'کرمانشاه', 'روانسر', 22),
        (1903, 'کرمانشاه', 'سر پل ذهاب', 22),
        (1904, 'کرمانشاه', 'سنقر', 22),
        (1905, 'کرمانشاه', 'سطر', 22),
        (1906, 'کرمانشاه', 'میان راهان', 22),
        (1907, 'کرمانشاه', 'صحنه', 22),
        (1908, 'کرمانشاه', 'سومار', 22),
        (1909, 'کرمانشاه', 'قصر شیرین', 22),
        (1910, 'کرمانشاه', 'سرمست', 22),
        (1911, 'کرمانشاه', 'گیلانغرب', 22),
        (1912, 'کرمانشاه', 'بیستون', 22),
        (1913, 'کرمانشاه', 'هرسین', 22),
        (1914, 'کرمانشاه', 'هلشی', 22),
        (1915, 'کرمانشاه', 'رباط', 22),
        (1916, 'کرمانشاه', 'کرمانشاه', 22),
        (1917, 'کرمانشاه', 'کوزران', 22),
        (1918, 'کرمانشاه', 'گودین', 22),
        (1919, 'کرمانشاه', 'کنگاور', 22),
        (1920, 'کرمانشاه', 'هفت اشیان', 22),
        (1921, 'کرمانشاه', 'دوردشت', 22),
        (1922, 'کرمانشاه', 'سنقراباد', 22),
        (1923, 'کرمانشاه', 'جعفراباد-کرمانشاه', 22),
        (1924, 'کرمانشاه', 'مرزبانی', 22),
        (1925, 'کرمانشاه', 'فش', 22),
        (1926, 'کرمانشاه', 'فرامان', 22),
        (1927, 'کرمانشاه', 'سلطان اباد-کرمانشاه', 22),
        (1928, 'کرمانشاه', 'قزوینه', 22),
        (1929, 'کرمانشاه', 'دهلقین', 22),
        (1930, 'کرمانشاه', 'درکه', 22),
        (1931, 'کرمانشاه', 'باوله', 22),
        (1932, 'کرمانشاه', 'گردکانه علیا', 22),
        (1933, 'کرمانشاه', 'اگاه علیا', 22),
        (1934, 'کرمانشاه', 'کیوه نان', 22),
        (1935, 'کرمانشاه', 'کرکسار', 22),
        (1936, 'کرمانشاه', 'کندوله', 22),
        (1937, 'کرمانشاه', 'زاوله علیا', 22),
        (1938, 'کرمانشاه', 'قلعه شیان', 22),
        (1939, 'کرمانشاه', 'حسن اباد-کرمانشاه', 22),
        (1940, 'کرمانشاه', 'سراب ذهاب', 22),
        (1941, 'کرمانشاه', 'ترک ویس', 22),
        (1942, 'کرمانشاه', 'نساردیره', 22),
        (1943, 'کرمانشاه', 'تپه رش', 22),
        (1944, 'کرمانشاه', 'خسروی', 22),
        (1945, 'کرمانشاه', 'قیلان', 22),
        (1946, 'کرمانشاه', 'دولت اباد-کرمانشاه', 22),
        (1947, 'کرمانشاه', 'میراباد-کرمانشاه', 22),
        (1948, 'کخگلویه و بویراحمد', 'باشت', 23),
        (1949, 'کخگلویه و بویراحمد', 'لیکک', 23),
        (1950, 'کخگلویه و بویراحمد', 'گراب سفلی', 23),
        (1951, 'کخگلویه و بویراحمد', 'مارگون', 23),
        (1952, 'کخگلویه و بویراحمد', 'مادوان', 23),
        (1953, 'کخگلویه و بویراحمد', 'یاسوج', 23),
        (1954, 'کخگلویه و بویراحمد', 'چیتاب', 23),
        (1955, 'کخگلویه و بویراحمد', 'سرفاریاب', 23),
        (1956, 'کخگلویه و بویراحمد', 'چرام', 23),
        (1957, 'کخگلویه و بویراحمد', 'پاتاوه', 23),
        (1958, 'کخگلویه و بویراحمد', 'سی سخت', 23),
        (1959, 'کخگلویه و بویراحمد', 'دوگنبدان', 23),
        (1960, 'کخگلویه و بویراحمد', 'لنده', 23),
        (1961, 'کخگلویه و بویراحمد', 'قلعه رئیسی', 23),
        (1962, 'کخگلویه و بویراحمد', 'دیشموک', 23),
        (1963, 'کخگلویه و بویراحمد', 'دهدشت', 23),
        (1964, 'کخگلویه و بویراحمد', 'سوق', 23),
        (1965, 'کخگلویه و بویراحمد', 'قلعه رییسی', 23),
        (1966, 'کخگلویه و بویراحمد', 'قلعه دختر', 23),
        (1967, 'کخگلویه و بویراحمد', 'باباکلان', 23),
        (1968, 'کخگلویه و بویراحمد', 'مظفراباد', 23),
        (1969, 'کخگلویه و بویراحمد', 'دیل', 23),
        (1970, 'کخگلویه و بویراحمد', 'شاه بهرام', 23),
        (1971, 'کخگلویه و بویراحمد', 'چاه تلخاب علیا', 23),
        (1972, 'کخگلویه و بویراحمد', 'سربیشه-کهگیلویه و بویراحمد', 23),
        (1973, 'کخگلویه و بویراحمد', 'میمند-کهگیلویه و بویراحمد', 23),
        (1974, 'گلستان', 'نوده خاندوز', 24),
        (1975, 'گلستان', 'آزاد شهر', 24),
        (1976, 'گلستان', 'نگین شهر', 24),
        (1977, 'گلستان', 'آق قلا', 24),
        (1978, 'گلستان', 'انبار آلوم', 24),
        (1979, 'گلستان', 'بندر گز', 24),
        (1980, 'گلستان', 'نوکنده', 24),
        (1981, 'گلستان', 'بندر ترکمن', 24),
        (1982, 'گلستان', 'خان ببین', 24),
        (1983, 'گلستان', 'تاتار علیا', 24),
        (1984, 'گلستان', 'دلند', 24),
        (1985, 'گلستان', 'رامیان', 24),
        (1986, 'گلستان', 'سنگدوین', 24),
        (1987, 'گلستان', 'علی آباد', 24),
        (1988, 'گلستان', 'مزرعه', 24),
        (1989, 'گلستان', 'فاضل آباد', 24),
        (1990, 'گلستان', 'گالیکش', 24),
        (1991, 'گلستان', 'سرخنکلاته', 24),
        (1992, 'گلستان', 'جلین', 24),
        (1993, 'گلستان', 'گرگان', 24),
        (1994, 'گلستان', 'سیمین شهر', 24),
        (1995, 'گلستان', 'گمیش تپه', 24),
        (1996, 'گلستان', 'اینچه برون', 24),
        (1997, 'گلستان', 'گنبدکاووس', 24),
        (1998, 'گلستان', 'مراوه تپه', 24),
        (1999, 'گلستان', 'مینودشت', 24),
        (2000, 'گلستان', 'کرد کوی', 24),
        (2001, 'گلستان', 'فراغی', 24),
        (2002, 'گلستان', 'کلاله', 24),
        (2003, 'گلستان', 'تقی اباد-گلستان', 24),
        (2004, 'گلستان', 'حاجیکلاته', 24),
        (2005, 'گلستان', 'کرند', 24),
        (2006, 'گلستان', 'عزیزاباد-گلستان', 24),
        (2007, 'گلستان', 'قرق', 24),
        (2008, 'گیلان', 'لوندویل', 25),
        (2009, 'گیلان', 'آستارا', 25),
        (2010, 'گیلان', 'آستانه اشرفیه', 25),
        (2011, 'گیلان', 'کیاشهر', 25),
        (2012, 'گیلان', 'رانکوه', 25),
        (2013, 'گیلان', 'املش', 25),
        (2014, 'گیلان', 'بندر انزلی', 25),
        (2015, 'گیلان', 'خشکبیجار', 25),
        (2016, 'گیلان', 'خمام', 25),
        (2017, 'گیلان', 'آستانه چهارده', 25),
        (2018, 'گیلان', 'لشت نشاء', 25),
        (2019, 'گیلان', 'رشت', 25),
        (2020, 'گیلان', 'لولمان', 25),
        (2021, 'گیلان', 'کوچصفهان', 25),
        (2022, 'گیلان', 'پره سر', 25),
        (2023, 'گیلان', 'رضوانشهر', 25),
        (2024, 'گیلان', 'بره سر', 25),
        (2025, 'گیلان', 'توتکابن', 25),
        (2026, 'گیلان', 'جیرنده', 25),
        (2027, 'گیلان', 'رستم آباد', 25),
        (2028, 'گیلان', 'رودبار', 25),
        (2029, 'گیلان', 'لوشان', 25),
        (2030, 'گیلان', 'منجیل', 25),
        (2031, 'گیلان', 'چابکسر', 25),
        (2032, 'گیلان', 'رحیم آباد', 25),
        (2033, 'گیلان', 'رودسر', 25),
        (2034, 'گیلان', 'واجارگاه', 25),
        (2035, 'گیلان', 'کلاچای', 25),
        (2036, 'گیلان', 'دیلمان', 25),
        (2037, 'گیلان', 'سیاهکل', 25),
        (2038, 'گیلان', 'احمد سرگوراب', 25),
        (2039, 'گیلان', 'شفت', 25),
        (2040, 'گیلان', 'مرجقل', 25),
        (2041, 'گیلان', 'صومعه سرا', 25),
        (2042, 'گیلان', 'فومن گوراب پس', 25),
        (2043, 'گیلان', 'اسالم', 25),
        (2044, 'گیلان', 'چوبر', 25),
        (2045, 'گیلان', 'حویق', 25),
        (2046, 'گیلان', 'هشتپر', 25),
        (2047, 'گیلان', 'لیسار', 25),
        (2048, 'گیلان', 'فومن ماکلوان', 25),
        (2049, 'گیلان', 'فومن', 25),
        (2050, 'گیلان', 'ماسوله', 25),
        (2051, 'گیلان', 'لاهیجان', 25),
        (2052, 'گیلان', 'لنگرود', 25),
        (2053, 'گیلان', 'شلمان', 25),
        (2054, 'گیلان', 'بازار جمعه', 25),
        (2055, 'گیلان', 'ماسال', 25),
        (2056, 'گیلان', 'جیرهنده', 25),
        (2057, 'گیلان', 'لیچارکی حسن رود', 25),
        (2058, 'گیلان', 'رشت سراوان', 25),
        (2059, 'گیلان', 'بلسبنه', 25),
        (2060, 'گیلان', 'چاپارخانه', 25),
        (2061, 'گیلان', 'جیرکویه', 25),
        (2062, 'گیلان', 'ملاسرا', 25),
        (2063, 'گیلان', 'گشت-گیلان', 25),
        (2064, 'گیلان', 'آستانه تجن گوکه', 25),
        (2065, 'گیلان', 'آستانه پینچاه', 25),
        (2066, 'گیلان', 'مرکیه', 25),
        (2067, 'گیلان', 'فومن کمادول', 25),
        (2068, 'گیلان', 'نوخاله اکبری', 25),
        (2069, 'گیلان', 'شیله وشت', 25),
        (2070, 'گیلان', 'جوکندان بزرگ', 25),
        (2071, 'گیلان', 'بازارخطبه سرا', 25),
        (2072, 'گیلان', 'پلاسی', 25),
        (2073, 'گیلان', 'پلنگ پاره', 25),
        (2074, 'گیلان', 'فومن شالتوک', 25),
        (2075, 'گیلان', 'ویرمونی', 25),
        (2076, 'گیلان', 'سیبلی', 25),
        (2077, 'گیلان', 'مشند', 25),
        (2078, 'گیلان', 'کوته کومه', 25),
        (2079, 'گیلان', 'حیران', 25),
        (2080, 'گیلان', 'پایین محله پاشاکی', 25),
        (2081, 'گیلان', 'گرماور', 25),
        (2082, 'گیلان', 'لیش', 25),
        (2083, 'گیلان', 'بارکوسرا', 25),
        (2084, 'گیلان', 'شیرین نسا', 25),
        (2085, 'گیلان', 'خرارود', 25),
        (2086, 'گیلان', 'لسکوکلایه', 25),
        (2087, 'گیلان', 'شیرکوه چهارده', 25),
        (2088, 'گیلان', 'دهشال', 25),
        (2089, 'گیلان', 'دستک', 25),
        (2090, 'گیلان', 'پرگاپشت مهدی خانی', 25),
        (2091, 'گیلان', 'بیورزین', 25),
        (2092, 'گیلان', 'ویشان', 25),
        (2093, 'گیلان', 'کلیشم', 25),
        (2094, 'گیلان', 'علی اباد-گیلان', 25),
        (2095, 'گیلان', 'کلشتر', 25),
        (2096, 'گیلان', 'اسکولک', 25),
        (2097, 'گیلان', 'کوکنه', 25),
        (2098, 'گیلان', 'سلوش', 25),
        (2099, 'گیلان', 'دیوشل', 25),
        (2100, 'گیلان', 'پروش پایین', 25),
        (2101, 'گیلان', 'حسن سرا', 25),
        (2102, 'گیلان', 'طول لات', 25),
        (2103, 'گیلان', 'جنگ سرا', 25),
        (2104, 'گیلان', 'بلترک', 25),
        (2105, 'گیلان', 'کجید', 25),
        (2106, 'گیلان', 'گرمابدشت', 25),
        (2107, 'گیلان', 'شوییل', 25),
        (2108, 'گیلان', 'پونل', 25),
        (2109, 'گیلان', 'ابکنار', 25),
        (2110, 'گیلان', 'رشت فخب', 25),
        (2111, 'گیلان', 'رشت پیر بازار', 25),
        (2112, 'گیلان', 'رشت امام زاده هاشم', 25),
        (2113, 'گیلان', 'شهر صنعتی', 25),
        (2114, 'گیلان', 'خمام چوکام', 25),
        (2115, 'گیلان', 'خمام مرزدشت', 25),
        (2116, 'گیلان', 'انزلی زیباکنار', 25),
        (2117, 'گیلان', 'فومن لولمان', 25),
        (2118, 'گیلان', 'بندر انزلی_آبکنار', 25),
        (2119, 'گیلان', 'بندر انزلی_تربه گوده', 25),
        (2120, 'گیلان', 'بندر انزلی_جفرود', 25),
        (2121, 'گیلان', 'بندر انزلی_حسن رود', 25),
        (2122, 'گیلان', 'بندر انزلی_علی آباد', 25),
        (2123, 'گیلان', 'بندر انزلی_سنگاچین', 25),
        (2124, 'گیلان', 'بندرانزلی_شانگهای پرده', 25),
        (2125, 'گیلان', 'بندر انزلی_کپورچال', 25),
        (2126, 'گیلان', 'بندر انزلی _ منطقه آزاد', 25),
        (2127, 'گیلان', 'بندر انزلی_شهر صنعتی', 25),
        (2128, 'گیلان', 'خمام خواچکین', 25),
        (2129, 'گیلان', 'خمام دافچاه', 25),
        (2130, 'گیلان', 'خمام شیجان', 25),
        (2131, 'گیلان', 'خمام فشتکه', 25),
        (2132, 'گیلان', 'خمام لله کاه', 25),
        (2133, 'گیلان', 'خمام خشکبیجار', 25),
        (2134, 'گیلان', 'رشت رجب آباد', 25),
        (2135, 'گیلان', 'رشت پیله ملا', 25),
        (2136, 'گیلان', 'رشت تخته پل', 25),
        (2137, 'گیلان', 'رشت جیرده', 25),
        (2138, 'گیلان', 'رشت پیرده', 25),
        (2139, 'گیلان', 'رشت سنگر', 25),
        (2140, 'گیلان', 'رشت شهر صنعتی لاکان', 25),
        (2141, 'گیلان', 'رشت فلکده', 25),
        (2142, 'گیلان', 'رشت کفترود', 25),
        (2143, 'گیلان', 'رشت کماکل', 25),
        (2144, 'گیلان', 'رشت لاکان', 25),
        (2145, 'گیلان', 'رشت مبارک آباد', 25),
        (2146, 'گیلان', 'فومن قلعه رودخان', 25),
        (2147, 'گیلان', 'فومن دهستان گشت', 25),
        (2148, 'گیلان', 'فومن الیان', 25),
        (2149, 'گیلان', 'فومن خشکنودهیان', 25),
        (2150, 'گیلان', 'فومن زیده', 25),
        (2151, 'گیلان', 'صومعه سرا دوگور', 25),
        (2152, 'گیلان', 'صومعه سرا چوبه', 25),
        (2153, 'گیلان', 'صومعه سرا خراط محله', 25),
        (2154, 'گیلان', 'صومعه سرا هند خاله', 25),
        (2155, 'گیلان', 'صومعه سرا صوفیانده', 25),
        (2156, 'گیلان', 'فومن سیاه پیران', 25),
        (2157, 'گیلان', 'صومعه سرا شیخ محله', 25),
        (2158, 'گیلان', 'فومن شالکوه', 25),
        (2159, 'گیلان', 'صومعه سرا ضیابر', 25),
        (2160, 'گیلان', 'صومعه سرا  طاهر گوراب', 25),
        (2161, 'گیلان', 'صومعه سرا  فشخام', 25),
        (2162, 'گیلان', 'صومعه سرا قصاب سرا', 25),
        (2163, 'گیلان', 'صومعه سرا گوراب زرمیخ', 25),
        (2164, 'گیلان', 'صومعه سرا لیفشاگرد', 25),
        (2165, 'گیلان', 'صومعه سرا لیموده', 25),
        (2166, 'گیلان', 'صومعه سرا نفوت', 25),
        (2167, 'گیلان', 'صومعه سرا واقع دشت', 25),
        (2168, 'گیلان', 'کوچصفهان حسن آباد', 25),
        (2169, 'گیلان', 'کوچصفهان سده', 25),
        (2170, 'گیلان', 'کوچصفهان سنگر', 25),
        (2171, 'گیلان', 'کوچصفهان لاله دشت', 25),
        (2172, 'گیلان', 'لنگرود اطاقور', 25),
        (2173, 'گیلان', 'لنگرود پرشکوه', 25),
        (2174, 'گیلان', 'لنگرود پیر پشته', 25),
        (2175, 'گیلان', 'لنگرود چاف و چمخاله', 25),
        (2176, 'گیلان', 'لنگرود خراط محله', 25),
        (2177, 'گیلان', 'لنگرود دریاسر', 25),
        (2178, 'گیلان', 'لنگرود سالکویه', 25),
        (2179, 'گیلان', 'لنگرود کومله', 25),
        (2180, 'گیلان', 'لنگرود لوکلایه', 25),
        (2181, 'گیلان', 'لنگرود فتیده', 25),
        (2182, 'گیلان', 'لنگرود دهستان گل سفید', 25),
        (2183, 'گیلان', 'لنگرود شلمان', 25),
        (2184, 'گیلان', 'لنگرود یعقوبیه', 25),
        (2185, 'گیلان', 'لاهیجان آهندان', 25),
        (2186, 'گیلان', 'لاهیجان بازکیا گوراب', 25),
        (2187, 'گیلان', 'لاهیجان بیجار بنه', 25),
        (2188, 'گیلان', 'لاهیجان جواهر پشته', 25),
        (2189, 'گیلان', 'لاهیجان چفل', 25),
        (2190, 'گیلان', 'لاهیجان رودبنه', 25),
        (2191, 'گیلان', 'لاهیجان سیاهگوراب', 25),
        (2192, 'گیلان', 'لاهیجان کوچکده', 25),
        (2193, 'گیلان', 'لاهیجان کوشال', 25),
        (2194, 'گیلان', 'لاهیجان لفمجان', 25),
        (2195, 'گیلان', 'لاهیجان نخجیر کلایه', 25),
        (2196, 'گیلان', 'لاهیجان نوبیجار', 25),
        (2197, 'گیلان', 'لاهیجان شهر صنعتی', 25),
        (2198, 'گیلان', 'فومن فوشه', 25),
        (2199, 'گیلان', 'فومن نوگوراب', 25),
        (2200, 'گیلان', 'آستانه تمچال', 25),
        (2201, 'گیلان', 'آستانه چورکوچان', 25),
        (2202, 'گیلان', 'آستانه دهسر', 25),
        (2203, 'گیلان', 'آستانه سالک ده', 25),
        (2204, 'گیلان', 'آستانه سوخته کوه', 25),
        (2205, 'گیلان', 'آستانه صفرا بسته', 25),
        (2206, 'گیلان', 'آستانه کشل', 25),
        (2207, 'گیلان', 'آستانه کیسم', 25),
        (2208, 'گیلان', 'لاهیجان لیالستان', 25),
        (2209, 'گیلان', 'لاهیجان پاشاکی', 25),
        (2210, 'گیلان', 'کوچصفهان جوربیجارکل', 25),
        (2211, 'گیلان', 'انزلی طالب آباد', 25),
        (2212, 'لرستان', 'مومن آباد', 26),
        (2213, 'لرستان', 'ازنا', 26),
        (2214, 'لرستان', 'شول آباد', 26),
        (2215, 'لرستان', 'الیگودرز', 26),
        (2216, 'لرستان', 'اشترینان', 26),
        (2217, 'لرستان', 'بروجرد', 26),
        (2218, 'لرستان', 'پلدختر', 26),
        (2219, 'لرستان', 'معمولان', 26),
        (2220, 'لرستان', 'بیرانشهر', 26),
        (2221, 'لرستان', 'سپید دشت', 26),
        (2222, 'لرستان', 'زاغه', 26),
        (2223, 'لرستان', 'خرم آباد', 26),
        (2224, 'لرستان', 'نورآباد', 26),
        (2225, 'لرستان', 'هفت چشمه', 26),
        (2226, 'لرستان', 'سراب دوره', 26),
        (2227, 'لرستان', 'ویسیان', 26),
        (2228, 'لرستان', 'چالانچولان', 26),
        (2229, 'لرستان', 'دورود', 26),
        (2230, 'لرستان', 'چقابل', 26),
        (2231, 'لرستان', 'فیروزآباد', 26),
        (2232, 'لرستان', 'الشتر', 26),
        (2233, 'لرستان', 'درب گنبد', 26),
        (2234, 'لرستان', 'گراب', 26),
        (2235, 'لرستان', 'کوهدشت', 26),
        (2236, 'لرستان', 'کوهنانی', 26),
        (2237, 'لرستان', 'ماسور', 26),
        (2238, 'لرستان', 'بیرانوند', 26),
        (2239, 'لرستان', 'برخوردار', 26),
        (2240, 'لرستان', 'فرهاداباد', 26),
        (2241, 'لرستان', 'دم باغ', 26),
        (2242, 'لرستان', 'کهریزوروشت', 26),
        (2243, 'لرستان', 'چشمه کیزاب علیا', 26),
        (2244, 'لرستان', 'تقی اباد-لرستان', 26),
        (2245, 'لرستان', 'خوشناموند', 26),
        (2246, 'لرستان', 'اشتره گل گل', 26),
        (2247, 'لرستان', 'سوری', 26),
        (2248, 'لرستان', 'کونانی', 26),
        (2249, 'لرستان', 'پاعلم (پل تنگ )', 26),
        (2250, 'لرستان', 'واشیان نصیرتپه', 26),
        (2251, 'لرستان', 'چمشک زیرتنگ', 26),
        (2252, 'لرستان', 'افرینه', 26),
        (2253, 'لرستان', 'میان تاگان', 26),
        (2254, 'لرستان', 'پل شوراب پایین', 26),
        (2255, 'لرستان', 'شاهپوراباد', 26),
        (2256, 'لرستان', 'چمن سلطان', 26),
        (2257, 'لرستان', 'کیزاندره', 26),
        (2258, 'لرستان', 'قلعه بزنوید', 26),
        (2259, 'لرستان', 'حیه', 26),
        (2260, 'لرستان', 'مرگ سر', 26),
        (2261, 'لرستان', 'رازان', 26),
        (2262, 'لرستان', 'سیاه گوشی (پل هرو)', 26),
        (2263, 'لرستان', 'چاه ذوالفقار', 26),
        (2264, 'لرستان', 'چم پلک', 26),
        (2265, 'لرستان', 'ژان', 26),
        (2266, 'لرستان', 'کاغه', 26),
        (2267, 'لرستان', 'چم سنگر', 26),
        (2268, 'لرستان', 'ایستگاه تنگ هفت', 26),
        (2269, 'لرستان', 'مکینه حکومتی', 26),
        (2270, 'لرستان', 'سراب سیاهپوش', 26),
        (2271, 'لرستان', 'ده رحم', 26),
        (2272, 'لرستان', 'بندیزه', 26),
        (2273, 'لرستان', 'دره گرگ', 26),
        (2274, 'مازندران', 'امامزاده عبدالله', 27),
        (2275, 'مازندران', 'دابودشت', 27),
        (2276, 'مازندران', 'رینه', 27),
        (2277, 'مازندران', 'گزنک', 27),
        (2278, 'مازندران', 'آمل', 27),
        (2279, 'مازندران', 'مرزیکلا', 27),
        (2280, 'مازندران', 'گلوگاه', 27),
        (2281, 'مازندران', 'خوش رودپی', 27),
        (2282, 'مازندران', 'گتاب', 27),
        (2283, 'مازندران', 'زرگر محله', 27),
        (2284, 'مازندران', 'امیرکلا', 27),
        (2285, 'مازندران', 'بابل', 27),
        (2286, 'مازندران', 'بهنمیر', 27),
        (2287, 'مازندران', 'هادی شهر', 27),
        (2288, 'مازندران', 'بابلسر', 27),
        (2289, 'مازندران', 'بهشهر', 27),
        (2290, 'مازندران', 'خلیل شهر', 27),
        (2291, 'مازندران', 'رستمکلا', 27),
        (2292, 'مازندران', 'خرم آباد', 27),
        (2293, 'مازندران', 'تنکابن', 27),
        (2294, 'مازندران', 'شیرود', 27),
        (2295, 'مازندران', 'نشتارود', 27),
        (2296, 'مازندران', 'کوهی خیل', 27),
        (2297, 'مازندران', 'جویبار', 27),
        (2298, 'مازندران', 'چالوس', 27),
        (2299, 'مازندران', 'هچیرود', 27),
        (2300, 'مازندران', 'رامسر', 27),
        (2301, 'مازندران', 'کتالم و سادات شهر', 27),
        (2302, 'مازندران', 'کیاسر', 27),
        (2303, 'مازندران', 'فریم', 27),
        (2304, 'مازندران', 'ساری', 27),
        (2305, 'مازندران', 'پایین هولار', 27),
        (2306, 'مازندران', 'آلاشت', 27),
        (2307, 'مازندران', 'پل سفید', 27),
        (2308, 'مازندران', 'زیرآب', 27),
        (2309, 'مازندران', 'شیرگاه', 27),
        (2310, 'مازندران', 'کیاکلا', 27),
        (2311, 'مازندران', 'سلمان شهر', 27),
        (2312, 'مازندران', 'کلارآباد', 27),
        (2313, 'مازندران', 'عباس آباد', 27),
        (2314, 'مازندران', 'فریدونکنار', 27),
        (2315, 'مازندران', 'ارطه', 27),
        (2316, 'مازندران', 'قائم شهر', 27),
        (2317, 'مازندران', 'گلوگاه', 27),
        (2318, 'مازندران', 'سرخرود', 27),
        (2319, 'مازندران', 'محمودآباد', 27),
        (2320, 'مازندران', 'سورک', 27),
        (2321, 'مازندران', 'بلده', 27),
        (2322, 'مازندران', 'چمستان', 27),
        (2323, 'مازندران', 'ایزد شهر', 27),
        (2324, 'مازندران', 'رویان', 27),
        (2325, 'مازندران', 'نور', 27),
        (2326, 'مازندران', 'نوشهر', 27),
        (2327, 'مازندران', 'پول', 27),
        (2328, 'مازندران', 'کجور', 27),
        (2329, 'مازندران', 'نکا', 27),
        (2330, 'مازندران', 'مرزن آباد', 27),
        (2331, 'مازندران', 'کلاردشت', 27),
        (2332, 'مازندران', 'میان دره', 27),
        (2333, 'مازندران', 'بندپی', 27),
        (2334, 'مازندران', 'معلم کلا', 27),
        (2335, 'مازندران', 'وسطی کلا', 27),
        (2336, 'مازندران', 'سوا', 27),
        (2337, 'مازندران', 'باییجان', 27),
        (2338, 'مازندران', 'بنفشه ده', 27),
        (2339, 'مازندران', 'رییس کلا', 27),
        (2340, 'مازندران', 'اوز-مازندران', 27),
        (2341, 'مازندران', 'تاکر', 27),
        (2342, 'مازندران', 'گلندرود', 27),
        (2343, 'مازندران', 'چلندر', 27),
        (2344, 'مازندران', 'صلاح الدین کلا', 27),
        (2345, 'مازندران', 'نارنج بن', 27),
        (2346, 'مازندران', 'لشکنار', 27),
        (2347, 'مازندران', 'هیچرود', 27),
        (2348, 'مازندران', 'کردیچال', 27),
        (2349, 'مازندران', 'کلنو', 27),
        (2350, 'مازندران', 'دلیر', 27),
        (2351, 'مازندران', 'سیاه بیشه', 27),
        (2352, 'مازندران', 'سرلنگا', 27),
        (2353, 'مازندران', 'کترا', 27),
        (2354, 'مازندران', 'گلعلی اباد', 27),
        (2355, 'مازندران', 'میان کوه سادات', 27),
        (2356, 'مازندران', 'مران سه هزار', 27),
        (2357, 'مازندران', 'قلعه گردن', 27),
        (2358, 'مازندران', 'سلیمان اباد', 27),
        (2359, 'مازندران', 'کشکو', 27),
        (2360, 'مازندران', 'لاک تراشان', 27),
        (2361, 'مازندران', 'سادات محله', 27),
        (2362, 'مازندران', 'اغوزکتی', 27),
        (2363, 'مازندران', 'جواهرده', 27),
        (2364, 'مازندران', 'جنت رودبار', 27),
        (2365, 'مازندران', 'تمل', 27),
        (2366, 'مازندران', 'اهنگرکلا', 27),
        (2367, 'مازندران', 'گاوانکلا', 27),
        (2368, 'مازندران', 'شورکش', 27),
        (2369, 'مازندران', 'اینج دان', 27),
        (2370, 'مازندران', 'عرب خیل', 27),
        (2371, 'مازندران', 'کاسگرمحله', 27),
        (2372, 'مازندران', 'کله بست', 27),
        (2373, 'مازندران', 'بیشه سر', 27),
        (2374, 'مازندران', 'درازکش', 27),
        (2375, 'مازندران', 'گردرودبار', 27),
        (2376, 'مازندران', 'شهیداباد', 27),
        (2377, 'مازندران', 'بالاجنیدلاک پل', 27),
        (2378, 'مازندران', 'خطیرکلا', 27),
        (2379, 'مازندران', 'حاجی کلاصنم', 27),
        (2380, 'مازندران', 'واسکس', 27),
        (2381, 'مازندران', 'ریکنده', 27),
        (2382, 'مازندران', 'بالادسته رکن کنار', 27),
        (2383, 'مازندران', 'بیزکی', 27),
        (2384, 'مازندران', 'سنگتاب', 27),
        (2385, 'مازندران', 'رکابدارکلا', 27),
        (2386, 'مازندران', 'شیرکلا', 27),
        (2387, 'مازندران', 'لفور (لفورک )', 27),
        (2388, 'مازندران', 'اتو', 27),
        (2389, 'مازندران', 'پالند', 27),
        (2390, 'مازندران', 'چرات', 27),
        (2391, 'مازندران', 'ده میان', 27),
        (2392, 'مازندران', 'خشک دره', 27),
        (2393, 'مازندران', 'امافت', 27),
        (2394, 'مازندران', 'بالادواب', 27),
        (2395, 'مازندران', 'ورسک', 27),
        (2396, 'مازندران', 'کتی لته', 27),
        (2397, 'مازندران', 'اروست', 27),
        (2398, 'مازندران', 'سنگده', 27),
        (2399, 'مازندران', 'قادیکلا', 27),
        (2400, 'مازندران', 'تاکام', 27),
        (2401, 'مازندران', 'بالاهولار', 27),
        (2402, 'مازندران', 'اسبوکلا', 27),
        (2403, 'مازندران', 'اسلام اباد-مازندران', 27),
        (2404, 'مازندران', 'شهرک صنعتی گهرباران', 27),
        (2405, 'مازندران', 'فرح اباد (خزراباد)', 27),
        (2406, 'مازندران', 'دارابکلا', 27),
        (2407, 'مازندران', 'ماچک پشت', 27),
        (2408, 'مازندران', 'خورشید (امامیه )', 27),
        (2409, 'مازندران', 'زاغمرز', 27),
        (2410, 'مازندران', 'چلمردی', 27),
        (2411, 'مازندران', 'پایین زرندین', 27),
        (2412, 'مازندران', 'بادابسر', 27),
        (2413, 'مازندران', 'تیرتاش', 27),
        (2414, 'مازندران', 'دامداری حسن ابوطالبی', 27),
        (2415, 'مازندران', 'بیشه بنه', 27),
        (2416, 'مازندران', 'سفیدچاه', 27),
        (2417, 'مازندران', 'دامداری حاج عزیزمجریان', 27),
        (2418, 'مرکزی', 'آشتیان', 28),
        (2419, 'مرکزی', 'ساروق', 28),
        (2420, 'مرکزی', 'اراک', 28),
        (2421, 'مرکزی', 'داود آباد', 28),
        (2422, 'مرکزی', 'کارچان', 28),
        (2423, 'مرکزی', 'تفرش', 28),
        (2424, 'مرکزی', 'خمین', 28),
        (2425, 'مرکزی', 'قورچی باشی', 28),
        (2426, 'مرکزی', 'جاورسیان', 28),
        (2427, 'مرکزی', 'خنداب', 28),
        (2428, 'مرکزی', 'دلیجان', 28),
        (2429, 'مرکزی', 'نراق', 28),
        (2430, 'مرکزی', 'رازقان', 28),
        (2431, 'مرکزی', 'پرندک', 28),
        (2432, 'مرکزی', 'خشکرود', 28),
        (2433, 'مرکزی', 'زاویه', 28),
        (2434, 'مرکزی', 'مامونیه', 28),
        (2435, 'مرکزی', 'آوه', 28),
        (2436, 'مرکزی', 'ساوه', 28),
        (2437, 'مرکزی', 'غرق آباد', 28),
        (2438, 'مرکزی', 'نوبران', 28),
        (2439, 'مرکزی', 'توره', 28),
        (2440, 'مرکزی', 'مهاجران', 28),
        (2441, 'مرکزی', 'هندودر', 28),
        (2442, 'مرکزی', 'شهباز', 28),
        (2443, 'مرکزی', 'آستانه', 28),
        (2444, 'مرکزی', 'شازند', 28),
        (2445, 'مرکزی', 'خنجین', 28),
        (2446, 'مرکزی', 'فرمهین', 28),
        (2447, 'مرکزی', 'محلات', 28),
        (2448, 'مرکزی', 'نیمور', 28),
        (2449, 'مرکزی', 'کمیجان', 28),
        (2450, 'مرکزی', 'میلاجرد', 28),
        (2451, 'مرکزی', 'کرهرود', 28),
        (2452, 'مرکزی', 'رباطمراد', 28),
        (2453, 'مرکزی', 'سلطان اباد-مرکزی', 28),
        (2454, 'مرکزی', 'اصفهانک', 28),
        (2455, 'مرکزی', 'حسین اباد-مرکزی', 28),
        (2456, 'مرکزی', 'حکیم اباد', 28),
        (2457, 'مرکزی', 'یحیی اباد-مرکزی', 28),
        (2458, 'مرکزی', 'صدراباد', 28),
        (2459, 'مرکزی', 'نخجیروان', 28),
        (2460, 'مرکزی', 'باقراباد', 28),
        (2461, 'مرکزی', 'بزیجان', 28),
        (2462, 'مرکزی', 'عیسی اباد', 28),
        (2463, 'مرکزی', 'خورهه', 28),
        (2464, 'مرکزی', 'ادشته', 28),
        (2465, 'مرکزی', 'استوه', 28),
        (2466, 'مرکزی', 'سنجان', 28),
        (2467, 'مرکزی', 'اناج', 28),
        (2468, 'مرکزی', 'وفس', 28),
        (2469, 'مرکزی', 'خسروبیگ', 28),
        (2470, 'مرکزی', 'سمقاور', 28),
        (2471, 'مرکزی', 'هزاوه', 28),
        (2472, 'مرکزی', 'قدمگاه-مرکزی', 28),
        (2473, 'مرکزی', 'هفته', 28),
        (2474, 'مرکزی', 'لنجرود', 28),
        (2475, 'مرکزی', 'کزاز', 28),
        (2684, 'مرکزی', 'کتیران بالا', 28),
        (2685, 'مرکزی', 'نهرمیان', 28),
        (2686, 'مرکزی', 'سرسختی بالا', 28),
        (2687, 'مرکزی', 'لوزدرعلیا', 28),
        (2688, 'مرکزی', 'تواندشت علیا', 28),
        (2689, 'مرکزی', 'مالمیر', 28),
        (2690, 'مرکزی', 'چهارچریک', 28),
        (2691, 'مرکزی', 'چهارچشمه', 28),
        (2692, 'مرکزی', 'لکان', 28),
        (2693, 'مرکزی', 'ورچه', 28),
        (2694, 'مرکزی', 'فرفهان', 28),
        (2695, 'مرکزی', 'امامزاده ورچه', 28),
        (2696, 'مرکزی', 'رباطکفسان', 28),
        (2697, 'مرکزی', 'ریحان علیا', 28),
        (2698, 'مرکزی', 'جزنق', 28),
        (2699, 'مرکزی', 'خوراوند', 28),
        (2700, 'مرکزی', 'میشیجان علیا', 28),
        (2701, 'مرکزی', 'گلدشت-مرکزی', 28),
        (2702, 'مرکزی', 'دهنو-مرکزی', 28),
        (2703, 'مرکزی', 'یل اباد', 28),
        (2704, 'مرکزی', 'الویر', 28),
        (2705, 'مرکزی', 'دوزج', 28),
        (2706, 'مرکزی', 'علیشار', 28),
        (2707, 'مرکزی', 'بالقلو', 28),
        (2708, 'مرکزی', 'چمران-مرکزی', 28),
        (2709, 'مرکزی', 'قاقان', 28),
        (2710, 'مرکزی', 'سامان-مرکزی', 28),
        (2711, 'مرکزی', 'دخان', 28),
        (2712, 'مرکزی', 'مراغه-مرکزی', 28),
        (2713, 'مرکزی', 'شهراب-مرکزی', 28),
        (2714, 'مرکزی', 'زاغر', 28),
        (2715, 'مرکزی', 'کهک-مرکزی', 28),
        (2716, 'مرکزی', 'فشک', 28),
        (2717, 'مرکزی', 'اهنگران', 28),
        (2718, 'مرکزی', 'مزرعه نو', 28),
        (2719, 'مرکزی', 'صالح اباد', 28),
        (2720, 'مرکزی', 'سیاوشان', 28),
        (2721, 'مرکزی', 'اهو', 28),
        (2722, 'مرکزی', 'عقیل آباد', 28),
        (2723, 'هرمزگان', 'ابوموسی', 29),
        (2724, 'هرمزگان', 'جناح', 29),
        (2725, 'هرمزگان', 'بستک', 29),
        (2726, 'هرمزگان', 'کوخردهرنگ', 29),
        (2727, 'هرمزگان', 'گوهران', 29),
        (2728, 'هرمزگان', 'سردشت', 29),
        (2729, 'هرمزگان', 'تخت', 29),
        (2730, 'هرمزگان', 'فین', 29),
        (2731, 'هرمزگان', 'قلعه قاضی', 29),
        (2732, 'هرمزگان', 'بندرعباس', 29),
        (2733, 'هرمزگان', 'تازیان پائین', 29),
        (2734, 'هرمزگان', 'چارک', 29),
        (2735, 'هرمزگان', 'بندر لنگه', 29),
        (2736, 'هرمزگان', 'کنگ', 29),
        (2737, 'هرمزگان', 'لمزان', 29),
        (2738, 'هرمزگان', 'کیش', 29),
        (2739, 'هرمزگان', 'پارسیان', 29),
        (2740, 'هرمزگان', 'دشتی', 29),
        (2741, 'هرمزگان', 'کوشکنار', 29),
        (2742, 'هرمزگان', 'بندر جاسک', 29),
        (2743, 'هرمزگان', 'سرگز', 29),
        (2744, 'هرمزگان', 'فارغان', 29),
        (2745, 'هرمزگان', 'حاجی آباد', 29),
        (2746, 'هرمزگان', 'رویدر', 29),
        (2747, 'هرمزگان', 'خمیر', 29),
        (2748, 'هرمزگان', 'بیکاه', 29),
        (2749, 'هرمزگان', 'زیارتعلی', 29),
        (2750, 'هرمزگان', 'دهبارز', 29),
        (2751, 'هرمزگان', 'کوهستک', 29),
        (2752, 'هرمزگان', 'سیریک', 29),
        (2753, 'هرمزگان', 'گروک', 29),
        (2754, 'هرمزگان', 'سوزا', 29),
        (2755, 'هرمزگان', 'درگهان', 29),
        (2756, 'هرمزگان', 'قشم', 29),
        (2757, 'هرمزگان', 'هرمز', 29),
        (2758, 'هرمزگان', 'هشتبندی', 29),
        (2759, 'هرمزگان', 'سندرک', 29),
        (2760, 'هرمزگان', 'تیرور', 29),
        (2761, 'هرمزگان', 'میناب', 29),
        (2762, 'هرمزگان', 'پشته ایسین', 29),
        (2763, 'هرمزگان', 'پل شرقی', 29),
        (2764, 'هرمزگان', 'سیاهو', 29),
        (2765, 'هرمزگان', 'باغات', 29),
        (2766, 'هرمزگان', 'ابگرم خورگو', 29),
        (2767, 'هرمزگان', 'حسن لنگی پایین', 29),
        (2768, 'هرمزگان', 'گونمردی', 29),
        (2769, 'هرمزگان', 'گوهرت', 29),
        (2770, 'هرمزگان', 'جزیره لارک شهری', 29),
        (2771, 'هرمزگان', 'هنگام جدید', 29),
        (2772, 'هرمزگان', 'جزیره سیری', 29),
        (2773, 'هرمزگان', 'پدل', 29),
        (2774, 'هرمزگان', 'دژگان', 29),
        (2775, 'هرمزگان', 'دهنگ', 29),
        (2776, 'هرمزگان', 'کمشک', 29),
        (2777, 'هرمزگان', 'گزیر', 29),
        (2778, 'هرمزگان', 'بندرمغویه', 29),
        (2779, 'هرمزگان', 'جزیره لاوان', 29),
        (2780, 'هرمزگان', 'بندر', 29),
        (2781, 'هرمزگان', 'درپهن', 29),
        (2782, 'هرمزگان', 'کلورجکدان', 29),
        (2783, 'هرمزگان', 'جغین', 29),
        (2784, 'هرمزگان', 'ماشنگی', 29),
        (2785, 'هرمزگان', 'گوربند', 29),
        (2786, 'هرمزگان', 'تیاب', 29),
        (2787, 'هرمزگان', 'بندزرک', 29),
        (2788, 'همدان', 'آجین', 30),
        (2789, 'همدان', 'اسد آباد', 30),
        (2790, 'همدان', 'صالح آباد', 30),
        (2791, 'همدان', 'لالجین', 30),
        (2792, 'همدان', 'مهاجران', 30),
        (2793, 'همدان', 'بهار', 30),
        (2794, 'همدان', 'فرسفج', 30),
        (2795, 'همدان', 'تویسرکان', 30),
        (2796, 'همدان', 'سرکان', 30),
        (2797, 'همدان', 'دمق', 30),
        (2798, 'همدان', 'قروه در جزین', 30),
        (2799, 'همدان', 'رزن', 30),
        (2800, 'همدان', 'فامنین', 30),
        (2801, 'همدان', 'ازندریان', 30),
        (2802, 'همدان', 'جوکار', 30),
        (2803, 'همدان', 'زنگنه', 30),
        (2804, 'همدان', 'سامن', 30),
        (2805, 'همدان', 'ملایر', 30),
        (2806, 'همدان', 'فیروزان', 30),
        (2807, 'همدان', 'برزول', 30),
        (2808, 'همدان', 'گیان', 30),
        (2809, 'همدان', 'نهاوند', 30),
        (2810, 'همدان', 'قهاوند', 30),
        (2811, 'همدان', 'جورقان', 30),
        (2812, 'همدان', 'مریانج', 30),
        (2813, 'همدان', 'همدان', 30),
        (2814, 'همدان', 'شیرین سو', 30),
        (2815, 'همدان', 'گل تپه', 30),
        (2816, 'همدان', 'کبودر آهنگ', 30),
        (2817, 'همدان', 'دیناراباد', 30),
        (2818, 'همدان', 'همه کسی', 30),
        (2819, 'همدان', 'پرلوک', 30),
        (2820, 'همدان', 'حسین ابادبهارعاشوری', 30),
        (2821, 'همدان', 'ویرایی', 30),
        (2822, 'همدان', 'جنت اباد-همدان', 30),
        (2823, 'همدان', 'موسی اباد-همدان', 30),
        (2824, 'همدان', 'چنارسفلی', 30),
        (2825, 'همدان', 'چنارعلیا', 30),
        (2826, 'همدان', 'طویلان سفلی', 30),
        (2827, 'همدان', 'کوریجان', 30),
        (2828, 'همدان', 'کوهین-همدان', 30),
        (2829, 'همدان', 'قهوردسفلی', 30),
        (2830, 'همدان', 'اکنلو', 30),
        (2831, 'همدان', 'داق داق اباد', 30),
        (2832, 'همدان', 'تجرک', 30),
        (2833, 'همدان', 'کوزره', 30),
        (2834, 'همدان', 'چانگرین', 30),
        (2835, 'همدان', 'ازناو', 30),
        (2836, 'همدان', 'جوزان-همدان', 30),
        (2837, 'همدان', 'اورزمان', 30),
        (2838, 'همدان', 'اسلام اباد-همدان', 30),
        (2839, 'همدان', 'جعفریه (قلعه جعفربیک )', 30),
        (2840, 'همدان', 'میانده-همدان', 30),
        (2841, 'همدان', 'ولاشجرد', 30),
        (2842, 'همدان', 'اشتران', 30),
        (2843, 'همدان', 'باباپیر', 30),
        (2844, 'همدان', 'جهان اباد', 30),
        (2845, 'همدان', 'باباقاسم', 30),
        (2846, 'همدان', 'بابارستم', 30),
        (2847, 'همدان', 'دهفول', 30),
        (2848, 'همدان', 'شهرک صنعتی بوعلی', 30),
        (2849, 'همدان', 'پایگاه نوژه', 30),
        (2850, 'همدان', 'علیصدر', 30),
        (2851, 'همدان', 'گنبد', 30),
        (2852, 'همدان', 'پادگان قهرمان', 30),
        (2853, 'یزد', 'مهردشت', 31),
        (2854, 'یزد', 'ابرکوه', 31),
        (2855, 'یزد', 'عقدا', 31),
        (2856, 'یزد', 'احمد آباد', 31),
        (2857, 'یزد', 'اردکان', 31),
        (2858, 'یزد', 'بافق', 31),
        (2859, 'یزد', 'بهاباد', 31),
        (2860, 'یزد', 'تفت', 31),
        (2861, 'یزد', 'نیر', 31),
        (2862, 'یزد', 'مروست', 31),
        (2863, 'یزد', 'هرات', 31),
        (2864, 'یزد', 'خضر آباد', 31),
        (2865, 'یزد', 'اشکذر', 31),
        (2866, 'یزد', 'مهریز', 31),
        (2867, 'یزد', 'بفروئیه', 31),
        (2868, 'یزد', 'میبد', 31),
        (2869, 'یزد', 'ندوشن', 31),
        (2870, 'یزد', 'زارچ', 31),
        (2871, 'یزد', 'حمیدیا', 31),
        (2872, 'یزد', 'شاهدیه', 31),
        (2873, 'یزد', 'یزد', 31),
        (2874, 'یزد', 'فراغه', 31),
        (2875, 'یزد', 'اسفنداباد', 31),
        (2876, 'یزد', 'فهرج-یزد', 31),
        (2877, 'یزد', 'انارستان-یزد', 31),
        (2878, 'یزد', 'زرین', 31),
        (2879, 'یزد', 'اسفیج', 31),
        (2880, 'یزد', 'مبارکه-یزد', 31),
        (2881, 'یزد', 'کوشک-یزد', 31),
        (2882, 'یزد', 'بنستان', 31),
        (2883, 'یزد', 'تنگ چنار (چنار)', 31),
        (2884, 'یزد', 'ارنان', 31),
        (2885, 'یزد', 'بهادران', 31),
        (2886, 'یزد', 'فتح اباد-یزد', 31),
        (2887, 'یزد', 'ناحیه صنعتی پیشکوه', 31),
        (2888, 'یزد', 'نصراباد', 31),
        (2889, 'یزد', 'علی اباد-یزد', 31),
        (2890, 'یزد', 'ناحیه صنعتی گاریزات', 31),
        (2891, 'یزد', 'دهشیر', 31)",
];