<?php
namespace Core;

class Avatars{
    public static array $avatars = array(
        "1" => "/public/uploads/avatar1.png",
        "2" => "/public/uploads/avatar2.png",
        "3" => "/public/uploads/avatar3.png",
        "4" => "/public/uploads/avatar4.png",
        "5" => "/public/uploads/avatar5.png",
        "6" => "/public/uploads/avatar6.png",
        "7" => "/public/uploads/avatar7.png",
        "8" => "/public/uploads/avatar8.png",
    );

    public static function get_avatars_ui(int $selected_item = 0 , bool $multi_avatar = true): string
    {
        $avatars = self::$avatars;
        $item = 0; $avatars_items = "";
        foreach ($avatars as $avatarID => $avatar){
            $item++;
            $activeClass = !empty($selected_item) ? ($selected_item == $avatarID ? "isActive" : "") : ($item == 1 ? "isActive" : "");
            $checkedValue = !empty($selected_item) ? ($selected_item == $avatarID ? "checked" : "") : ($item == 1 ? "checked" : "");
            if($multi_avatar || ($multi_avatar === false && $selected_item == $avatarID)){
                $avatars_items .= '<li class="avatar_item '.$activeClass.'" data-item="'.$avatarID.'">
                                    <img class="containImage" src="'.$avatar.'" alt="آواتار شماره '.$avatarID.'">
                                    <input type="radio" name="profile_avatar" value="'.$avatarID.'" '.$checkedValue.'>
                                </li>';
            }
        }

        $content = "";
        if(!empty($avatars_items)){
            $buttons = '';
            if($multi_avatar){
                $buttons = '<span class="mover_button right_mover_button"></span>
            <span class="mover_button left_mover_button"></span>';
            }
            $content =
                '<section id="avatar_selector">
            '.$buttons.'
            <div id="avatars_holder">
                <ul id="avatars_list">'.$avatars_items.'</ul>
            </div>
        </section>';
        }

        return $content;
    }
}