<?php
use Core\Utils;
if(defined("YOOZ_ROOT") && !empty($gifts) && is_array($gifts)){
?>

    <ul id="game_gifts">
        <?php
        foreach ($gifts as $gift_ID => $gift){
            $hashID = bin2hex(base64_encode("gift_".$gift_ID));
            $expireTiming = !empty($gift['gift_expire_timing']) ? ($gift['gift_expire_timing'] == "day" ? "روز" : "ساعت") : "";

            $claimedClass= $buttonActiveClass = "";
            if(!empty($user['gifts']) && array_key_exists($gift_ID , $user['gifts'])){
                $claimedClass = "isClaimed";
                $buttonActiveClass = "deActive";
            }
        ?>
            <li class="game_gift_item game_guide_item <?php echo $claimedClass; ?>" data-i="<?php echo $hashID; ?>">
                <div class="game_gift_ui game_box">
                    <i class="claimed_check_icon fa-solid fa-check"></i>
                    <div class="game_gift_ui_inner">
                        <div class="gift_item_info flexBox">
                            <div class="gift_item_image flexBox">
                                <div class="gift_item_thumbnail">
                                    <img class="scale_animate" src="<?php echo !empty($gift['gift_image_file']) ? $gift['gift_image_file'] : ""; ?>" alt="">
                                </div>
                            </div>
                            <h3 class="gift_title ltr_animate"><?php echo $gift['gift_name']; ?></h3>
                        </div>
                        <!--<p class="gift_expire ltr_animate">
                            <?php /*echo "مهلت استفاده: ".Utils::PersianNumber($gift['gift_expire_time'])." ".$expireTiming; */?>
                        </p>-->
                        <p class="gift_coins_number">
                            <i class="game_coin_ui parsi"><?php echo Utils::CoinsFormat($gift['required_coins']); ?></i>
                        </p>
                    </div>
                </div>

                <div class="game_guide_content hide">
                    <div class="popup_thumbnail">
                        <img src="<?php echo !empty($gift['gift_image_file']) ? $gift['gift_image_file'] : ""; ?>">
                    </div>
                    <h6 class="popup_title"><?php echo $gift['gift_name']; ?></h6>
                    <p class="popup_paragraph"><?php echo !empty($gift['gift_description']) ? $gift['gift_description'] : ""; ?></p>
                    <p class="popup_paragraph">
                        با دریافت این آیتم
                        <b class="coin_number"><?php echo Utils::CoinsFormat($gift['required_coins']); ?></b>
                        سکه از شما کسر خواهد شد.
                    </p>
                    <div class="centerText yooz_json_form" data-page="game" data-action="gift">
                        <input type="hidden" name="gci" value="<?php echo $hashID; ?>">
                        <button class="popup_button check_button accept_yooz_form_btn <?php echo $buttonActiveClass; ?>">دریافت</button>
                    </div>
                </div>

                <div class="success_popup_message_content message_box_content_container">
                    <div class="popup_thumbnail">
                        <img src="<?php echo !empty($gift['gift_image_file']) ? $gift['gift_image_file'] : ""; ?>">
                    </div>
                    <h6 class="popup_title">تبریک</h6>
                    <p class="popup_box_item"><?php echo "مهلت استفاده از جایزه این کارت: ".Utils::PersianNumber($gift['gift_expire_time'])." ".$expireTiming; ?></p>
                    <p class="popup_paragraph">
                        شما کارت جایزه
                        <?php echo $gift['gift_name']; ?>
                        را بدست آوردید هم اکنون اطلاعیه ها را مشاهده نمایید
                    </p>
                    <div class="centerText">
                        <button class="popup_button check_button message_popup_close_button" data-next="">متوجه شدم</button>
                    </div>
                </div>

            </li>
        <?php
        }
        ?>
    </ul>

<?php
}
?>