<?php
if(defined("YOOZ_ROOT")){
    
    $game_colors = \Core\Site_Options::get("_game_colors");
    
    if(!empty($game_colors) && is_array(unserialize($game_colors))){
        $game_colors = unserialize($game_colors);
        echo '<style>html{';
        foreach($game_colors as $key => $val){
            echo $key.':'.$val." !important;";
        }
        echo '}</style>';
    }
?>
    <section id="game_framework" class="flexBox">
        <div id="game_screen">
            <section id="game_home_screen" class="game_main_sections isActive" data-item="1">
                <?php
                    require_once __DIR__."/template-parts/header.php";
                    require_once __DIR__."/template-parts/slider.php";
                    require_once __DIR__."/template-parts/medal_section.php";
                    require_once __DIR__."/template-parts/guess.php";
                    require_once __DIR__."/template-parts/events.php";
                ?>

                <section id="actions_list">
                    <div class="actions_tabs_buttons flexBox game_box_bg">
                        <?php if(!empty($gifts) && is_array($gifts)){ ?>
                        <button class="actions_button_item isActive" data-id="1">جایزه بگیر</button>
                        <?php } ?>
                        <?php if(!empty($missions) && is_array($missions)){ ?>
                        <button class="actions_button_item" data-id="2">ماموریت‌های شما</button>
                        <?php } ?>
                        <button class="actions_button_item" data-id="3">سکه بگیر</button>
                    </div>
                    <div class="actions_tabs_contents">
                        <?php if(!empty($gifts) && is_array($gifts)){ ?>
                        <div class="action_tab_content isActive" data-id="1">
                            <?php require_once __DIR__."/template-parts/gifts.php"; ?>
                        </div>
                        <?php } ?>
                        <?php if(!empty($missions) && is_array($missions)){ ?>
                        <div class="action_tab_content" data-id="2">
                            <?php require_once __DIR__."/template-parts/missions.php"; ?>
                        </div>
                        <?php } ?>
                        <?php if(!empty($cards) && is_array($cards)){ ?>
                        <div class="action_tab_content" data-id="3">
                            <?php require_once __DIR__."/template-parts/cards.php"; ?>
                        </div>
                        <?php } ?>
                    </div>
                </section>

            </section>

            <section id="game_notification_section" class="game_main_sections" data-item="2">
                <?php require_once __DIR__."/game_notification_section.php"; ?>
            </section>
            <section id="game_invitation_section" class="game_main_sections" data-item="3">
                <?php require_once __DIR__."/game_invitation_section.php"; ?>
            </section>
            <section id="game_daily_view_section" class="game_main_sections" data-item="4">
                <?php require_once __DIR__."/game_daily_view_section.php"; ?>
            </section>
            <section id="game_creator_section" class="game_main_sections" data-item="5">
                <?php require_once __DIR__."/game_creator_section.php"; ?>
            </section>

        </div>



        <?php require_once __DIR__."/template-parts/footer.php"; ?>

        <?php require_once __DIR__."/template-parts/popup_box.php"; ?>

        <?php
        if(!empty($score_sys) && !empty($score_sys['activation']) && $score_sys['activation'] == "yes"){
            require_once __DIR__."/template-parts/top_rank_users.php";
        }

        require_once __DIR__."/edit_profile.php";
        ?>
    </section>

    <?php if(empty($user['tour_guide'])){ ?>
    <script type="text/javascript" src="/public/assets/js/Tourguide.js"></script>
    <script type="text/javascript" src="/public/assets/js/guide_tour.js"></script>
    <?php } ?>


<?php
}
?>