<?php
use Core\Utils;
if(!empty("YOOZ_ROOT") && !empty($user) && is_array($user)){

    $name = !empty($user['name']) && !empty($user['family']) ? $user['name']." ".$user['family'] : "بدون نام";
    $phone = !empty($user['phone']) ? Utils::PersianNumber($user['phone']) : "نامشخص";
    $birthdate = !empty($user['birthdate']) ? Utils::PersianNumber(\Core\JDate::date("Y/m/d" ,strtotime($user['birthdate']))) : "نامشخص";
    $regDate = !empty($user['user_register_date']) ? Utils::PersianNumber(\Core\JDate::date("Y/m/d" ,strtotime($user['user_register_date']))) : "نامشخص";
    $gender = !empty($user['gender']) ? ($user['gender'] == "male" ? "آقا" : "خانم") : "نامشخص";
    $province = !empty($user['province']) ? $user['province'] : "نامشخص";
    $city = !empty($user['city']) ? $user['city'] : "نامشخص";
    $medals = !empty($user['medals_number']) ? Utils::PersianNumber($user['medals_number']) : "۰";
    $thisYearMedals = !empty($user['this_year_medals_number']) ? Utils::PersianNumber($user['this_year_medals_number']) : "۰";

    $imageID = !empty($user['personal_image']) ? intval($user['personal_image']) : 0;
    $image = "/public/uploads/emptyImage.jpg";
    if(!empty($imageID)){
        $file = \Plugins\Yooz_Manager\Yooz_Manager_Utils::get_file_by_id($imageID);
        if($file && is_array($file) && !empty($file['file_url'])){
            $image = $file['file_url'];
        }
    }
?>

    <section id="user_details_add_coin_section" class="yooz_json_form" data-page="customers" data-action="add_coins_to_user">
        <h6 class="yooz_title centerText">افزودن سکه هدیه به کاربر</h6>
        <input type="hidden" name="user_ID" value="<?php echo $user['user_ID']; ?>">
        <input type="number" id="add_coins_to_user_input" name="coins_number" value="" placeholder="سکه هدیه">
        <button id="submit_yooz_coins" class="yooz_control_button">افزودن</button>
    </section>
    <section id="user_details_section">
        <h1 class="yooz_title centerText">ریز جزئیات اطلاعات کاربر</h1>
        <div id="user_details_form" class="flexBoxWithWrap">
            <li class="user_details_item">
                <label>نام :</label>
                <p><?php echo $name; ?></p>
            </li>
            <li class="user_details_item">
                <label>جنسیت :</label>
                <p><?php echo $gender; ?></p>
            </li>
            <li class="user_details_item">
                <label>شماره همراه :</label>
                <p><?php echo $phone; ?></p>
            </li>
            <li class="user_details_item">
                <label>سال تولد :</label>
                <p><?php echo $birthdate; ?></p>
            </li>
            <li class="user_details_item">
                <label>استان و شهر :</label>
                <p><?php echo $province." - ".$city; ?></p>
            </li>
            <li class="user_details_item">
                <label>تعداد مدال کل :</label>
                <p><?php echo $medals; ?></p>
            </li>
            <li class="user_details_item">
                <label>تعداد مدال امسال :</label>
                <p><?php echo $thisYearMedals; ?></p>
            </li>
            <li class="user_details_item">
                <label>تعداد دعوت :</label>
                <p><?php echo !empty($user['friends']) ? Utils::PersianNumber(count($user['friends'])) : "۰"; ?></p>
            </li>
            <li class="user_details_item">
                <label>تعداد سکه‌ :</label>
                <p><?php echo !empty($user['coins_number']) ? Utils::CoinsFormat($user['coins_number']) : "۰"; ?></p>
            </li>
            <li class="user_details_item">
                <label>تاریخ ثبت نام :</label>
                <p><?php echo $regDate; ?></p>
            </li>
        </div>

        <div id="user_details_gifts">
            <h6 class="yooz_title centerText">جایزه ها</h6>
            <ul id="user_details_gifts_list">
                <?php
                if(!empty($user['gifts']) && is_array($user['gifts'])){
                    foreach ($user['gifts'] as $ug){
                        $gName = !empty($ug['gift_name']) ? $ug['gift_name'] : "بدون عنوان";
                        $gUsage = !empty($ug['gift_usage_status']) ? ($ug['gift_usage_status'] == "used" ? "استفاده شده" : "بدون استفاده") : "نامشخص";
                        $gExpire = !empty($ug['gift_expire']) ? Utils::PersianNumber(\Core\JDate::date("Y/m/d" , strtotime($ug['gift_expire']))) : "نامشخص";
                        $gClaimTime = !empty($ug['claim_gift_time']) ? Utils::PersianNumber(\Core\JDate::date("Y/m/d" , strtotime($ug['claim_gift_time']))) : "نامشخص";
                        $status = "active";
                        if(strtotime($ug['gift_expire']) < time() || $ug['gift_usage_status'] == "used"){
                            $status = "deActive";
                        }
                        ?>
                        <li class="user_details_gift_item <?php echo $status; ?>">
                            <div class="user_details_gift_item_info">
                                <p class="user_details_gift_name"><?php echo $gName; ?></p>
                                <div class="flexBoxWithWrap">
                                    <div class="user_details_gift_info">
                                        <label>وضعیت استفاده :</label>
                                        <span class="user_details_gift_usage"><?php echo $gUsage; ?></span>
                                    </div>
                                    <div class="user_details_gift_info">
                                        <label>زمان دریافت :</label>
                                        <span class="user_details_gift_usage"><?php echo $gClaimTime; ?></span>
                                    </div>
                                    <div class="user_details_gift_info">
                                        <label>زمان انقضا :</label>
                                        <span><?php echo $gExpire; ?></span>
                                    </div>
                                </div>
                            </div>
                            <?php if($status == "active"){ ?>
                                <div class="user_details_gift_item_buttons yooz_json_form" data-page="customers" data-action="change_user_gift_status">
                                    <input type="hidden" name="user_ID" value="<?php echo $user['user_ID']; ?>">
                                    <input type="hidden" name="gift_ID" value="<?php echo $ug['gift_ID']; ?>">
                                    <button>غیر فعالسازی</button>
                                </div>
                            <?php } ?>
                        </li>
                <?php
                    }
                }
                ?>
            </ul>
        </div>

        <div id="user_details_events">
            <h6 class="yooz_title centerText">رویداد ها</h6>
            <ul id="user_details_gifts_list">
                <?php
                if(!empty($user['events']) && is_array($user['events'])){
                    foreach ($user['events'] as $ue){
                        $eName = !empty($ue['event_name']) ? $ue['event_name'] : "بدون عنوان";
                        $eUsage = !empty($ue['event_usage_status']) ? ($ue['event_usage_status'] == "used" ? "استفاده شده" : "بدون استفاده") : "نامشخص";
                        $eExpire = !empty($ue['event_expire']) ? Utils::PersianNumber(\Core\JDate::date("Y/m/d" , strtotime($ue['event_expire']))) : "نامشخص";
                        $eClaimTime = !empty($ue['claim_event_time']) ? Utils::PersianNumber(\Core\JDate::date("Y/m/d" , strtotime($ue['claim_event_time']))) : "نامشخص";
                        $status = "active";
                        if(strtotime($ue['event_expire']) < time() || $ue['event_usage_status'] == "used"){
                            $status = "deActive";
                        }
                        ?>
                        <li class="user_details_gift_item <?php echo $status; ?>">
                            <div class="user_details_gift_item_info">
                                <p class="user_details_gift_name"><?php echo $eName; ?></p>
                                <div class="flexBoxWithWrap">
                                    <div class="user_details_gift_info">
                                        <label>وضعیت استفاده :</label>
                                        <span class="user_details_gift_usage"><?php echo $eUsage; ?></span>
                                    </div>
                                    <div class="user_details_gift_info">
                                        <label>زمان دریافت :</label>
                                        <span class="user_details_gift_usage"><?php echo $eClaimTime; ?></span>
                                    </div>
                                    <div class="user_details_gift_info">
                                        <label>زمان انقضا :</label>
                                        <span><?php echo $eExpire; ?></span>
                                    </div>
                                </div>
                            </div>
                            <?php if($status == "active"){ ?>
                                <div class="user_details_gift_item_buttons yooz_json_form" data-page="customers" data-action="change_user_event_status">
                                    <input type="hidden" name="user_ID" value="<?php echo $user['user_ID']; ?>">
                                    <input type="hidden" name="event_ID" value="<?php echo $ue['event_ID']; ?>">
                                    <button>غیر فعالسازی</button>
                                </div>
                            <?php } ?>
                        </li>
                        <?php
                    }
                }
                ?>
            </ul>
        </div>

    </section>
<?php
}
?>