<?php
function get_interactive_messages(array $items){
    $items_html = "";$items_number = 0;
    foreach($items as $item){
        if(!empty($item['message_ID'])){
            $items_number++;
            $image = \Plugins\Yooz_Manager\Yooz_Manager_Utils::get_file_by_id($item['message_image_id']);
            $imageURL = $image && !empty($image['file_url']) ? $image['file_url'] : "/public/uploads/emptyImage.jpg";
            $items_html .= '
                <li class="interactive_message_item game_part_item yes_display_message_item">
                    <div class="interactive_message_item_inner game_part_item_inner">
                        <section class="interactive_message_image">
                            <div class="interactive_message_image_box">
                                <img src="'.$imageURL.'" alt="'.$item['message_title'].'">
                            </div>   
                        </section>
                        <section class="interactive_message_info">
                            <h3 class="interactive_message_title">'.$item['message_title'].'</h3>
                            <p class="interactive_message_text">'.$item['message_text'].'</p>
                        </section>
                    </div>
                    <div class="interactive_message_buttons game_part_buttons">
                        <div class="edit_or_add_message_btn game_part_button_edit game_part_button_item yooz_json_form" data-page="message_settings"  data-action="get_interactive_message">
                            <button id="editmissionItemButton">ویرایش</button>
                            <input type="hidden" name="message_ID" value="'.$item['message_ID'].'">
                        </div>
                        <div class="delete_message_btn delete_item_button game_part_button_item yooz_json_form" data-page="message_settings"  data-action="delete_interactive_message">
                            <button id="deletemissionItemButton">حذف</button>
                            <input type="hidden" class="delete_item_input" name="message_ID" value="'.$item['message_ID'].'">
                        </div>
                    </div>
                </li>
            ';
        }
    }

    $structure = '<ul class="interactive_message_list">'.$items_html.'</ul>';
    return ["items_number" => $items_number, "structure" => $structure];
}