<?php
if(defined('YOOZ_ROOT')) {
    require_once "message_item.php";
    $messageItems = get_interactive_messages($all_messages);

    $messages_form = [
        "inputs"  => array(
            'items' => array(
                array(
                    'type'  =>  'image',
                    'name'  =>  'message_image_id',
                    'label' =>  'تصویر پیام',
                ),
                array(
                    'name'  =>  'message_title',
                    'label' =>  'عنوان پیام',
                    'value' =>  "",
                    'autocomplete'  => 'off',
                    "require"       => 'true'
                ),
                array(
                    'type'  =>  'textarea',
                    'name'  =>  'message_text',
                    'label' =>  'متن پیام',
                    'value' =>  "",
                    'autocomplete'  => 'off',
                    "require"       => 'true'
                ),
                array(
                    'type'  =>  'number',
                    'name'  =>  'gift_coins',
                    'label' =>  'تعداد سکه هدیه',
                ),
                array(
                    'type'  =>  'hidden',
                    'name'  =>  'message_ID',
                    'input_id'  =>  'message_id_hidden_input',
                ),
                array(
                    'type'  =>  'select',
                    'name'  =>  'message_members',
                    'label' =>  'از بین چه افرادی',
                    'options'   => array(
                        'all'                   => "همه",
                        'medalists'             => "همه مدال آوران",
                        'last_month_medalists'  => "مدال آوران ماه گذشته",    
                        'filtered'              => "فیلتر پیشرفته",
                    ),
                ),
            )
        ),
        "conditions" => array(
            'title' => 'فیلتر مشتریانی که این پیام را دریافت می‌کنند.',
            "items" =>array(
                array(
                    'type'  =>  'number',
                    'name'  =>  'min_coins',
                    'label' =>  'حداقل موجودی سکه',
                    'item_class'   => 'half_row'
                ),
                array(
                    'type'  =>  'number',
                    'name'  =>  'max_coins',
                    'label' =>  'حداکثر موجودی سکه',
                    'item_class'   => 'half_row'
                ),
//                array(
//                    'type'  =>  'multi_selection',
//                    'name'  =>  'has_cards',
//                    'label' =>  'دارای این کارت‌ها باشد',
//                    'options'   => $all_cards,
//                ),
                array(
                    'type'  =>  'select',
                    'name'  =>  'has_missions',
                    'label' =>  'این ماموریت‌ها را انجام داده باشد',
                    'options'   => $all_missions,
                ),
                array(
                    'type'  =>  'select',
                    'name'  =>  'has_gifts',
                    'label' =>  'دارای این کارت‌های جایزه باشد',
                    'options'   => $all_gifts,
                ),
                array(
                    'type'  =>  'date',
                    'name'  =>  'register_from',
                    'label' =>  'ثبت نام بعد از این تاریخ',
                ),
                array(
                    'type'  =>  'date',
                    'name'  =>  'register_until',
                    'label' =>  'ثبت نام قبل از این تاریخ',
                ),
            )
        )
    ];



    ?>

    <h6 class="yooz_title">پیام‌های تعاملی</h6>
    
    <div class="empty_section_text_box">
        <strong>پیام تعاملی چیست؟</strong>
        <p>این نوع پیام بصورت غیر خودکار بوده و شما می توانید هر زمان که بخواهید با تنظیم فیلترهای مختلف گروه خاصی از مخاطبان خود را انتخاب کرده و بصورت درون برنامه ای پیامی را برای آنها ارسال نمایید تا کاربران در قسمت اطلاعیه های خود پیام شما را مشاهده کنند.</p>
    </div>


    <div class="yooz_json_form" data-page="message_settings" data-action="get_interactive_message">
        <button id="addNewMessageButton" class="edit_or_add_message_btn">افزودن پیام جدید</button>
        <input type="hidden" name="message_ID" value="0">
    </div>


    <div>
        <div id="all_messages_container">
            <?php echo $messageItems['structure']; ?>
        </div>
        <div class="centerText">
            <span id="display_all_messages" class="pointer">نمایش همه پیام‌ها</span>
        </div>
    </div>

    <div id="yooz_message_popup_form" class="yooz_popup_block">
        <div class="yooz_popup_header">
            <span class="yooz_popup_closer"></span>
            <p>افزودن/ویرایش</p>
        </div>
        <div class="yooz_popup_form_container">
            <?php
            echo $formClass->get_form($messages_form , "message_settings" , "save_interactive_message" , "ارسال" , "submitInterActiveMessage" , "interactive_message_settings_form");
            ?>
        </div>
    </div>
    <?php
}
?>