<?php
if(defined('YOOZ_ROOT')) {
    require_once "gift_card_item.php";
    $gifts = get_gift_cards($gift_items);


    $gifts_form = [
        "inputs"  => array(
            'items' => array(
                array(
                    'type'  =>  'image',
                    'name'  =>  'gift_image_id',
                    'label' =>  'تصویر جایزه',
                ),
                array(
                    'name'  =>  'gift_name',
                    'label' =>  'نام جایزه',
                    'value' =>  "",
                    'autocomplete'  => 'off',
                    "require"       => 'true'
                ),
                array(
                    'type'  =>  'textarea',
                    'name'  =>  'gift_description',
                    'label'  =>  'توضیحات قبل از دریافت کارت',
                    'placeholder' =>  'توضیح کوتاهی در مورد این کارت جایزه بنویسید.',
                ),
                array(
                    'type'  =>  'textarea',
                    'name'  =>  'gift_claim_description',
                    'label'  =>  'توضیحات بعد از دریافت کارت',
                ),
                array(
                    'type'  =>  'number',
                    'name'  =>  'required_coins',
                    'label' =>  'تعداد سکه مورد نیاز',
                ),
                array(
                    'type'  =>  'number',
                    'name'  =>  'gift_expire_time',
                    'label' =>  'تاریخ انقضای مصرف کارت برای مشتری',
                    'placeholder'   => 'تعداد',
                    'item_class'   => 'half_row'
                ),
                array(
                    'type'  =>  'select',
                    'name'  =>  'gift_expire_timing',
                    'label' =>  'نوع زمان انقضا جایزه',
                    'item_class'   => 'half_row',
                    'options'   => array(
                        'day'   => 'روز',
                        'hour'  => 'ساعت'
                    ),
                ),
                array(
                    'type'  =>  'select',
                    'name'  =>  'gift_status',
                    'label' =>  'وضعیت',
                    'options' => array(
                        'yes'   => "فعال",
                        'no'   => "غیر فعال",
                    ),
                ),
                array(
                    'type'  =>  'hidden',
                    'name'  =>  'gift_ID',
                    'input_id'  =>  'card_id_hidden_input',
                ),
            )
        )
    ];



?>

    <h6 class="yooz_title">کارت‌های جایزه ثابت</h6>

    <?php if($gifts && $gifts['items_number'] == 0){ ?>
        <div class="empty_section_text_box">
            <strong>اولین کارت رو ایجاد کن</strong>
            <p>مدیر عزیز هنوز هیچ کارتی تعریف نشده. شما می‌تونید روی دکمه افزودن کارت جدید کلیک کنید و اولین کارت شانس بازی خودتون رو تعریف کنید.</p>
        </div>
    <?php }else{ ?>
        <div class="empty_section_text_box">
            <strong>ویرایش و یا افزودن کارت</strong>
            <p>مدیر عزیز شما می‌توانید با کلیک بر روی افزودن کارت جدید ، یک کارت جدید ایجاد نمایید. همچنین با کلیک بر روی نمایش همه ، می‌توانید کارت هایی که پیش تر ایجاد نمودید را مشاهده نمایید.</p>
        </div>
    <?php } ?>


    <div class="yooz_json_form" data-page="game_gifts" data-action="get_gift_info">
        <button id="addNewCardButton" class="edit_or_add_card_btn">افزودن کارت جدید</button>
        <input type="hidden" name="gift_ID" value="0">
    </div>


    <div>
        <div id="all_cards_container">
            <?php echo $gifts['structure']; ?>
        </div>
        <div class="centerText">
            <span id="display_all_cards" class="pointer">نمایش همه کارت‌ها</span>
        </div>
    </div>

    <div id="yooz_cards_popup_form" class="yooz_popup_block">
        <div class="yooz_popup_header">
            <span class="yooz_popup_closer"></span>
            <p>افزودن/ویرایش</p>
        </div>
        <div class="yooz_popup_form_container">
            <?php
            echo $formClass->get_form($gifts_form , "game_gifts" , "save_gift" , "ذخیره کارت" , "submitCardDataButton" , "gift_settings_form");
            ?>
        </div>
    </div>
<?php
}
?>