<?php
if(defined('YOOZ_ROOT')) {
    require_once "event_item.php";
    $events = get_event_items($event_items);


    $events_form = [
        "inputs"  => array(
            'items' => array(
                array(
                    'type'  =>  'image',
                    'name'  =>  'event_image_id',
                    'label' =>  'تصویر رویداد',
                ),
                array(
                    'name'  =>  'event_title',
                    'label' =>  'عنوان رویداد',
                    'value' =>  "",
                    'autocomplete'  => 'off',
                    "require"       => 'true'
                ),
                array(
                    'name'  =>  'event_name',
                    'label' =>  'نام رویداد',
                    'value' =>  "",
                    'autocomplete'  => 'off',
                    "require"       => 'true'
                ),
                array(
                    'type'  =>  'textarea',
                    'name'  =>  'event_description',
                    'label'  =>  'توضیحات بعد از برنده شدن',
                    'placeholder' =>  'توضیحات',
                ),
                array(
                    'type'  =>  'number',
                    'name'  =>  'required_coins',
                    'label' =>  'تعداد سکه مورد نیاز',
                ),
                array(
                    'type'  =>  'date',
                    'name'  =>  'event_expire',
                    'label' =>  'زمان انتقضا',
                ),
                array(
                    'type'  =>  'select',
                    'name'  =>  'event_status',
                    'label' =>  'وضعیت',
                    'options' => array(
                        'yes'   => "فعال",
                        'no'   => "غیر فعال",
                    ),
                ),
                array(
                    'type'  =>  'hidden',
                    'name'  =>  'event_ID',
                    'input_id'  =>  'event_id_hidden_input',
                ),
            )
        )
    ];



    ?>

    <h6 class="yooz_title">رویداد‌ها</h6>

    <?php if($events && $events['items_number'] == 0){ ?>
        <div class="empty_section_text_box">
            <strong>اولین رویداد رو ایجاد کن</strong>
            <p>مدیر عزیز هنوز هیچ رویدادی تعریف نشده. شما می‌تونید روی دکمه افزودن رویداد جدید کلیک کنید و اولین رویداد بازی خودتون رو تعریف کنید.</p>
        </div>
    <?php }else{ ?>
        <div class="empty_section_text_box">
            <strong>ویرایش و یا افزودن رویداد</strong>
            <p>مدیر عزیز شما می‌توانید با کلیک بر روی افزودن رویداد جدید ، یک رویداد جدید ایجاد نمایید. همچنین با کلیک بر روی نمایش همه ، می‌توانید رویداد هایی که پیش تر ایجاد نمودید را مشاهده نمایید.</p>
        </div>
    <?php } ?>


    <div class="yooz_json_form" data-page="game_gifts" data-action="get_event_info">
        <button id="addNewEventButton" class="edit_or_add_event_btn">افزودن رویداد جدید</button>
        <input type="hidden" name="event_ID" value="0">
    </div>


    <div>
        <div id="all_events_container">
            <?php echo $events['structure']; ?>
        </div>
        <div class="centerText">
            <span id="display_all_events" class="pointer">نمایش همه رویدادها</span>
        </div>
    </div>

    <div id="yooz_events_popup_form" class="yooz_popup_block">
        <div class="yooz_popup_header">
            <span class="yooz_popup_closer"></span>
            <p>افزودن/ویرایش</p>
        </div>
        <div class="yooz_popup_form_container">
            <?php
            echo $formClass->get_form($events_form , "game_gifts" , "save_event" , "ذخیره رویداد" , "submitEventDataButton" , "event_settings_form");
            ?>
        </div>
    </div>
    <?php
}
?>