<?php
function get_mission_coins($coins){
    $coins = intval($coins);
    if($coins >= 1000000){
        $coins = round($coins / 1000000 , 1) . "M";
    }elseif($coins >= 1000){
        $coins = round($coins / 1000 , 1) . "K";
    }
    return $coins;
}
function get_game_missions(array $game_missions){
    $missionsItems = "";$missions_number = 0;
    foreach($game_missions as $mission){
        if(!empty($mission['mission_ID'])){
            $missions_number++;
            $mission_coins = get_mission_coins($mission['mission_coins']);
            $image = \Plugins\Yooz_Manager\Yooz_Manager_Utils::get_file_by_id($mission['mission_image_id']);
            $missionImage = $image && !empty($image['file_url']) ? $image['file_url'] : "/public/uploads/emptyImage.jpg";
            $missionsItems .= '
                <li class="game_mission_item game_part_item '.$mission['display_status'].'_display_part_item" style="background-color:'.$mission['mission_bg_color'].';">
                    <div class="game_mission_item_inner game_part_item_inner">
                        <section class="game_mission_image">
                            <div class="game_mission_image_box">
                                <img src="'.$missionImage.'" alt="'.$mission['mission_title'].'">
                            </div>   
                        </section>
                        <section class="game_mission_info">
                            <h3 class="game_mission_title">'.$mission['mission_title'].'</h3>
                            <p class="game_mission_description">'.$mission['mission_description'].'</p>
                            <div class="mission_button_adn_price_holder">
                                <section class="game_mission_coin_ui">
                                    <li class="fas fa-coin"></li>
                                    <span class="game_mission_coins_amount">'.$mission_coins.'</span>
                                </section>
                                <section class="game_mission_button_ui">
                                    <button class="game_mission_button">'.$mission['mission_button_label'].'</button>
                                </section>
                            </div>
                        </section>
                    </div>
                    <div class="game_mission_buttons game_part_buttons">
                        <div class="edit_or_add_mission_btn game_part_button_edit game_part_button_item yooz_json_form" data-page="game_coins"  data-action="get_mission_info">
                            <button id="editmissionItemButton">ویرایش</button>
                            <input type="hidden" name="mission_ID" value="'.$mission['mission_ID'].'">
                        </div>
                        <div class="delete_mission_btn game_part_button_item delete_item_button yooz_json_form" data-page="game_coins"  data-action="delete_mission">
                            <button id="deletemissionItemButton">حذف</button>
                            <input type="hidden" class="delete_item_input" name="mission_ID" value="'.$mission['mission_ID'].'">
                        </div>
                    </div>
                </li>
            ';
        }
    }

    $structure = '<ul class="game_missions_list">'.$missionsItems.'</ul>';
    return ["missions_number" => $missions_number, "structure" => $structure];
}
?>
