<?php
function convert_large_numbers($coins){
    $coins = intval($coins);
    if($coins >= 1000000){
        $coins = round($coins / 1000000 , 1) . "M";
    }elseif($coins >= 1000){
        $coins = round($coins / 1000 , 1) . "K";
    }
    return $coins;
}
function get_guess_items(array $guess_items){
    $html = "";$items_number = 0;
    foreach($guess_items as $guess){
        if(!empty($guess['guess_ID'])){
            $items_number++;
            $fine_coins = !empty($guess['fine_coins']) ? convert_large_numbers($guess['fine_coins']) : 0;
            $gift_coins = !empty($guess['gift_coins']) ? convert_large_numbers($guess['gift_coins']) : 0;
            $guess_code = !empty($guess['guess_code']) ? $guess['guess_code'] : "";

            $image = \Plugins\Yooz_Manager\Yooz_Manager_Utils::get_file_by_id($guess['guess_image_id']);
            $guessImage = $image && !empty($image['file_url']) ? $image['file_url'] : "/public/uploads/emptyImage.jpg";

            $html .= '
                <li class="game_guess_item game_part_item '.$guess['display_status'].'_display_part_item">
                    <div class="game_guess_item_inner game_part_item_inner">
                        <section class="game_mission_image">
                            <div class="game_mission_image_box">
                                <img src="'.$guessImage.'">
                            </div>   
                        </section>
                        <section class="game_mission_info">
                            <div class="game_guess_info_item">
                                <label>کد شانس :</label><span>'.$guess_code.'</span>
                            </div>
                            <div class="game_guess_info_item">
                                <label>جایزه :</label><span>'.$gift_coins.'</span>
                            </div>
                            <div class="game_guess_info_item">
                                <label>جریمه :</label><span>'.$fine_coins.'</span>
                            </div>
                        </section>
                    </div>
                    <div class="game_guess_buttons game_part_buttons">
                        <div class="edit_or_add_guess_btn game_part_button_edit game_part_button_item yooz_json_form" data-page="game_coins"  data-action="get_guess_info">
                            <button id="editGuessItemButton">ویرایش</button>
                            <input type="hidden" name="guess_ID" value="'.$guess['guess_ID'].'">
                        </div>
                        <div class="delete_guess_btn game_part_button_item delete_item_button yooz_json_form" data-page="game_coins"  data-action="delete_guess">
                            <button id="deleteGuessItemButton">حذف</button>
                            <input type="hidden" class="delete_item_input" name="guess_ID" value="'.$guess['guess_ID'].'">
                        </div>
                    </div>
                </li>
            ';
        }
    }

    $structure = '<ul class="game_guess_list">'.$html.'</ul>';
    return ["items_number" => $items_number, "structure" => $structure];
}
?>