<?php
function get_searched_user_structure(array $user){

    $name = !empty($user['name']) && !empty($user['family']) ? $user['name']." ".$user['family'] : "بدون نام";
    $phone = !empty($user['phone']) ? \Core\Utils::PersianNumber($user['phone']) : "نامشخص";
    $birthYear = !empty($user['birthdate']) ? \Core\JDate::date("Y" ,strtotime($user['birthdate'])) : "نامشخص";
    $gender = !empty($user['gender']) ? ($user['gender'] == "male" ? "آقا" : "خانم") : "نامشخص";
    $city = !empty($user['city']) && !empty($user['province']) ? $user['province']."/".$user['city'] : "نامشخص";
    $medals = !empty($user['medals_number']) ? \Core\Utils::PersianNumber($user['medals_number']) : "۰";
    $link = ADMIN_URL."/customer_details?id=".$user['user_ID'];
    $content = <<<HTML
        <div id="sui_box">
            <div id="sui_box_title">اطلاعات مشتری</div>
            <div id="sui_info">
                <div id="sui_table">
                    <table>
                        <tr>
                            <th>نام</th>
                            <th>شماره همراه</th>
                            <th>سال تولد</th>
                            <th>جنسیت</th>
                            <th>استان و شهر</th>
                            <th>تعداد مدال کل</th>
                        </tr>
                        <tr>
                            <td>{$name}</td>
                            <td>{$phone}</td>
                            <td>{$birthYear}</td>
                            <td>{$gender}</td>
                            <td>{$city}</td>
                            <td>{$medals}</td>
                        </tr>
                    </table>
                </div>
                <div id="sui_buttons">
                    <a href="{$link}">
                        <button type="submit">مشاهده جزئیات</button>
                    </a>
                </div>
            </div>
        </div>
    HTML;
    return $content;
}