<?php
if(defined("YOOZ_ROOT")){
?>
    <section class="main_sections">
        <div id="search_user_info_form" class="flexBox yooz_json_form" data-page="customers" data-action="search_user">
            <div id="customer_title_sec" class="flexBox">
                <h6 class="yooz_title">مشتریان</h6>
            </div>
            <div id="customer_input_section">
                <div class="yooz_input_holder flexBox">
                    <i class="fas fa-phone"></i>
                    <div class="yoozFormInputContainer">
                        <input type="text" name="customer_phone" placeholder="شماره همراه مشتری">
                    </div>
                </div>
            </div>
            <div id="customer_buttons_section" class="ltr">
                <button type="submit" class="yooz_accept_input">جستجوی سوابق</button>
            </div>
        </div>
        <div id="searched_user_informations"></div>
    </section>

    <section id="yooz_user_export_section">
        <h6 class="yooz_title">خروجی گرفتن از اطلاعات مشتریان</h6>
        <div class="yooz_control_box">
            <div class="yooz_control_buttons yooz_json_form" data-page="customers" data-action="export_users_data">
                <button class="yooz_control_button">خروجی گرفتن اطلاعات</button>
            </div>
            <p class="yooz_control_notice_text">
                خروجی اطلاعات در قالب فایل اکسل بوده و شامل اطلاعات نام مشتری، جنسیت، استان، شهر و تعداد کل مدال‌ها می‌باشد.
            </p>
        </div>
    </section>


    <section id="yooz_statistics_tables" class="main_sections flexBox yooz_json_form" data-page="" data-action="">
        <section class="yooz_table_container">
            <div class="yooz_table_header">
                <h6 class="yooz_title">برترین کاربران</h6>
            </div>
            <table class="fullWidth">
                <tbody>
                <tr>
                    <th>رتبه</th>
                    <th>نام</th>
                    <th>شماره</th>
                    <th>تاریخ</th>
                </tr>
                <?php
                if(!empty($top5Users) && is_array($top5Users)){
                    $rank = 0;
                    foreach ($top5Users as $user){
                        $rank++;
                        $name = !empty($user['name']) && !empty($user['family']) ? $user['name']." ".$user['family'] : "کاربر ".$user['user_ID'];
                        $phone = !empty($user['phone']) ? \Core\Utils::PersianNumber($user['phone']) : "نامشخص";
                        $regDate = !empty($user['user_register_date']) ? \Core\Utils::PersianNumber(\Core\JDate::date("Y/m/d" , strtotime($user['user_register_date'])) ): "نامشخص";
                        $user_rank = \Core\Utils::PersianNumber($rank);
                        echo '<tr><td>'.$user_rank.'</td><td>'.$name.'</td><td>'.$phone.'</td><td>'.$regDate.'</td></tr>';
                    }
                }
                ?>
                </tbody>
            </table>
            <div class="yooz_table_button_container ltr">
                <a href="<?php echo ADMIN_URL."/customer_list?order=medals_number"; ?>">
                    <button>نمایش همه</button>
                </a>
            </div>
        </section>
        <section class="yooz_table_container">
            <div class="yooz_table_header">
                <h6 class="yooz_title">آخرین عضویت‌ها</h6>
            </div>
            <table class="fullWidth">
                <tbody>
                <tr>
                    <th>نام</th>
                    <th>شماره</th>
                    <th>تاریخ</th>
                </tr>
                <?php
                if(!empty($lastRegisteredUsers) && is_array($lastRegisteredUsers)){
                    foreach ($lastRegisteredUsers as $user){
                        $name = !empty($user['name']) && !empty($user['family']) ? $user['name']." ".$user['family'] : "کاربر ".$user['user_ID'];
                        $phone = !empty($user['phone']) ? \Core\Utils::PersianNumber($user['phone']) : "نامشخص";
                        $regDate = !empty($user['user_register_date']) ? \Core\Utils::PersianNumber(\Core\JDate::date("Y/m/d" , strtotime($user['user_register_date'])) ): "نامشخص";
                        echo '<tr><td>'.$name.'</td><td>'.$phone.'</td><td>'.$regDate.'</td></tr>';
                    }
                }
                ?>
                </tbody>
            </table>
            <div class="yooz_table_button_container ltr">
                <a href="<?php echo ADMIN_URL."/customer_list"; ?>">
                    <button>نمایش همه</button>
                </a>
            </div>
        </section>
    </section>
<?php
}
?>