<?php
use Core\Utils;

function get_rankings($rankings) {
    $output = '';
    $rank = 0;
    foreach ($rankings as $player) {
        $rank++;
        $image = !empty($player['profile_image_file']) ? $player['profile_image_file'] : "/public/uploads/emptyUser.jpg";
        $player_name = !empty($player['display_name']) ? $player['display_name'] : "کاربر";
        $score = !empty($player['total_score']) ? \Core\Utils::PersianNumber($player['total_score']) : "۰";
        $ranking = \Core\Utils::PersianNumber($rank);
        $output .= '
                            <li class="top_player_item flexBox game_box">
                                <section class="top_player_image">
                                    <img src="'.$image.'" alt="">
                                </section>
                                <section class="top_player_info">
                                    <p class="top_player_name">'.$player_name.'</p>
                                    <p class="top_player_score">'.$score.'</p>
                                </section>
                                <section class="top_player_rank">
                                    <p>'.$ranking.'</p>
                                </section>
                            </li>
                        ';
    }
    return $output;
}