<?php
use Core\Utils;

function replaceAnchors($text){
    // Regular expression to match text within double asterisks
    return preg_replace_callback(
        '/\*\*(.*?)\*\*/',
        function($matches) {
            // Split the matched text by asterisk
            $parts = explode('*', $matches[1], 2); // Limit to 2 parts
            // Check if we have exactly 2 parts (link and text)
            if(count($parts) > 1) {
                $link = trim($parts[0]); // The first part is the link
                $linkText = !empty($parts[1]) ? trim($parts[1]) : $link; // The second part is the display text
                // Create an anchor tag
                return '<a href="' . htmlspecialchars($link) . '" target="_blank">' . htmlspecialchars($linkText) . '</a>';
            }
            return $matches[0]; // Return original if not a valid format
        },
        $text
    );
}


function get_notifs($notifs){
    
    $content = '<ul id="notifications">';
    
    
    if(!empty($notifs) && is_array($notifs)){
        foreach ($notifs as $notif){
            $hashID = bin2hex(base64_encode("notif_".$notif['notification_ID']));
            $claimClass = $notif['notification_status'] == "visited" ? "isClaimed" : "";
            $create_time = !empty($notif['create_time']) ? \Core\JDate::date("Y/m/d" , strtotime($notif['create_time'])) : "";
            $notifText = replaceAnchors($notif['notification_text']);
            
            $content .= '
            <li class="game_notif_item game_guide_item '.$claimClass.'" data-i="'.$hashID.'">
                <div class="notif_item_ui game_box flexBoxWithWrap">
                    <section class="notif_item_date_info flexBox">
                        <div class="col-2">
                            <i class="fa-regular fa-envelope"></i>
                        </div>
                        <div class="col-2 leftText">
                            <p class="notif_item_date">'.Utils::PersianNumber($create_time).'</p>
                        </div>
                    </section>
                    <section class="notif_item_info">
                        <h3 class="notif_item_title">'.$notif['notification_title'].'</h3>
            ';
            
            if(!empty($notif['notification_coins'])){
                $content .= '
                <p class="notif_coins_number">
                    <i class="game_coin_ui parsi">
                        '.Utils::CoinsFormat($notif['notification_coins']).'
                    </i>
                </p>';
            }
            
            $content .= '
                </section>
                <section class="notif_open_button_holder">
                    <i class="fa-solid fa-angle-left"></i>
                </section>
            </div>
            <div class="game_guide_content hide">';
                        
            
            if(!empty($notif['notification_image'])){
                $content .= '
                <div class="popup_thumbnail">
                    <img src="'.$notif['notification_image'].'" alt="">
                </div>';
            }

            $content .= '
                    <h6 class="popup_title">'.$notif['notification_title'].'</h6>
                    <p class="popup_paragraph">'.$notifText.'</p>
                    <div class="centerText yooz_json_form" data-page="game" data-action="notification">
                        <input type="hidden" name="ni" value="'.$hashID.'">
                        <button class="notif_job_btn popup_button check_button accept_yooz_form_btn">متوجه شدم</button>
                    </div>
                </div>
            </li>';
        }
    }
    
    
    $content .= '</ul>';
    
    return $content;
}