<?php
use Core\Utils;

function get_friends($friends){
    $output = '';
    if(!empty($friends) && is_array($friends)){
        foreach ($friends as $friend){
            $name = !empty($friend['display_name']) ? $friend['display_name'] : "بدون نام";
            $image = !empty($friend['profile_image_file']) ? $friend['profile_image_file'] : "/public/uploads/emptyUser.jpg";
            if(!empty($friend['phone'])){
                $phone = substr_replace(strval($friend['phone']), '*****', 4, 5);
                $phone = \Core\Utils::PersianNumber($phone);
            }else{
                $phone = "";
            }
            $output .= '
                <li class="user_friend_item flexBox game_box">
                    <section class="user_friend_image">
                        <div class="user_friend_thumbnail">
                            <img src="'.$image.'" alt="'.$name.'">
                        </div>
                    </section>
                    <section class="user_friend_info">
                        <p class="user_friend_name">'.$name.'</p>
                        <p class="user_friend_score">'.$phone.'</p>
                    </section>
                </li>
            ';
        }
    }else{
        $output .= '<p class="no_friend_message">هنوز هیچ دوستی در بازی نداری</p>';
    }
    return $output;
}