<?php
namespace App\Models;
use Core\ErrorsTrait;
use Core\Model;
use Plugins\Yooz_Manager\Yooz_Manager_Utils;

class Missions_Model extends Model{
    use ErrorsTrait;
    private $missions_table = "yooz_game_missions";
    public function get_mission_by_id(int $mission_ID){
        $response = false;
        $result = $this->db->select($this->missions_table , "*" , "mission_ID='$mission_ID'");
        if($result && $result->rowCount() > 0){
            $response = $result->fetch();
            $image = Yooz_Manager_Utils::get_file_by_id($response['mission_image_id']);
            $response['image_url'] = $image && !empty($image['file_url']) ? $image['file_url'] : "/public/uploads/emptyImage.jpg";
        }
        return $response;
    }
    public function get_missions(){
        $response = false;
        $result = $this->db->select($this->missions_table , "*");
        if($result && $result->rowCount() > 0){
            $response = $result->fetchAll();
        }
        return $response;
    }
    public function get_missions_ui(){
        require_once __DIR__."/../Views/Admin/template-parts/game_coins/mission_item.php";
        $mission_items = $this->get_missions();
        $mission_items = $mission_items && is_array($mission_items) ? $mission_items : [];
        return get_game_missions($mission_items);
    }

    public function delete_mission_item(int $mission_ID){
        $result = $this->db->delete($this->missions_table , "mission_ID='$mission_ID'");
        return (bool)$result;
    }

    public function add_mission($id , $title , $description, $button_label , $button_link ,  $coins , $bg_color , $image_id , $status){
        $data = [
            'mission_title'         => $title,
            'mission_description'   => $description,
            'mission_button_label'  => $button_label,
            'mission_button_link'   => $button_link,
            'mission_coins'         => $coins,
            'mission_bg_color'      => $bg_color,
            'mission_image_id'      => $image_id,
            'display_status'        => $status,
        ];
        if($id == 0){
            $mission = $this->db->select($this->missions_table , "*" , "mission_title='$title'");
            if($mission->rowCount() > 0){
                $this->set_error("نام ماموریت تکراری است. لطفا از نام دیگری استفاده کنید.");
                return false;
            }else{
                return $this->db->insert($this->missions_table , $data);
            }
        }
        if($id > 0){
            return $this->db->update($this->missions_table , $data , "mission_ID='$id'");
        }
        return false;
    }
}