<?php
namespace App\Models;

use Core\JDate;
use Core\Model;

class Lottery_Model extends Model{
    public function get_all_players(): array
    {
        $usersModel = new UserModel();
        $users = $usersModel->get_players();
        return $users && is_array($users) ? $users : [];
    }
    public function get_all_users(): array
    {
        $usersModel = new UserModel();
        $users = $usersModel->get_users();
        return $users && is_array($users) ? $users : [];
    }

    public function get_all_medalists(): array
    {
        $usersModel = new UserModel();
        $gameModel = new Game_Model();
        $users = [];
        $query = "SELECT * FROM
                     $usersModel->users_table users
                  INNER JOIN
                     $gameModel->user_medals_table medals
                  ON users.user_ID=medals.user_ID";
        $result = $this->db->query($query);
        if($result && $result->rowCount() > 0){
            $users = $result->fetchAll();
        }
        return $users;
    }

    public function get_last_month_medalists(): array
    {
        $currentJalali = JDate::date('Y-n-j');
        // Split the current Jalali date into year, month, and day
        list($year, $month, $day) = explode('-', $currentJalali);
        // Calculate the previous month
        if($month == 1){
            // If the current month is Farvardin (1), go back to Esfand (12) of the previous year
            $prevMonthYear = $year - 1;
            $prevMonthMonth = 12;
        }else{
            // Otherwise, just subtract one from the current month
            $prevMonthYear = $year;
            $prevMonthMonth = $month - 1;
        }
        $startOfPrevMonth = JDate::to_greg_date($prevMonthYear , $prevMonthMonth , 1 , 0 , 0 , 0);
        $endOfPrevMonth = JDate::to_greg_date($year , $month , 1 , 0 , 0 , 0);

        $usersModel = new UserModel();
        $gameModel = new Game_Model();
        $users = [];
        $query = "SELECT * FROM
                     $usersModel->users_table users
                  INNER JOIN
                     $gameModel->user_medals_table medals
                  ON users.user_ID=medals.user_ID
                  WHERE medals.medal_achieve_date < '$endOfPrevMonth' AND medals.medal_achieve_date > '$startOfPrevMonth'";
        $result = $this->db->query($query);
        if($result && $result->rowCount() > 0){
            $users = $result->fetchAll();
        }
        return $users;
    }

    public function get_users_with_gift(int $gift_ID): array{
        $usersModel = new UserModel();
        $gameModel = new Game_Model();
        $users = [];
        $query = "SELECT * FROM
                    $usersModel->users_table users
                  INNER JOIN
                    $gameModel->user_gifts_table gifts
                  ON users.user_ID=gifts.user_ID
                  WHERE gifts.gift_ID='$gift_ID'";
        $result = $this->db->query($query);
        if($result && $result->rowCount() > 0){
            $users = $result->fetchAll();
        }
        return $users;
    }

    public function draw(array $users){
        $users_number = [];
        foreach ($users as $user){
            if(!empty($user['phone']) && !empty($user['user_register_date'])){
                $users_number[] = $user['phone'];
            }
        }

        if(count($users_number) > 0){
            return $users_number[array_rand($users_number)];
        }
        return false;
    }

}