<?php
namespace App\Models;
use Core\ErrorsTrait;
use Core\Model;
use Plugins\Yooz_Manager\Yooz_Manager_Utils;

class Guess_Model extends Model{
    use ErrorsTrait;
    private $guess_table = "yooz_guess_codes";
    public function get_guess_by_id(int $guess_ID){
        $response = false;
        $result = $this->db->select($this->guess_table , "*" , "guess_ID='$guess_ID'");
        if($result && $result->rowCount() > 0){
            $response = $result->fetch();
            $image = Yooz_Manager_Utils::get_file_by_id($response['guess_image_id']);
            $response['image_url'] = $image && !empty($image['file_url']) ? $image['file_url'] : "/public/uploads/emptyImage.jpg";
        }
        return $response;
    }
    public function get_guesses(){
        $response = false;
        $result = $this->db->select($this->guess_table , "*");
        if($result && $result->rowCount() > 0){
            $response = $result->fetchAll();
        }
        return $response;
    }
    public function get_guesses_ui(){
        require_once __DIR__."/../Views/Admin/template-parts/game_coins/guess_item.php";
        $guess_items = $this->get_guesses();
        $guess_items = $guess_items && is_array($guess_items) ? $guess_items : [];
        return get_guess_items($guess_items);
    }

    public function delete_guess_item(int $guess_ID){
        $result = $this->db->delete($this->guess_table , "guess_ID='$guess_ID'");
        return (bool)$result;
    }

    public function add_guess($id , $code , $description , $fine_coins ,  $gift_coins , $image_id , $expire_date , $status){
        $data = [
            'guess_code'            => $code,
            'guess_description'     => $description,
            'fine_coins'            => $fine_coins,
            'gift_coins'            => $gift_coins,
            'guess_image_id'        => $image_id,
            'expiration_date'       => $expire_date,
            'display_status'        => $status,
        ];
        if($id == 0){
            $guess = $this->db->select($this->guess_table , "*" ,
                "guess_code='$code' AND guess_description='$description' AND fine_coins='$fine_coins' AND gift_coins='$gift_coins'");
            if($guess->rowCount() > 0){
                $this->set_error("این آیتم قبلا ایجاد شده است.");
                return false;
            }else{
                return $this->db->insert($this->guess_table , $data);
            }
        }
        if($id > 0){
            return $this->db->update($this->guess_table , $data , "guess_ID='$id'");
        }
        return false;
    }
}