<?php
namespace App\Models;
use Core\ErrorsTrait;
use Core\JDate;
use Core\Model;
use Core\Site_Options;
use Plugins\Yooz_Manager\Yooz_Manager_Utils;

class Game_Model extends Model {
    use ErrorsTrait;
    public string $gift_table = "yooz_game_gifts";
    public string $guess_table = "yooz_guess_codes";
    public string $events_table = "yooz_game_events";
    public string $missions_table = "yooz_game_missions";
    public string $cards_table = "yooz_game_cards";
    public string $user_medals_table = "yooz_user_medals";
    public string $user_coins_table = "yooz_user_coins";
    public string $user_guess_table = "yooz_user_guess";
    public string $user_events_table = "yooz_user_events";
    public string $user_gifts_table = "yooz_user_gifts";
    public string $user_missions_table = "yooz_user_missions";
    public string $user_cards_table = "yooz_user_cards";
    public string $user_daily_table = "yooz_user_daily";
    private string $notification_table = "yooz_user_notifications";


    public static function prev_month_date(): string
    {
        $currentDay = JDate::date("d");
        return date("Y-m-d" , strtotime("-".intval($currentDay)." days"));
    }
    public function yearly_recount_ranking(): void
    {
        $currentYear = JDate::date("Y");
        $lastRecount = Site_Options::get("last_recount_ranking_year");
        if(!empty($lastRecount) && is_numeric($lastRecount)){
            $lastRecountYear = $lastRecount;
        }else{
            $lastRecountYear = 0;
        }

        if($currentYear !== $lastRecountYear){
            $userModel = new UserModel();
            $result = $this->db->update($userModel->users_table , ['total_score'=>"0"]);
            if($result){
                Site_Options::update("last_recount_ranking_year" , $currentYear);
            }
        }
    }

    public function get_user(): bool|array
    {
        $userModel = new UserModel();
        $user = $userModel->get_current_user();
        if($user && is_array($user)){
            return $this->set_user_game_details($user);
        }
        return false;
    }

    public function set_user_game_details(array $user , bool $full_data = false): array
    {
        $user_ID = $user['user_ID'];
        /* add user gifts,missions,guess and etc */
        $user['medals_number'] = $this->get_user_medals($user_ID);
        $user['this_year_medals_number'] = $this->get_user_this_year_medals($user_ID);
        $user['coins_number'] = $this->get_user_coins($user_ID);
        $user['positive_coins_number'] = $this->get_user_coins($user_ID , true);
        $user['guess'] = $this->get_user_guess("user_ID='$user_ID'" , $full_data);
        $user['events'] = $this->get_user_events("user_ID='$user_ID'" , $full_data);
        $user['gifts'] = $this->get_user_gifts("user_ID='$user_ID'" , $full_data);
        $user['missions'] = $this->get_user_missions("user_ID='$user_ID'" , $full_data);
        $user['cards'] = $this->get_user_cards("user_ID='$user_ID'", "" , $full_data);
        $user['friends'] = $this->get_user_friends($user_ID);
        $user['notifications'] = $this->get_user_notifications("user_ID='$user_ID' ORDER BY `notification_status` ASC,`create_time` DESC");
        return $user;
    }


    public function get_user_friends(int $user_ID): bool|array
    {
        $userModel = new UserModel();
        $friends = $userModel->get_users("inviter_ID='$user_ID'");
        if($friends && is_array($friends)){
            return $friends;
        }
        return false;
    }

    public function get_user_medals(int $user_ID){
        $result = $this->db->select($this->user_medals_table , "COUNT(*)" , "user_ID='$user_ID' AND medal_achieve_date > '".$this->prev_month_date()."'");
        if($result && $result->rowCount() > 0){
            return $result->fetch()['COUNT(*)'];
        }
        return 0;
    }
    public function get_user_this_year_medals(int $user_ID){
        $currentYear = JDate::date("Y");
        $startOfYearDate = JDate::to_greg_date($currentYear , 1, 1 ,0, 0 , 0);
        $result = $this->db->select($this->user_medals_table , "COUNT(*)" , "user_ID='$user_ID' AND medal_achieve_date > '$startOfYearDate'");
        if($result && $result->rowCount() > 0){
            return $result->fetch()['COUNT(*)'];
        }
        return 0;
    }

    public function get_user_coins(int $user_ID , bool $positive_coins = false) : int
    {
        /* delete the previous period coins of users*/
        $this->db->delete($this->user_coins_table , "coins_achieve_time < '".$this->prev_month_date()."'");
        $positiveCoinsCond = $positive_coins ? " AND get_coins > 0" : "";
        $result = $this->db->select($this->user_coins_table , "SUM(get_coins)" , "user_ID='$user_ID'".$positiveCoinsCond);
        if($result && $result->rowCount() > 0){
            $coins = $result->fetch()['SUM(get_coins)'];
            if(is_numeric($coins)){
                return intval(abs($coins));
            }
        }
        return 0;
    }

    public function get_user_guess(string $where_clause = "" , bool $full_data = false): bool|array
    {
        /* delete the previous period guess of users */
        $this->db->delete($this->user_guess_table , "guess_claim_time < '".$this->prev_month_date()."'");
        return $this->get_user_data_results(
            $this->user_guess_table, $this->guess_table, 'guess_ID',
            $where_clause, "", $full_data
        );
    }

    public function set_guess_to_user($user_ID , $guess_ID , $gift_coins): void
    {
        $this->db->insert($this->user_guess_table , [
            'user_ID'               => $user_ID,
            'guess_ID'              => $guess_ID,
            'guess_claim_coins'     => $gift_coins,
            'guess_claim_time'      => date("Y-m-d H:i:s"),
        ]);
        $this->set_coins_to_user($user_ID , $gift_coins);
    }

    public function get_user_events(string $where_clause , bool $full_data = false): bool|array
    {
        /* delete the previous period events of users */
        $this->db->delete($this->user_events_table , "claim_event_time < '".$this->prev_month_date()."'");
        return $this->get_user_data_results(
            $this->user_events_table, $this->events_table, 'event_ID',
            $where_clause, "", $full_data
        );
    }

    public function set_event_to_user(int $user_ID , array $event): void{
        $event_ID = $event['event_ID'];
        $required_coins = !empty($event['required_coins']) ? $event['required_coins'] : 0;
        $this->db->insert($this->user_events_table , [
            'user_ID'               => $user_ID,
            'event_ID'              => $event_ID,
            'event_spent_coins'     => $required_coins,
            'claim_event_time'      => date("Y-m-d H:i:s"),
            'event_usage_status'    => "unused",
        ]);
        $this->set_coins_to_user($user_ID , ($required_coins * -1));
        $data = [
            'user_ID'               => $user_ID,
            'notification_title'    => $event['event_title'],
            'notification_text'     => $event['event_description'],
            'notification_image'    => !empty($event['event_image_id']) ? $this->get_images(intval($event['event_image_id'])) : "",
            'notification_status'   => "no_visited",
            'create_time'           => date("Y-m-d H:i:s"),
        ];
        $this->db->insert($this->notification_table , $data);
    }
    public function set_user_event_status(string $where_clause , string $status): bool
    {
        return $this->db->update($this->user_events_table , ['event_usage_status'=>$status] , $where_clause);
    }

    public function get_user_gifts(string $where_clause , bool $full_data = false): bool|array
    {
        /* delete the previous period gifts of users */
        $this->db->delete($this->user_gifts_table , "claim_gift_time < '".$this->prev_month_date()."'");
        return $this->get_user_data_results(
            $this->user_gifts_table, $this->gift_table, 'gift_ID',
            $where_clause, "", $full_data
        );
    }
    public function set_gift_to_user(int $user_ID , int $gift_ID , int $required_coins , string $giftExpire , string $gift_name , string $gift_claim_message): void{
        $this->db->insert($this->user_gifts_table , [
            'user_ID'               => $user_ID,
            'gift_ID'               => $gift_ID,
            'gift_spent_coins'      => $required_coins,
            'claim_gift_time'       => date("Y-m-d H:i:s"),
            'gift_expire'           => $giftExpire,
            'gift_usage_status'     => 'unused',
        ]);
        
        $notifData = [
        'user_ID'          => $user_ID,
        'message_title'    => $gift_name,
        'message_text'     => $gift_claim_message,
        ];

        $this->set_notification($notifData);
        
        $this->set_coins_to_user($user_ID , ($required_coins * -1));
        $this->set_user_scores($user_ID , "gift");
    }
    public function set_user_gift_status(string $where_clause , string $status): bool
    {
        return $this->db->update($this->user_gifts_table , ['gift_usage_status'=>$status] , $where_clause);
    }
    public function get_user_missions(string $where_clause , bool $full_data = false): bool|array
    {
        return $this->get_user_data_results(
            $this->user_missions_table, $this->missions_table, 'mission_ID',
            $where_clause, "", $full_data
        );
    }

    public function set_mission_to_user(int $user_ID , int $mission_ID , int $required_coins , string $status): void
    {
        $check = $this->db->select($this->user_missions_table , "*" , "user_ID='$user_ID' AND mission_ID='$mission_ID'");
        if($check && $check->rowCount() > 0){
            $this->db->update($this->user_missions_table , [
                'mission_claim_time'    => date("Y-m-d H:i:s"),
                'claim_status'          => $status,
            ] , "user_ID='$user_ID' AND mission_ID='$mission_ID'");
        }else{
            $this->db->insert($this->user_missions_table , [
                'user_ID'               => $user_ID,
                'mission_ID'            => $mission_ID,
                'mission_claim_coins'   => $required_coins,
                'mission_claim_time'    => date("Y-m-d H:i:s"),
                'claim_status'          => $status,
            ]);
        }

        if($status == "claimed"){
            $this->set_coins_to_user($user_ID , $required_coins);
            $this->set_user_scores($user_ID , "mission");
        }
    }

    public function get_user_cards(string $where_clause = "", string $limit = "" , bool $full_data = false): bool|array
    {
        /* delete the previous period cards of users */
        $this->db->delete($this->user_cards_table , "card_claim_time < '".$this->prev_month_date()."'");
        return $this->get_user_data_results(
            $this->user_cards_table, $this->cards_table, 'card_ID',
            $where_clause, $limit, $full_data
        );
    }
    public function set_card_to_user(int $user_ID , int $card_ID , int $required_coins): void{
        $this->db->insert($this->user_cards_table , [
            'user_ID'               => $user_ID,
            'card_ID'               => $card_ID,
            'card_claim_coins'      => $required_coins,
            'card_claim_time'       => date("Y-m-d H:i:s"),
        ]);
        $this->set_coins_to_user($user_ID , $required_coins);
    }

    public function get_user_data_results(string $user_data_table , string $data_table , string $id_column , string $where_clause = "", string $limit = "" ,bool $full_data = false): bool|array
    {
        if($full_data){
            $query = "SELECT * FROM
                        $user_data_table userDataTable
                      INNER JOIN
                        $data_table dataTable
                      ON dataTable.$id_column=userDataTable.$id_column";
            $query .= !empty($where_clause) ? " WHERE ".$where_clause : "";
            $query .= !empty($limit) ? " LIMIT ".$limit : "";
            $result = $this->db->query($query);
        }else{
            $result = $this->db->select($user_data_table , "*" , $where_clause , $limit);
        }
        if($result && $result->rowCount() > 0){
            $records = [];
            while ($row = $result->fetch()){
                $records[$row[$id_column]] = $row;
            }
            return $records;
        }
        return false;
    }
    public function get_daily_views(string $where_clause = "", string $limit = ""): bool|array
    {
        /* delete the previous period cards of users */
        $this->db->delete($this->user_daily_table , "daily_last_claim < '".$this->prev_month_date()."'");
        $result = $this->db->select($this->user_daily_table , "*" , $where_clause , $limit);
        if($result && $result->rowCount() > 0){
            return $result->fetchAll();
        }
        return false;
    }
    public function set_daily_view_to_user(int $user_ID , int $daily_gift): void{
        $this->db->insert($this->user_daily_table , [
            'user_ID'               => $user_ID,
            'daily_claim_coins'      => $daily_gift,
            'daily_last_claim'       => date("Y-m-d"),
        ]);
        $this->set_coins_to_user($user_ID , $daily_gift);
    }

    public function set_coins_to_user(int $user_ID , int $coins_number): void
    {
        $this->db->insert($this->user_coins_table , [
            'user_ID'           => $user_ID,
            'get_coins'         => $coins_number,
            'coins_achieve_time'=> date("Y-m-d H:i:s"),
        ]);
        $this->update_user_medals($user_ID);
    }
    public function set_user_scores(int $user_ID , string $score_type , int $number = 1): void
    {
        $score_System = Site_Options::get("_app_score_system");
        $score_System = !empty($score_System) && is_array(unserialize($score_System)) ? unserialize($score_System) : [];


        $score = 1;
        if($score_type == "invitation"){
            $score = !empty($score_System['invitation_score']) ? intval($score_System['invitation_score']) : 1;
        }elseif($score_type == "medal"){
            $score = !empty($score_System['medal_score']) ? intval($score_System['medal_score']) : 1;
        }elseif($score_type == "gift"){
            $score = !empty($score_System['gift_card_score']) ? intval($score_System['gift_card_score']) : 1;
        }elseif($score_type == "mission"){
            $score = !empty($score_System['mission_score']) ? intval($score_System['mission_score']) : 1;
        }

        if($score > 0){
            $score = $score * $number;
            $userModel = new UserModel();
            $stmt = $this->db->prepare("UPDATE $userModel->users_table SET total_score = total_score + $score WHERE user_ID= :user_ID");
            $stmt->bindParam(':user_ID', $user_ID, \PDO::PARAM_INT);
            $stmt->execute();
        }
    }

    public function update_user_medals(int $user_ID): void
    {
        $medalSettings = $this->get_medal_settings();
        $userCoins = $this->get_user_coins($user_ID , true);
        $userMedals = $this->get_user_medals($user_ID);
        if(!empty($medalSettings) && is_array($medalSettings) && !empty($medalSettings['get_medal_needed_coins'])){
            if($userCoins >= $medalSettings['get_medal_needed_coins'] && empty($userMedals)){
                $this->db->insert($this->user_medals_table , [
                        'user_ID'               => $user_ID,
                        'medal_achieve_date'    => date("Y-m-d H:i:s"),
                    ]);
                $notifData = [
                    'user_ID'          => $user_ID,
                    'message_title'    => 'دریافت مدال',
                    'message_text'     => $medalSettings['medal_win_descriptions'],
                    'notification_image'     => $medalSettings['medal_win_image_file'],
                ];
                $this->set_notification($notifData);

                $this->set_user_scores($user_ID , "medal" , 1);
            }
        }
    }

    public function get_user_updated_data(int $user_ID): array
    {
        $data = [];
        $data['medals'] = $this->get_user_medals($user_ID);
        $data['this_year_medals'] = $this->get_user_this_year_medals($user_ID);
        $data['coins'] = $this->get_user_coins($user_ID);
        $data['positive_coins'] = $this->get_user_coins($user_ID , true);
        $notifs = $this->get_user_notifications("user_ID='$user_ID' ORDER BY `notification_status` ASC, `create_time` DESC");
        require_once __DIR__."/notif_temp.php";
        $notif_num = 0;
        if(!empty($notifs) && is_array($notifs)){
            foreach($notifs as $notif){
                if($notif['notification_status'] == "no_visited"){
                    $notif_num++;
                }
            }
            $data['notifs_number'] = $notif_num;
            $data['notif_template'] = get_notifs($notifs);
        }else{
            $data['notifs_number'] = 0;
        }

        return $data;
    }

    public function get_user_rankings($userRank): array {
        require_once __DIR__."/ranking_temp.php";
        $data = [];
        if(!empty($userRank['your_position'])){
            $data['your_rank'] = \Core\Utils::PersianNumber($userRank['your_position']);
        }
        if(!empty($userRank['top_players']) && is_array($userRank['top_players'])){
            $data['top_players'] = get_rankings($userRank['top_players']);
        }
        return $data;
    }

    public function get_friends_list(array $friends): array {
        require_once __DIR__."/friends_temp.php";
        $data = [];
        if(!empty($friends) && is_array($friends)){
            $data['friends'] = get_friends($friends);
        }
        return $data;
    }

    public function get_cards_list(array $user): string {
        require_once __DIR__.'/cards_temp.php';
        $cards = $this->get_cards();
        $data = '';
        if(!empty($cards) && is_array($cards)){
            $data = get_cards_template($cards, $user);
        }
        return $data;
    }

    public function check_user_birthdate_messages(){
        $user = $this->get_user();
        if(!empty($user) && is_array($user)){
            $user_ID = $user['user_ID'];
            if(!empty($user['birthdate'])){
                $birthGift = 0;
                $rules = Site_Options::get("_yooz_main_game_rules");
                if($rules && is_array(unserialize($rules))){
                    $rules = unserialize($rules);
                    if(!empty($rules['birthdate_gift'])){
                        $birthGift = intval($rules['birthdate_gift']);
                    }
                }
                $birthMessage = Site_Options::get("birthdate_message_notif");
                if(!empty($birthMessage)){
                    $birthTitle = '"تولدتان مبارک باد"';
                    $userBirthTime = strtotime($user['birthdate']);
                    $currentDay = date("d");
                    $currentMonth = date("m");
                    $userBirthDay = date("d" , $userBirthTime);
                    $userBirthMonth = date("m" , $userBirthTime);
                    if($currentDay == $userBirthDay && $currentMonth == $userBirthMonth){
                        $lastMonth = strtotime("-1 months");
                        $lastBirthNotif = $this->get_user_notifications("user_ID='$user_ID' AND notification_title='$birthTitle' AND notification_text='$birthMessage' AND create_time > ".$lastMonth);
                        if(!$lastBirthNotif || count($lastBirthNotif) <= 0){

                            $data = [
                                'user_ID'               => $user_ID,
                                'notification_title'    => $birthTitle,
                                'notification_text'     => $birthMessage,
                                'notification_coins'    => $birthGift,
                                'notification_status'   => "no_visited",
                                'create_time'           => date("Y-m-d H:i:s"),
                            ];

                            $this->db->insert($this->notification_table , $data);
                        }
                    }
                }
            }
        }
    }

    public function set_user_register_messages(int $user_ID){
        $registerGift = 0;
        $rules = Site_Options::get("_yooz_main_game_rules");
        if($rules && is_array(unserialize($rules))){
            $rules = unserialize($rules);
            if(!empty($rules['registration_gift'])){
                $registerGift = intval($rules['registration_gift']);
            }
        }
        
        $welcomeMessage = Site_Options::get("welcome_message_notif");
        if(empty($welcomeMessage)){
            if(!empty($registerGift)){
                $welcomeMessage = "خوش آمدید. به منظور قدردانی از همراهی شما و ایجاد حساب کاربری در این بازی، ".$registerGift." سکه هدیه به حساب کاربری شما واریز شد.";
            }
            
        }
        
        if(!empty($welcomeMessage)){
            $data = [
            'user_ID'               => $user_ID,
            'notification_title'    => 'خوش آمدید',
            'notification_text'     => $welcomeMessage,
            'notification_coins'    => $registerGift,
            'notification_status'   => "no_visited",
            'create_time'           => date("Y-m-d H:i:s"),
        ];

        $this->db->insert($this->notification_table , $data);
        }
    }

    public function get_user_notifications(string $where_clause): array
    {
        $records = [];
        $result = $this->db->select($this->notification_table , "*" , $where_clause);
        if($result && $result->rowCount() > 0){
            $withoutID = 0;
            while($row = $result->fetch()){
                if($row['message_ID'] == 0){
                    $withoutID--;
                }
                $id = $row['message_ID'] > 0 ? $row['message_ID'] : $withoutID;
                $records[$id] = $row;
            }
        }
        return $records;
    }

    public function set_notification(array $data): bool
    {
        $data = [
            'user_ID'               => !empty($data['user_ID']) && is_numeric($data['user_ID']) ? intval($data['user_ID']) : 0,
            'message_ID'            => !empty($data['message_ID']) && is_numeric($data['message_ID']) ? intval($data['message_ID']) : 0,
            'notification_title'    => !empty($data['message_title']) ? $data['message_title'] : "",
            'notification_text'     => !empty($data['message_text']) ? $data['message_text'] : "",
            'notification_image'    => !empty($data['notification_image']) ? $data['notification_image'] : "",
            'notification_coins'    => !empty($data['gift_coins']) && is_numeric($data['gift_coins']) ? intval($data['gift_coins']) : 0,
            'notification_status'   => !empty($data['notification_status']) ? $data['notification_status'] : "no_visited",
            'create_time'           => !empty($data['create_time']) ? $data['create_time'] : date("Y-m-d H:i:s"),
        ];
        return boolval($this->db->insert($this->notification_table , $data));
    }

    public function set_notification_visited(int $id): void
    {
        $this->db->update($this->notification_table , ["notification_status" => "visited"] , "notification_ID='$id'");
    }

    public function get_medal_settings(){
        $data = Site_Options::get("_yooz_game_medal_rules");
        if(!empty($data) && is_array(unserialize($data))){
            $medal = unserialize($data);
            $image = $this->get_images(intval($medal['medal_cond_image']));
            $medal["medal_cond_image_file"] = !empty($image) ? $image : "/public/uploads/default_medal_image.png";
            $medal["medal_win_image_file"] = $this->get_images(intval($medal['medal_win_image']));
            return $medal;
        }
        return false;
    }
    public function get_guess(){
        $result = $this->db->select($this->guess_table , "*" , "display_status='yes' AND expiration_date >= NOW() ORDER BY guess_ID DESC" , "1");
        if($result && $result->rowCount() > 0){
            $guess = $result->fetch();
            $image = $this->get_images(intval($guess['guess_image_id']));
            $guess["guess_image"] = !empty($image) ? $image : "";
            return $guess;
        }
        return false;
    }

    public function get_events(): bool|array
    {
        $result = $this->db->select($this->events_table , "*" , "event_status='yes' AND event_expire >= NOW() ORDER BY event_ID DESC");
        if($result && $result->rowCount() > 0){
            $events = $result->fetchAll();
            $records = [];
            foreach ($events as $event){
                $image = $this->get_images(intval($event['event_image_id']));
                $event["event_image"] = !empty($image) ? $image : "/public/uploads/default_event_image.png";
                $records[$event['event_ID']] = $event;
            }
            return $records;
        }
        return false;
    }

    public function get_gift_cards(): bool|array
    {
        $result = $this->db->select($this->gift_table , "*" , "gift_status='yes'");
        if($result && $result->rowCount() > 0){
            $records = [];
            while($row = $result->fetch()){
                $image = $this->get_images(intval($row['gift_image_id']));
                $row['gift_image_file'] = !empty($image) ? $image : "/public/uploads/default_gift_image.png";
                $records[$row['gift_ID']] = $row;
            }
            return $records;
        }
        return false;
    }

    public function get_missions(): bool|array
    {
        $result = $this->db->select($this->missions_table , "*" , "display_status='yes'");
        if($result && $result->rowCount() > 0){
            $records = [];
            while($row = $result->fetch()){
                $image = $this->get_images(intval($row['mission_image_id']));
                $row['mission_image_file'] = !empty($image) ? $image : "/public/uploads/default_mission_image.png";
                $records[$row['mission_ID']] = $row;
            }
            return $records;
        }
        return false;
    }

    public function get_cards(): bool|array
    {
        $result = $this->db->select($this->cards_table , "*" , "display_status='yes'");
        if($result && $result->rowCount() > 0){
            $records = [];
            while($row = $result->fetch()){
                $image = $this->get_images(intval($row['card_image_id']));
                $row['card_image_file'] = !empty($image) ? $image : "/public/uploads/default_card_image.png";
                $records[$row['card_ID']] = $row;
            }
            return $records;
        }
        return false;
    }

    private function get_images(int $imageID){
        $file = Yooz_Manager_Utils::get_file_by_id($imageID);
        return !empty($file) && is_array($file) && !empty($file['file_url']) ? $file['file_url'] : "";
    }

    private string $city_table = "city";
    public function get_provinces(): array
    {
        $result = $this->db->select($this->city_table , "DISTINCT province , province_ID");
        $response = [0 => 'انتخاب استان'];
        if($result && $result->rowCount() > 0){
            while($row = $result->fetch()){
                $response[$row['province_ID']] = $row['province'];
            }
        }
        return $response;
    }
    public function get_cities_of_province(int $province_ID): array
    {
        $response = [];
        if($province_ID > 0){
            $result = $this->db->select($this->city_table , "*" , "province_id='$province_ID'");
            if($result && $result->rowCount() > 0){
                while($row = $result->fetch()){
                    $response[$row['id']] = $row['city'];
                }
            }
        }
        return $response;
    }
}