<?php
namespace App\Models;
use Core\ErrorsTrait;
use Core\Model;
use Plugins\Yooz_Manager\Yooz_Manager_Utils;

class Events_Model extends Model{
    use ErrorsTrait;
    private string $table_name = "yooz_game_events";
    public function get_event_by_id(int $id){
        $response = false;
        $result = $this->db->select($this->table_name , "*" , "event_ID='$id'");
        if($result && $result->rowCount() > 0){
            $response = $result->fetch();
            $image = Yooz_Manager_Utils::get_file_by_id($response['event_image_id']);
            $response['image_url'] = $image && !empty($image['file_url']) ? $image['file_url'] : "/public/uploads/default_event_image.png";
        }
        return $response;
    }

    public function get_events(){
        $response = false;
        $result = $this->db->select($this->table_name , "*");
        if($result && $result->rowCount() > 0){
            $response = $result->fetchAll();
        }
        return $response;
    }
    public function get_events_ui(){
        require_once __DIR__."/../Views/Admin/template-parts/game_gifts/event_item.php";
        $items = $this->get_events();
        $items = $items && is_array($items) ? $items : [];
        return get_event_items($items);
    }

    public function delete_event_item(int $event_ID): bool
    {
        $result = $this->db->delete($this->table_name , "event_ID='$event_ID'");
        return (bool)$result;
    }

    public function add_event($id,$title, $name,$description,$required_coins ,$expire_time,$image_id,$status){
        $data = [
            'event_title'       => $title,
            'event_name'        => $name,
            'event_description' => $description,
            'required_coins'    => $required_coins,
            'event_expire'      => $expire_time,
            'event_image_id'    => $image_id,
            'event_status'      => $status,
        ];
        if($id == 0){
            $card = $this->db->select($this->table_name , "*" , "event_name='$name'");
            if($card->rowCount() > 0){
                $this->set_error("نام رویداد تکراری است. لطفا از نام دیگری استفاده کنید.");
                return false;
            }else{
                return $this->db->insert($this->table_name , $data);
            }
        }
        if($id > 0){
            return $this->db->update($this->table_name , $data , "event_ID='$id'");
        }
        return false;
    }
}