<?php
namespace App\Models;
use Core\Model;
use Plugins\Yooz_Manager\Yooz_Manager_Utils;

class Cards_Model extends Model{
    private $cards_table = "yooz_game_cards";
    public function get_card_by_id(int $card_ID){
        $response = false;
        $result = $this->db->select($this->cards_table , "*" , "card_ID='$card_ID'");
        if($result && $result->rowCount() > 0){
            $response = $result->fetch();
            $image = Yooz_Manager_Utils::get_file_by_id($response['card_image_id']);
            $response['image_url'] = $image && !empty($image['file_url']) ? $image['file_url'] : "/public/uploads/emptyImage.jpg";
        }
        return $response;
    }
    public function get_cards(){
        $response = false;
        $result = $this->db->select($this->cards_table , "*");
        if($result && $result->rowCount() > 0){
            $response = $result->fetchAll();
        }
        return $response;
    }
    public function get_cards_ui(){
        require_once __DIR__."/../Views/Admin/template-parts/game_coins/card_item.php";
        $card_items = $this->get_cards();
        $card_items = $card_items && is_array($card_items) ? $card_items : [];
        $gameCards = get_game_cards($card_items);
        return $gameCards;
    }

    public function delete_card_item(int $card_ID){
        $result = $this->db->delete($this->cards_table , "card_ID='$card_ID'");
        return (bool)$result;
    }

    public function add_card($id , $name , $text , $title , $description, $coins , $bg_color , $recharge_time , $recharge_timing , $image_id , $status){
        $data = [
            'card_name'         => $name,
            'card_text'         => $text,
            'card_title'        => $title,
            'card_description'  => $description,
            'card_coins'        => $coins,
            'card_bg_color'     => $bg_color,
            'recharge_time'     => $recharge_time,
            'recharge_timing'    => $recharge_timing,
            'card_image_id'     => $image_id,
            'display_status'    => $status,
        ];
        if($id == 0){
            $card = $this->db->select($this->cards_table , "*" , "card_name='$name'");
            if($card->rowCount() > 0){
                $this->set_error("نام کارت تکراری است. لطفا از نام دیگری استفاده کنید.");
                return false;
            }else{
                return $this->db->insert($this->cards_table , $data);
            }
        }
        if($id > 0){
            return $this->db->update($this->cards_table , $data , "card_ID='$id'");
        }
        return false;
    }
}