<?php
namespace App\Controllers\Website;
use App\Models\Game_Model;
use App\Models\UserModel;
use Core\Controller;
use Core\ErrorsTrait;
use Core\JDate;
use Core\Site_Options;
use Core\User_Forms;
use Core\Utils;


class Game_Controller extends Controller{
    use ErrorsTrait;
    private $user;
    public function index(){
        $model = new Game_Model();
        $model->check_user_birthdate_messages();
        $model->yearly_recount_ranking();

        $user = $model->get_user();
        if(!empty($user) && is_array($user)){
            $data = [
                'page_title'    => "بازی",
                'user'          => $user,
                'guess'         => $model->get_guess(),
                'events'        => $model->get_events(),
                'medal_setting' => $model->get_medal_settings(),
                'gifts'         => $model->get_gift_cards(),
                'missions'      => $model->get_missions(),
                'cards'         => $model->get_cards(),
                'provinces'     => $model->get_provinces(),
            ];
            if(!empty($user['province_id'])){
                $data['cities'] = $model->get_cities_of_province(intval($user['province_id']));
            }
            $this->view->render("game" , $data , false);
        }else{
            //header user to login page
            header("Location: ".LOGIN_PAGE);
        }
    }

    public function ajax_response(string $action){
        $response = [];
        $method_name = $action."_ajax";
        if(method_exists(self::class , $method_name)){
            $model = new Game_Model();
            $user = $model->get_user();
            if($user && is_array($user) && !empty($user['user_ID'])){
                $this->user = $user;
                $response = $this->$method_name();
            }
        }
        if($this->has_error()){
            $response = ['response_type'=>'error' , 'message'=>$this->get_errors_text("<br>")];
        }
        return $response;
    }

    private function get_data_ajax()
    {
        $response = [];
        if(!empty($this->user) && is_array($this->user)){
            $user = $this->user;
            $user_ID = $user['user_ID'];
            $model = new Game_Model();
            $data = $model->get_user_updated_data($user_ID);
            $data['cards'] = $model->get_cards_list($user);
            $response = [
                'response_type' => "success",
                'data'          => $data,
            ];
        }
        return $response;
    }

    private function get_ranking_ajax() {
        $response = [];
        if(!empty($this->user) && is_array($this->user)){
            $user = $this->user;
            $userModel = new UserModel();
            $userRank = $userModel->get_user_ranking($user['user_ID'] , $user['total_score']);
            if(!empty($userRank) && is_array($userRank)){
                $gameModel = new Game_Model();
                $data = $gameModel->get_user_rankings($userRank);

                $response = [
                    'response_type' => "success",
                    'data'          => $data,
                ];
            }
        }
        return $response;
    }

    private function get_friends_ajax(){
        $response = [];
        if(!empty($this->user) && is_array($this->user)){
            $user = $this->user;
            $gameModel = new Game_Model();
            $friends = $gameModel->get_user_friends($user['user_ID']);
            if(!empty($friends) && is_array($friends)){
                $data = $gameModel->get_friends_list($friends);
                $response = [
                    'response_type' => "success",
                    'data'          => $data,
                ];
            }
        }
        return $response;
    }

    private function guess_ajax(){
        $response = [];
        if(!empty($this->user) && is_array($this->user)){
            $user = $this->user;
            $user_ID = $user['user_ID'];
            $model = new Game_Model();
            $guess = $model->get_guess();
            if($guess && is_array($guess) && !empty($guess['guess_ID'])){
                if(!empty($_POST['guess_input'])){
                    $guess_ID = $guess['guess_ID'];
                    $guess_input = Utils::test_input($_POST['guess_input']);
                    $user_guess = $model->get_user_guess("user_ID='$user_ID' AND guess_ID='$guess_ID'");
                    if($user_guess === false){
                        $removeGuess = false;
                        if($guess_input == $guess['guess_code']){
                            $model->set_guess_to_user($user_ID , $guess_ID , $guess['gift_coins']);
                            $removeGuess = true;
                        }else{
                            if(!empty($user['coins_number']) && is_numeric($user['coins_number'])){
                                $fineCoins = min($user['coins_number'], $guess['fine_coins']);
                                $model->set_coins_to_user($user_ID , ($fineCoins * -1));
                            }
                        }

                        $data = $model->get_user_updated_data($user_ID);
                        $data['remove_guess'] = $removeGuess;
                        $response = [
                            'response_type' => "success",
                            'data'          => $data,
                        ];
                    }
                }
            }
        }
        return $response;
    }

    private function event_ajax(){
        $response = [];
        if(!empty($this->user) && is_array($this->user)) {
            $user = $this->user;
            $user_ID = $user['user_ID'];
            if(!empty($_POST['ei'])){
                $eventID = $this->get_real_id($_POST['ei']);
                if(!empty($eventID) && is_int($eventID)){
                    $model = new Game_Model();
                    $events = $model->get_events();
                    if(!empty($events) && is_array($events) && array_key_exists($eventID , $events)){
                        $event = $events[$eventID];
                        if(!empty($event['event_ID']) && strtotime($event['event_expire']) >= time()){
                            $user_events = $model->get_user_events("user_ID='$user_ID' AND event_ID='$eventID'");
                            if($user_events === false){
                                if(!empty($user['coins_number']) && is_numeric($user['coins_number']) && $user['coins_number'] >= $event['required_coins']){
                                    $model->set_event_to_user($user_ID , $event);
                                    $data = $model->get_user_updated_data($user_ID);
                                    $data['remove_event'] = Utils::test_input($_POST['ei']);
                                    $response = [
                                        'response_type' => "success",
                                        'data'          => $data,
                                    ];
                                }else{
                                    $this->set_error("تعداد سکه های شما کافی نیست!");
                                }
                            }
                        }
                    }
                }
            }
        }
        return $response;
    }

    private function gift_ajax(){
        $response = [];
        if(!empty($this->user) && is_array($this->user)) {
            $user = $this->user;
            $user_ID = $user['user_ID'];
            if(!empty($_POST['gci'])){
                $giftID = $this->get_real_id($_POST['gci']);
                if(!empty($giftID) && is_int($giftID)){
                    $model = new Game_Model();
                    $gifts = $model->get_gift_cards();
                    if(!empty($gifts) && is_array($gifts) && array_key_exists($giftID , $gifts)){
                        $gift = $gifts[$giftID];
                        if(!empty($gift['gift_ID'])){
                            $user_gifts = $model->get_user_gifts("user_ID='$user_ID' AND gift_ID='$giftID'");
                            if($user_gifts === false){
                                if(!empty($user['coins_number']) && is_numeric($user['coins_number']) && $user['coins_number'] >= $gift['required_coins']){
                                    $giftExpire = date("Y-m-d H:i:s", strtotime("+".$gift['gift_expire_time']." ".$gift['gift_expire_timing']));
                                    $model->set_gift_to_user($user_ID , $giftID , $gift['required_coins'] , $giftExpire , $gift['gift_name'] , $gift['gift_claim_description']);
                                    $data = $model->get_user_updated_data($user_ID);
                                    $data['claim_gift'] = Utils::test_input($_POST['gci']);
                                    $response = [
                                        'response_type' => "success",
                                        'data'          => $data,
                                    ];
                                }else{
                                    $this->set_error("تعداد سکه های شما کافی نیست");
                                }
                            }
                        }
                    }
                }
            }
        }
        return $response;
    }

    private function mission_ajax(){
        $response = [];
        if(!empty($this->user) && is_array($this->user)) {
            $user = $this->user;
            $user_ID = $user['user_ID'];
            if(!empty($_POST['mi'])){
                $missionID = $this->get_real_id($_POST['mi']);
                if(!empty($missionID) && is_int($missionID)){
                    $model = new Game_Model();
                    $missions = $model->get_missions();
                    if(!empty($missions) && is_array($missions) && array_key_exists($missionID , $missions)){
                        $mission = $missions[$missionID];
                        if(!empty($mission['mission_ID'])){
                            $user_missions = $model->get_user_missions("user_ID='$user_ID' AND mission_ID='$missionID'");
                            $user_mission_status = "have_not_mission";
                            if($user_missions && is_array($user_missions) && array_key_exists($missionID , $user_missions)){
                                $user_mission = $user_missions[$missionID];
                                if(!empty($user_mission['claim_status'])){
                                    $user_mission_status = $user_mission['claim_status'];
                                }
                            }

                            if(empty($mission['mission_button_link']) && $user_mission_status == "have_not_mission"){
                                $model->set_mission_to_user($user_ID , $missionID , $mission['mission_coins'] , "claimed");
                                $data = $model->get_user_updated_data($user_ID);
                                $data['claim_mission'] = Utils::test_input($_POST['mi']);
                                $response = [
                                    'response_type' => "success",
                                    'data'          => $data,
                                ];
                            }elseif(!empty($mission['mission_button_link']) && $user_mission_status == "have_not_mission"){
                                $model->set_mission_to_user($user_ID , $missionID , $mission['mission_coins'] , "claimed");
                                $data = $model->get_user_updated_data($user_ID);
                                $data['do_mission'] = Utils::test_input($_POST['mi']);
                                $response = [
                                    'response_type' => "success",
                                    'data'          => $data,
                                    'link'          => $mission['mission_button_link'],
                                ];
                            }elseif(!empty($mission['mission_button_link']) && $user_mission_status == "visited_link"){
                                $model->set_mission_to_user($user_ID , $missionID , $mission['mission_coins'] , "claimed");
                                $data = $model->get_user_updated_data($user_ID);
                                $data['claim_mission'] = Utils::test_input($_POST['mi']);
                                $response = [
                                    'response_type' => "success",
                                    'data'          => $data,
                                ];
                            }

                        }
                    }
                }
            }
        }
        return $response;
    }

    private function card_ajax(){
        $response = [];
        if(!empty($this->user) && is_array($this->user)) {
            $user = $this->user;
            $user_ID = $user['user_ID'];
            if(!empty($_POST['ci'])){
                $cardID = $this->get_real_id($_POST['ci']);
                if(!empty($cardID) && is_int($cardID)){
                    $model = new Game_Model();
                    $cards = $model->get_cards();
                    if(!empty($cards) && is_array($cards) && array_key_exists($cardID , $cards)){
                        $card = $cards[$cardID];
                        if(!empty($card['card_ID'])){
                            $user_cards = $model->get_user_cards("user_ID='$user_ID' AND card_ID='$cardID' ORDER BY card_claim_time DESC" , "1");

                            $rechargeTiming = 0;
                            if($card['recharge_timing'] == "day"){
                                $rechargeTiming = 60 * 60 * 24;
                            }elseif($card['recharge_timing'] == "hour"){
                                $rechargeTiming = 60 * 60;
                            }
                            $rechargeTime = $card['recharge_time'] * $rechargeTiming;
                            $nextClaimTime = 0;
                            if(!empty($user_cards) && is_array($user_cards)){
                                $user_card = array_shift($user_cards);
                                if(!empty($user_card) && is_array($user_card) && !empty($user_card['card_ID'])){
                                    $nextClaimTime = strtotime($user_card['card_claim_time']) + $rechargeTime;
                                }
                            }

                            if($rechargeTime < time()){
                                $model->set_card_to_user($user_ID , $cardID , $card['card_coins']);
                                $data = $model->get_user_updated_data($user_ID);
                                $data['claim_card'] = Utils::test_input($_POST['ci']);
                                $data['recharge_time'] = max($rechargeTime , 0);
                                $response = [
                                    'response_type' => "success",
                                    'data'          => $data,
                                ];
                            }

                        }
                    }
                }
            }
        }
        return $response;
    }

    private function daily_view_ajax(){
        $response = [];
        $daily_gift = 0;
        $app_rules = Site_Options::get("_yooz_main_game_rules");
        if(!empty($app_rules) && is_array(unserialize($app_rules))){
            $app_rules = unserialize($app_rules);
            if(!empty($app_rules['daily_gift'])){
                $daily_gift = intval($app_rules['daily_gift']);
            }
        }

        if($daily_gift > 0){
            if(!empty($this->user) && is_array($this->user)) {
                $user = $this->user;
                $user_ID = $user['user_ID'];
                $model = new Game_Model();
                $views = $model->get_daily_views("user_ID='$user_ID' ORDER BY daily_last_claim DESC");

                if($views && is_array($views)){
                    $i = 0;
                    foreach ($views as $view) {
                        $i++;
                        if($i == 1){
                            $lastViewTime = strtotime($view['daily_last_claim']);
                        }
                    }
                } else {
                    $lastViewTime = 0;
                }

                $diffView = strtotime(date("Y-m-d")) - $lastViewTime + 1;

                if($diffView >= (60 * 60 * 24)){
                    $model->set_daily_view_to_user($user_ID , $daily_gift);
                    $data = $model->get_user_updated_data($user_ID);
                    $data['claim_daily_view'] = true;
                    $data['daily_gift'] = $daily_gift;
                    $response = [
                        'response_type' => "success",
                        'data'          => $data,
                    ];
                }

            }
        }
        return $response;
    }

    private function notification_ajax(){
        $response = [];
        if(!empty($this->user) && is_array($this->user)) {
            $user = $this->user;
            $user_ID = $user['user_ID'];
            if(!empty($_POST['ni'])){
                $notification_ID = $this->get_real_id($_POST['ni']);
                if(!empty($notification_ID) && is_int($notification_ID)){
                    $model = new Game_Model();
                    $notif = $model->get_user_notifications("notification_ID='$notification_ID' AND user_ID='$user_ID' AND notification_status='no_visited'");
                    if(count($notif) > 0){
                        $notification = array_shift($notif);
                        if(!empty($notification) && is_array($notification)){
                            $model->set_notification_visited($notification_ID);

                            if(!empty($notification['notification_coins'])){
                                $model->set_coins_to_user($user_ID , $notification['notification_coins']);
                            }

                            $data = $model->get_user_updated_data($user_ID);
                            $data['claim_notification'] = Utils::test_input($_POST['ni']);
                            $response = [
                                'response_type' => "success",
                                'data'          => $data,
                            ];
                        }
                    }
                }
            }
        }
        return $response;
    }

    private function edit_profile_ajax(){
        $response = [];
        if(!empty($this->user) && is_array($this->user)) {
            $user = $this->user;
            $user_ID = $user['user_ID'];
            $data['display_name'] = !empty($_POST['display_name']) ? Utils::test_input($_POST['display_name']) : "";
            $data['name'] = !empty($_POST['name']) ? Utils::test_input($_POST['name']) : "";
            $data['family'] = !empty($_POST['family']) ? Utils::test_input($_POST['family']) : "";
            $data['gender'] = !empty($_POST['gender']) ? Utils::test_input($_POST['gender']) : "";
            $birth = !empty($_POST['birthdate']) && is_array($_POST['birthdate']) ? $_POST['birthdate'] : [];
            $data['province'] = !empty($_POST['province']) ? intval($_POST['province']) : 0;
            $data['city_ID'] = !empty($_POST['city_ID']) ? intval($_POST['city_ID']) : 0;
            $data['profile_image'] = !empty($_POST['profile_avatar']) ? intval($_POST['profile_avatar']) : 0;


            /* validate data */
            if(!empty($birth['year']) && is_numeric($birth['year']) && !empty($birth['month']) && is_numeric($birth['month']) && !empty($birth['day']) && is_numeric($birth['day'])){
                $data['birthdate'] = JDate::to_greg_date(intval($birth['year']) , intval($birth['month']) , intval($birth['day']) , null , null , null ,"Y-m-d");
            }else{
                //$this->set_error("تاریخ تولد خود را انتخاب کنید.");
            }

            if(!empty($user['birthdate'])){
                $data['birthdate'] = $user['birthdate'];
            }

            if(empty($data['display_name']) || empty($data['name']) || empty($data['family']) || empty($data['gender']) || empty($data['province']) || empty($data['city_ID'])){
                //$this->set_error("تمامی اطلاعات خواسته شده را وارد کنید.");
            }

            if($data['province'] > 32 || $data['province'] < 0){
                $this->set_error("استان نامعتبر است!");
            }
            if($data['city_ID'] > 2867 || $data['city_ID'] < 0){
                $this->set_error("شهر نامعتبر است!");
            }
            if(empty($data['profile_image']) || $data['profile_image'] > 8 || $data['profile_image'] <= 0){
                $this->set_error("تصویر پروفایل خود را انتخاب کنید.");
            }

            if(!$this->has_error()){
                if(!empty($data['display_name']) && !empty($data['name']) && !empty($data['family']) && !empty($data['gender']) && !empty($data['birthdate']) && !empty($data['province']) && !empty($data['city_ID']) && !empty($data['profile_image'])) {
                    $has_completed = true;
                } else {
                    $has_completed = false;
                }
                $userModel = new UserModel();
                $result = $userModel->set_user_data($data , $user_ID);
                if($result){
                    $profile_completion = false;
                    $gameModel = new Game_Model();
                    if($has_completed && empty($user['completed_profile'])){//give user profile completion coins
                        $profile_gift = 0;
                        $rules = Site_Options::get("_yooz_main_game_rules");
                        if($rules && is_array(unserialize($rules))){
                            $rules = unserialize($rules);
                            if(!empty($rules['profile_gift'])){
                                $profile_gift = intval($rules['profile_gift']);
                            }
                        }
                        if($profile_gift > 0){
                            $profile_completion = true;
                            $gameModel->set_coins_to_user($user_ID , $profile_gift);
                            $userModel->set_user_data(['completed_profile' => 'true'] , $user_ID);
                        }
                    }

                    $data = $gameModel->get_user_updated_data($user_ID);
                    if($profile_completion){
                        $data['profile_complete'] = true;
                    } else {
                        $data['profile_saved'] = true;
                    }
                    $response = [
                        'response_type' => "success",
                        'data'          => $data,
                    ];

                }else{
                    $this->set_error("عملیات ناموفق! دوباره تلاش کنید.");
                }
            }


        }
        return $response;
    }
    public function get_cities_ajax(){
        $response = [];
        if(!empty($_POST['province_ID']) && is_numeric($_POST['province_ID'])){
            $provinceID = intval($_POST['province_ID']);
            $model = new Game_Model();
            $form = new User_Forms();
            $cities = $model->get_cities_of_province($provinceID);
            $options = $form->get_options($cities);
            $response = [
              'response_type'   => 'success',
              'options'         => $options,
            ];
        }
        return $response;
    }

    private function set_user_guided_ajax(): void
    {
        if(!empty($this->user) && is_array($this->user)) {
            $user = $this->user;
            $user_ID = $user['user_ID'];
            $model = new UserModel();
            $data = ["tour_guide" => 1];
            $model->set_user_data($data , $user_ID);
        }
    }

    private function get_real_id($val): bool|int
    {
        $val = Utils::test_input($val);
        $realVal = @base64_decode(@hex2bin($val));
        if(!empty($realVal)){
            $explodedVal = explode("_" , $realVal);
            if(!empty($explodedVal) && is_array($explodedVal) && !empty($explodedVal[1]) && is_numeric($explodedVal[1])){
                return intval($explodedVal[1]);
            }
        }
        return false;
    }
    
    private function logout_ajax(){
        $model = new UserModel();
        $model->logout_user();
        return [
            'response_type' => 'redirect',
            'redirect_url' => HOME_URL.'/login',
        ];
    }

}