<?php
namespace App\Controllers\Admin;
use Core\Controller;
use Core\ErrorsTrait;
use Core\Site_Options;
use Core\Utils;
use Core\Validators\Color_Validator;
use Core\Validators\Phone_Validator;
use Core\Validators\Url_Validator;
use Plugins\Yooz_Manager\Yooz_Manager_Utils;

class Store_Settings_Controller extends Controller{
    use ErrorsTrait;
    public function index(){
        /* get site communications */
        $communications = Site_Options::get("site_communications");
        $comms = !empty($communications) ? @unserialize($communications) : [];
        $comms = is_array($comms) ? $comms : [];
        /* get logo file id */
        $logoFileID = intval(Site_Options::get('site_logo'));
        $logoFile = Yooz_Manager_Utils::get_file_by_id($logoFileID);
        /* get site info */
        $siteName = Site_Options::get("site_name");
        $siteDesciptions = Site_Options::get("site_descriptions");

        $admin_theme = Site_Options::get("yooz_admin_theme_colors");

        $sms_api_settings = Site_Options::get("app_sms_api");
        $sms_api_key = $sms_login_body = "";
        if(!empty($sms_api_settings)){
            $sms_values = @unserialize($sms_api_settings);
            if(is_array($sms_values)){
                $sms_api_key    = !empty($sms_values['sms_api_key']) ? $sms_values['sms_api_key'] : "";
                $sms_login_body     = !empty($sms_values['login_body_id']) ? $sms_values['login_body_id'] : "";
            }
        }

        $data = [
            'page_title'            => "تنظیمات سایت",
            'site_logo_id'          => !empty($logoFileID) ? $logoFileID : 0,
            'site_logo'             => is_array($logoFile) && !empty($logoFile['file_url']) ? $logoFile['file_url'] : "/public/uploads/emptyImage.jpg",
            'site_name'             => !empty($siteName) ? $siteName : "",
            'site_descriptions'     => !empty($siteDesciptions) ? $siteDesciptions : "",
            'phone'                 => !empty($comms['phone']) ? $comms['phone'] : "",
            'telegram'              => !empty($comms['telegram']) ? $comms['telegram'] : "",
            'instagram'             => !empty($comms['instagram']) ? $comms['instagram'] : "",
            'website'             => !empty($comms['website']) ? $comms['website'] : "",
            'address'               => !empty($comms['address']) ? $comms['address'] : "",
            'admin_colors'          => !empty($admin_theme) && is_array(unserialize($admin_theme)) ? unserialize($admin_theme) : [],
            'sms_api_key'           => $sms_api_key,
            'sms_login_body'        => $sms_login_body,
        ];
        $this->view->render('store_settings' , $data);
    }

    public function game_page(){
        $game_score_system = Site_Options::get("_app_score_system");
        $game_slider = Site_Options::get("_game_slider");
        $lander = Site_Options::get("_lander_settings");
        $game_colors = Site_Options::get("_game_colors");
        $data = [
            'page_title'            => "تنظیمات بازی",
            'score_system'          => $game_score_system && is_array(unserialize($game_score_system)) ? unserialize($game_score_system) : [],
            'game_slider'           => $game_slider && is_array(unserialize($game_slider)) ? unserialize($game_slider) : [],
            'lander'                => $lander && is_array(unserialize($lander)) ? unserialize($lander) : [],
            'game_colors'           => $game_colors && is_array(unserialize($game_colors)) ? unserialize($game_colors) : [],
        ];
        $this->view->render('game_settings' , $data);
    }

    public function ajax_response($action){
        $response = [];
        $method_name = $action."_ajax";

        if(method_exists(self::class , $method_name)){
            $response = $this->$method_name();
        }else{
            $this->set_error("خطایی در سمت سرور وجود دارد. لطفا با پشتیبان سایت تماس بگیرید.");
        }

        if($this->has_error()){
            $response = ['response_type' => 'error' , 'message'=>$this->get_errors_text("<br>")];
        }
        return $response;
    }

    private function store_ajax(){
        $response = [];
        $logoFileID = !empty($_POST['site_logo']) ? intval($_POST['site_logo']) : 0;
        $siteName = !empty($_POST['site_name']) ? Utils::test_input($_POST['site_name']) : "";
        $siteDescriptions = !empty($_POST['site_descriptions']) ? Utils::test_input($_POST['site_descriptions']) : "";

        if(Yooz_Manager_Utils::get_file_by_id($logoFileID)){
            $result = Site_Options::update_all([
                "site_logo"         => $logoFileID,
                "site_name"         => $siteName,
                "site_descriptions" => $siteDescriptions,
            ]);

            if($result['update_number'] >= 3){
                if($result['update_number'] === 3){
                    $response = ["response_type" => "message" , "message" => "اطلاعات با موفقیت به روز رسانی شد."];
                }else{
                    $this->set_error("به روز رسانی اطلاعات به صورت ناقص انجام گرفته است. لطفا قبل از ترک صفحه مجددا تنظیمات را ذخیره کنید.");
                }
            }else{
                $this->set_error("به روز رسانی اطلاعات ناموفق بود. لطفا دوباره امتحان کنید.");
            }
        }else{
            $this->set_error("تصویر انتخاب شده برای لوگو سایت معتبر نیست.");
        }

        return $response;
    }

    private function communications_ajax(){
        $response = $errors = [];
        if(!empty($_POST['site_communications']) && is_array($_POST['site_communications'])){
            $phoneValidator = new Phone_Validator();
            $urlValidator = new Url_Validator();
            $comms = $_POST['site_communications'];
            $phone = !empty($comms['phone']) ? Utils::EnglishNumber(Utils::test_input($comms['phone'])) : "";
            $address = !empty($comms['address']) ? Utils::test_input($comms['address']) : "";
            $telegram = !empty($comms['telegram']) ? Utils::EnglishNumber(Utils::test_input($comms['telegram'])) : "";
            $instagram = !empty($comms['instagram']) ? Utils::EnglishNumber(Utils::test_input($comms['instagram'])) : "";
            $website = !empty($comms['website']) ? Utils::EnglishNumber(Utils::test_input($comms['website'])) : "";
            
            if(!empty($telegram) && !$urlValidator->validate($telegram)){
                array_push($errors , "لینک تلگرام معتبر نیست.");
            }
            if(!empty($instagram) && !$urlValidator->validate($instagram)){
                array_push($errors , "لینک اینستاگرام معتبر نیست.");
            }
            if(!empty($website) && !$urlValidator->validate($website)){
                array_push($errors , "لینک وبسایت معتبر نیست.");
            }
        }else{
            array_push($errors , "اطلاعات دریافت نشد.");
        }

        if(count($errors) == 0){
            $communications = [
                'phone'     => $phone,
                'telegram'  => $telegram,
                'instagram' => $instagram,
                'website' => $website,
                'address'   => $address,
            ];
            $communications = serialize($communications);
            Site_Options::update("site_communications" , $communications);
            $response = ["response_type"=>"message" , "message" => "اطلاعات با موفقیت ذخیره شد."];
        }else{
            $responseText = "خطا :"."<br>";
            $responseText .= implode("<br>" , $errors);
            $response = ["response_type"=>"error" , "message" => $responseText];
        }
        return $response;
    }

    private function admin_theme_ajax(){
        $response = [];
        if(!empty($_POST['admin_panel_colors']) && is_array($_POST['admin_panel_colors'])){
            $validator = new Color_Validator();
            $data = [];
            foreach($_POST['admin_panel_colors'] as $colorKey => $colorValue){
                if(!empty($colorKey) && !empty($colorValue) && $validator->validate($colorValue)){
                    $data[$colorKey] = $colorValue;
                }
            }
            Site_Options::update("yooz_admin_theme_colors" , serialize($data));
            $response = [
                'response_type'=>'redirect',
                "message" => "اطلاعات با موفقیت ذخیره شد.",
                "redirect_url"=> "reload"
            ];
        }else{
            $this->set_error("رنگ‌های انتخاب شده وارد نشده اند.");
        }
        return $response;
    }

    private function sms_settings_ajax(): array{
        $response = [];
        if(!empty($_POST['app_sms_api']) && is_array($_POST['app_sms_api'])){
            $sms_settings = $_POST['app_sms_api'];
            if(!empty($sms_settings['sms_api_key']) && !empty($sms_settings['login_body_id'])){
                $sms_api = Utils::test_input($sms_settings['sms_api_key']);
                $login_body = intval(Utils::EnglishNumber($sms_settings['login_body_id']));
                $data = ["sms_api_key" => $sms_api , "login_body_id" => $login_body];
                $result = Site_Options::update("app_sms_api" , serialize($data));
                if($result){
                    $response = [
                        'response_type' =>'success',
                        'message'       =>'اطلاعات با موفقیت به روز رسانی شد.'
                    ];
                }else{
                    $this->set_error("عملیات ناموفق! دوباره تلاش کنید.");
                }
            }else{
                $this->set_error("اطلاعات خواسته شده را وارد نمایید.");
            }
        }else{
            $this->set_error("اطلاعات ارسال شده ایراد دارد. لطفا صفحه را مجددا بارگذاری کرده و دوباره تلاش کنید.");
        }
        return $response;
    }

    private function score_system_ajax(){
        $response = [];
        if(!empty($_POST['score_system']) && is_array($_POST['score_system'])){
            $score_system = $_POST['score_system'];
            if(
                !empty($score_system['invitation_score']) && is_numeric($score_system['invitation_score']) &&
                !empty($score_system['medal_score']) && is_numeric($score_system['medal_score']) &&
                !empty($score_system['gift_card_score']) && is_numeric($score_system['gift_card_score']) &&
                !empty($score_system['mission_score']) && is_numeric($score_system['mission_score']) &&
                !empty($score_system['descriptions']) &&
                !empty($score_system['activation']) && ($score_system['activation'] == "yes" || $score_system['activation'] == "no")
            ){
                $result = Site_Options::update("_app_score_system" , serialize($score_system));
                if($result){
                    $response = [
                        'response_type' => "message",
                        'message'       => "اطلاعات با موفقیت ذخیره شدند.",
                    ];
                }else{
                    $this->set_error("عملیات ناموفق! دوباره تلاش کنید.");
                }
            }else{
                $this->set_error("تمام اطلاعات خواسته شده را به طور صحیح وارد کنید.");
            }
        }else{
            $this->set_error("داده های وارد شده صحیح نیست.");
        }
        return $response;
    }

    private function slider_ajax(){
        $response = [];
        $urlValidator = new Url_Validator();
        if(!empty($_POST['game_slider']) && is_array($_POST['game_slider'])){
            $game_slider = $_POST['game_slider'];

            foreach($game_slider as $sliderID => $slideData){
                if(!empty($slideData) && is_array($slideData) && !empty($slideData['image'])){
                    $imageID = intval($slideData['image']);
                    $file = \Plugins\Yooz_Manager\Yooz_Manager_Utils::get_file_by_id($imageID);
                    if(!$file || !is_array($file) || empty($file['file_url'])){
                        $this->set_error("برخی از تصاویر اسلایدر معتبر نیستند.");
                        break;
                    }else{
                        if(!empty($slideData['link']) && !$urlValidator->validate($slideData['link'])){
                            $this->set_error("لینک برخی از تصاویر اسلایدر معتبر نیستند.");
                            break;
                        }
                    }
                }
            }

            if(!$this->has_error()){
                $result = Site_Options::update("_game_slider" , serialize($game_slider));
                if($result){
                    $response = [
                        'response_type' => "message",
                        'message'       => "اطلاعات با موفقیت ذخیره شدند.",
                    ];
                }else{
                    $this->set_error("عملیات ناموفق! دوباره تلاش کنید.");
                }
            }

        }else{
            $this->set_error("داده های وارد شده صحیح نیست.");
        }
        return $response;
    }

    private function lander_settings_ajax(){
        $response = [];
        if(!empty($_POST['lander_settings']) && is_array($_POST['lander_settings'])){
            $data = $_POST['lander_settings'];
            $lander = [];
            /*validate data*/
            if(!empty($data['main_banner'])){
                if(is_numeric($data['main_banner'])){
                    $lander['main_banner'] = $this->get_images(intval($data['main_banner']));
                    $lander['main_banner_id'] = intval($data['main_banner']);
                }
                if(empty($lander['main_banner'])){
                    $this->set_error("تصویر بنر اصلی نامعتبر است.");
                }
            }
            if(!empty($data['bottom_banner'])){
                if(is_numeric($data['bottom_banner'])){
                    $lander['bottom_banner'] = $this->get_images(intval($data['bottom_banner']));
                    $lander['bottom_banner_id'] = intval($data['bottom_banner']);
                }
                if(empty($lander['bottom_banner'])){
                    $this->set_error("تصویر بنر پایین صفحه نامعتبر است.");
                }
            }
            if(!empty($data['main_title'])){
                $lander['main_title'] = Utils::test_input($data['main_title']);
            }
            if(!empty($data['second_title'])){
                $lander['second_title'] = Utils::test_input($data['second_title']);
            }
            $colorValidator = new Color_Validator();
            if(!empty($data['bg_color'])){
                $bg_color = Utils::test_input($data['bg_color']);
                if($colorValidator->validate($bg_color)){
                    $lander['bg_color'] = $bg_color;
                }else{
                    $this->set_error("رنگ انتخاب شده برای پس زمینه نامعتبر است.");
                }
                
            }
            if(!empty($data['button_color'])){
                $button_color = Utils::test_input($data['button_color']);
                if($colorValidator->validate($button_color)){
                    $lander['button_color'] = $button_color;
                }else{
                    $this->set_error("رنگ انتخاب شده برای دکمه نامعتبر است");
                }
                
            }
            

            if(!empty($data['gifts_activation']) && ($data['gifts_activation'] == "active" || $data['gifts_activation'] == "deactive")){
                $lander['gifts_activation'] = Utils::test_input($data['gifts_activation']);
            }else{
                $this->set_error("مقدار انتخاب شده برای وضعیت نمایش جوایز نامعتبر است.");
            }
            if(!empty($data['gifts_cover'])){
                if(is_numeric($data['gifts_cover'])){
                    $lander['gifts_cover'] = $this->get_images(intval($data['gifts_cover']));
                    $lander['gifts_cover_id'] = intval($data['gifts_cover']);
                }
                if(empty($lander['gifts_cover'])){
                    $this->set_error("تصویر آکون جوایز نامعتبر است.");
                }
            }
            if(!empty($data['gifts_title'])){
                $lander['gifts_title'] = Utils::test_input($data['gifts_title']);
            }
            if(!empty($data['gifts_text'])){
                $lander['gifts_text'] = Utils::test_input($data['gifts_text']);
            }

            if(!$this->has_error()){
                $result = Site_Options::update("_lander_settings" , serialize($lander));
                if($result){
                    $response = [
                        'response_type' => "message",
                        'message'       => "اطلاعات با موفقیت ذخیره شد.",
                    ];
                }else{
                    $this->set_error("عملیات ناموفق! دوباره تلاش کنید");
                }
            }



        }else{
            $this->set_error("اطلاعات وارد شده ایراد دارد.");
        }
        return $response;
    }
    
    private function game_colors_ajax(){
        $response = [];
        
        if(!empty($_POST['game_colors']) && is_array($_POST['game_colors'])){
            $colors = $_POST['game_colors'];
            $colorValidator = new Color_Validator();
            foreach($colors as $color_key => $color){
                if(!$colorValidator->validate($color)){
                    $this->set_error("برخی از رنگ های انتخاب شده معتبر نیستند.");
                    break;
                }
            }
            
            if(!$this->has_error()){
                $result = Site_Options::update("_game_colors" , serialize($colors));
                if($result){
                    $response = [
                        'response_type' => "message",
                        'message'       => "اطلاعات با موفقیت ذخیره شد.",
                    ];
                }else{
                    $this->set_error("عملیات ناموفق! دوباره تلاش کنید");
                }
            }
        }else{
            $this->set_error("اطلاعات وارد شده نامعتبر است.");
        }
        return $response;
    }

    private function get_images(int $imageID){
        $file = Yooz_Manager_Utils::get_file_by_id($imageID);
        return !empty($file) && is_array($file) && !empty($file['file_url']) ? $file['file_url'] : "";
    }
}