<?php
namespace App\Controllers\Admin;
use App\Models\Admin;
use Core\Controller;
use Core\ErrorsTrait;
use Core\Utils;

class Login_Controller extends Controller{
    use ErrorsTrait;
    public function index(){
        $data = [
            "page_title"    => "صفحه ورود",
        ];
        $this->view->render('login_page' , $data , false , "admin_login");
    }

    public function ajax_response($action){
        $response = [];
        $method_name = $action."_ajax";
        if(method_exists(self::class , $method_name)){
            $response = $this->$method_name();
        }

        if($this->has_error()){
            $response = ['response_type'=>'error' , 'message' => $this->get_errors_text()];
        }

        return $response;
    }

    private function login_ajax(){
        $response = [];
        if(!empty($_POST['username']) && !empty($_POST['password'])){
            $adminModel = new Admin();
            $username = Utils::test_input($_POST['username']);
            $password = Utils::test_input($_POST['password']);
            $hashPassword = $adminModel->hash_password($password);

            $admin = $adminModel->get_admins("username='$username' AND password='$hashPassword'");
            if($admin && !empty($admin['admin_ID'])){
                $adminModel->set_admin_login($admin['admin_ID']);
                $response = [
                    'response_type' =>'redirect',
                    'message'       => 'ورود با موفقیت انجام شد. خوش آمدید.',
                    'redirect_url'  => !empty(Utils::get_back_url()) ? Utils::get_back_url() : ADMIN_URL,
                    ];
            }else{
                $this->set_error("نام کاربری و یا رمز عبور اشتباه است.");
            }
        }else{
            $this->set_error('نام کاربری و رمز عبور خود را وارد کنید.');
        }
        return $response;
    }
    
    private function logout_ajax(){
        $model = new Admin();
        $model->logout_user();
        return [
            'response_type' => 'redirect',
            'redirect_url' => ADMIN_URL.'/login',
        ];
    }
}