<?php
namespace App\Controllers\Admin;

use App\Models\Cards_Model;
use App\Models\Guess_Model;
use App\Models\Missions_Model;
use Core\Controller;
use Core\ErrorsTrait;
use Core\JDate;
use Core\Utils;
use Core\Validators\Color_Validator;
use Core\Validators\Url_Validator;
use Plugins\Yooz_Manager\Yooz_Manager_Utils;

class Game_Coins_Controller extends Controller{
    use ErrorsTrait;
    public function index(){
        $cards_model = new Cards_Model();
        $missions_model = new Missions_Model();
        $guess_model = new Guess_Model();
        $card_items = $cards_model->get_cards();
        $mission_items = $missions_model->get_missions();
        $guess_items = $guess_model->get_guesses();
        $data = [
            'page_title'    => "تعریف سکه ها",
            'card_items'    => $card_items && is_array($card_items) ? $card_items : [],
            'mission_items' => $mission_items && is_array($mission_items) ? $mission_items : [],
            'guess_items'   => $guess_items && is_array($guess_items) ? $guess_items : [],
        ];

        $this->view->render("game_coins" , $data);
    }

    public function ajax_response(string $action){
        $response = [];
        $method_name = $action."_ajax";
        if(method_exists(self::class , $method_name)){
            $response = $this->$method_name();
        }
        if($this->has_error()){
            $response = ['response_type'=>'error' , 'message'=>$this->get_errors_text("<br>")];
        }
        return $response;
    }



    private function save_card_ajax(){
        $response = $errors = [];
        $model = new Cards_Model();
        $colorValidator = new Color_Validator();
        $card_ID =          isset($_POST['card_ID']) ? Utils::test_input($_POST['card_ID']) : false;
        $card_name =        !empty($_POST['card_name']) ? Utils::test_input($_POST['card_name']) : "";
        $card_text =        !empty($_POST['card_text']) ? Utils::test_input($_POST['card_text']) : "";
        $card_title =       !empty($_POST['card_title']) ? Utils::test_input($_POST['card_title']) : "";
        $card_description = !empty($_POST['card_description']) ? Utils::test_input($_POST['card_description']) : "";
        $card_coins =       !empty($_POST['card_coins']) ? intval(Utils::EnglishNumber($_POST['card_coins'])) : 0;
        $card_bg_color =    !empty($_POST['card_bg_color']) ? Utils::test_input($_POST['card_bg_color']) : "#000000";
        $recharge_time =    !empty($_POST['recharge_time']) ? intval(Utils::EnglishNumber($_POST['recharge_time'])) : false;
        $recharge_timing =  !empty($_POST['recharge_timing']) ? Utils::test_input($_POST['recharge_timing']) : "day";
        $card_image_id =    !empty($_POST['card_image_id']) ? intval($_POST['card_image_id']) : 0;
        $card_status =      !empty($_POST['display_status']) ? Utils::test_input($_POST['display_status']) : "yes";

        /* validate data */
        if(empty($card_name) || empty($card_text) || empty($card_title) || empty($card_description) || empty($card_coins)){
            array_push($errors , "تمامی اطلاعات خواسته شده را تکمیل نمایید.");
        }
        if($colorValidator->validate($card_bg_color) !== true){
            array_push($errors , "رنگ پس زمینه باید از نوع HEX باشد.");
        }
        if($card_status !== "yes" && $card_status !== "no"){
            array_push($errors , "مقدار انتخاب شده برای وضعیت ، غیر قابل قبول است.");
        }
        if($recharge_timing !== "day" && $recharge_timing !== "hour"){
            array_push($errors , "مقدار انتخاب شده برای نوع زمان شارژ مجدد ، غیر قابل قبول است.");
        }
        if(!empty($card_image_id) && !Yooz_Manager_Utils::get_file_by_id($card_image_id)){
            array_push($errors , "تصویر کارت ، معتبر نیست.");
        }
        if($card_ID === false || !is_numeric($card_ID)){
            array_push($errors , "شناسه کارت نامعتبر است.");
        }
        if($recharge_time === false || !is_numeric($recharge_time) || !is_int($recharge_time)){
            array_push($errors , "زمان شارژ مجدد کارت نامعتبر است.");
        }

        if(count($errors) == 0) {
            $result = $model->add_card($card_ID, $card_name, $card_text,
                $card_title, $card_description, $card_coins, $card_bg_color,
                $recharge_time, $recharge_timing, $card_image_id, $card_status);
            if($result){
                $structure = $model->get_cards_ui();
                $response = ["response_type"=> "success" , "message" => "اطلاعات با موفقیت ذخیره شد." , "structure" => $structure['structure']];
            }else{
                if($model->has_error()){
                    array_push($errors , $model->get_errors_text());
                }else{
                    array_push($errors , "ثبت اطلاعات ناموفق بود!");
                }
            }
        }

        if(count($errors) > 0){
            $responseText = "خطا :"."<br>";
            $responseText .= implode("<br>" , $errors);
            $response = ["response_type"=>"error" , "message" => $responseText];
        }
        return $response;
    }


    private function get_card_info_ajax(){
        $response = [];
        if(isset($_POST['card_ID'])){
            $cardID = intval($_POST['card_ID']);
            $model = new Cards_Model();
            $result = $model->get_card_by_id($cardID);
            if($cardID == 0){
                $result = [
                    'card_ID'           =>$cardID,
                    "image_url"         => "/public/uploads/emptyImage.jpg",
                    'recharge_timing'   => "day",
                    'display_status'    => "yes",
                ];
            }
            if($result){
                $response = ["response_type"=>"success" , "message" => $result];
            }else{
                $this->set_error("شناسه کارت وارد نشده است.");
            }
        }
        return $response;
    }

    private function delete_card_ajax(){
        $response = [];
        if(!empty($_POST['card_ID'])){
            $cardID = intval($_POST['card_ID']);
            $model = new Cards_Model();
            if($model->delete_card_item($cardID)){
                $structure = $model->get_cards_ui();
                $response = ['response_type' => 'success' , 'message' => 'آیتم با موفقیت حذف شد.', "structure" => $structure['structure']];
            }else{
                $this->set_error("عملیات ناموفق. دوباره تلاش کنید.");
            }
        }else{
            $this->set_error("شناسه کارت معتبر نیست.");
        }
        return $response;
    }

    private function get_mission_info_ajax(){
        $response = [];
        if(isset($_POST['mission_ID'])){
            $missionID = intval($_POST['mission_ID']);
            $model = new Missions_Model();
            $result = $model->get_mission_by_id($missionID);
            if($missionID == 0){
                $result = [
                    'mission_ID'        => $missionID,
                    "image_url"         => "/public/uploads/emptyImage.jpg",
                    'display_status'    => "yes",
                ];
            }
            if($result){
                $response = ["response_type"=>"success" , "message" => $result];
            }else{
                $this->set_error("شناسه ماموریت وارد نشده است.");
            }
        }
        return $response;
    }

    private function save_mission_ajax(){
        $response = $errors = [];
        $model = new Missions_Model();
        $colorValidator = new Color_Validator();
        $urlValidator = new Url_Validator();
        $mission_ID =          isset($_POST['mission_ID']) ? Utils::test_input($_POST['mission_ID']) : false;
        $mission_title =       !empty($_POST['mission_title']) ? Utils::test_input($_POST['mission_title']) : "";
        $mission_description = !empty($_POST['mission_description']) ? Utils::test_input($_POST['mission_description']) : "";
        $mission_button_label = !empty($_POST['mission_button_label']) ? Utils::test_input($_POST['mission_button_label']) : "";
        $mission_button_link = !empty($_POST['mission_button_link']) ? Utils::test_input($_POST['mission_button_link']) : "";
        $mission_coins =       !empty($_POST['mission_coins']) ? intval(Utils::EnglishNumber($_POST['mission_coins'])) : 0;
        $mission_bg_color =    !empty($_POST['mission_bg_color']) ? Utils::test_input($_POST['mission_bg_color']) : "#000000";
        $mission_image_id =    !empty($_POST['mission_image_id']) ? intval($_POST['mission_image_id']) : 0;
        $mission_status =      !empty($_POST['display_status']) ? Utils::test_input($_POST['display_status']) : "yes";

        /* validate data */
        if(empty($mission_title) || empty($mission_description) || empty($mission_button_label) || empty($mission_coins)){
            array_push($errors , "تمامی اطلاعات خواسته شده را تکمیل نمایید.");
        }
        if($colorValidator->validate($mission_bg_color) !== true){
            array_push($errors , "رنگ پس زمینه باید از نوع HEX باشد.");
        }
        if($mission_status !== "yes" && $mission_status !== "no"){
            array_push($errors , "مقدار انتخاب شده برای وضعیت ، غیر قابل قبول است.");
        }
        if(!empty($mission_image_id) && !Yooz_Manager_Utils::get_file_by_id($mission_image_id)){
            array_push($errors , "تصویر ماموریت ، معتبر نیست.");
        }
        if($mission_ID === false || !is_numeric($mission_ID)){
            array_push($errors , "شناسه ماموریت نامعتبر است.");
        }
        if(!empty($mission_button_link) && !$urlValidator->validate($mission_button_link)){
            array_push($errors , "لینک دکمه نامعتبر است.");
        }

        if(count($errors) == 0) {
            $result = $model->add_mission($mission_ID, $mission_title, $mission_description,
                $mission_button_label,$mission_button_link ,$mission_coins, $mission_bg_color,
                $mission_image_id, $mission_status);
            if($result){
                $structure = $model->get_missions_ui();
                $response = ["response_type"=> "success" , "message" => "اطلاعات با موفقیت ذخیره شد." , "structure" => $structure['structure']];
            }else{
                if($model->has_error()){
                    array_push($errors , $model->get_errors_text());
                }else{
                    array_push($errors , "ثبت اطلاعات ناموفق بود!");
                }
            }
        }

        if(count($errors) > 0){
            $responseText = "خطا :"."<br>";
            $responseText .= implode("<br>" , $errors);
            $response = ["response_type"=>"error" , "message" => $responseText];
        }
        return $response;
    }

    private function delete_mission_ajax(){
        $response = [];
        if(!empty($_POST['mission_ID'])){
            $missionID = intval($_POST['mission_ID']);
            $model = new Missions_Model();
            if($model->delete_mission_item($missionID)){
                $structure = $model->get_missions_ui();
                $response = ['response_type' => 'success' , 'message' => 'آیتم با موفقیت حذف شد.', "structure" => $structure['structure']];
            }else{
                $this->set_error("عملیات ناموفق. دوباره تلاش کنید.");
            }
        }else{
            $this->set_error("شناسه ماموریت معتبر نیست.");
        }
        return $response;
    }

    private function get_guess_info_ajax(){
        $response = [];
        if(isset($_POST['guess_ID'])){
            $guessID = intval($_POST['guess_ID']);
            $model = new Guess_Model();
            $result = $model->get_guess_by_id($guessID);
            if($guessID == 0){
                $result = [
                    'guess_ID'          => $guessID,
                    "image_url"         => "/public/uploads/emptyImage.jpg",
                    'display_status'    => "yes",
                ];
            }
            if($result){
                if(!empty($result['expiration_date'])){
                    $timestamp = strtotime($result['expiration_date']);
                    $j_date = JDate::getDate($timestamp, "", "UTC");
                    $result['expiration_date[year]']    = $j_date['year'];
                    $result['expiration_date[month]']   = $j_date['mon'];
                    $result['expiration_date[day]']     = $j_date['mday'];
                }
                $response = ["response_type"=>"success" , "message" => $result];
            }else{
                $this->set_error("شناسه کد شانس وارد نشده است.");
            }
        }
        return $response;
    }

    private function save_guess_ajax(){
        $response = $errors = [];
        $model = new Guess_Model();
        $guess_ID           = isset($_POST['guess_ID']) ? Utils::test_input($_POST['guess_ID']) : false;
        $guess_code         = isset($_POST['guess_code']) ? Utils::test_input($_POST['guess_code']) : false;
        $guess_description  = !empty($_POST['guess_description']) ? Utils::test_input($_POST['guess_description']) : "";
        $gift_coins         = !empty($_POST['gift_coins']) ? intval(Utils::EnglishNumber($_POST['gift_coins'])) : 0;
        $fine_coins         = !empty($_POST['fine_coins']) ? intval(Utils::EnglishNumber($_POST['fine_coins'])) : 0;
        $guess_image_id     = !empty($_POST['guess_image_id']) ? intval($_POST['guess_image_id']) : 0;
        $guess_status       = !empty($_POST['display_status']) ? Utils::test_input($_POST['display_status']) : "yes";
        $expiration_date    = !empty($_POST['expiration_date']) && is_array($_POST['expiration_date']) ? $_POST['expiration_date'] : [];

        /* validate data */
        if($guess_ID === false || !is_numeric($guess_ID)){
            array_push($errors , "شناسه کد شانس نامعتبر است.");
        }
        if($guess_code === false){
            array_push($errors , "کد شانس را وارد کنید.");
        }
        if(empty($gift_coins)){
            array_push($errors , "تعداد سکه جایزه را مشخص کنید.");
        }
        if($guess_status !== "yes" && $guess_status !== "no"){
            array_push($errors , "مقدار انتخاب شده برای وضعیت ، غیر قابل قبول است.");
        }
        if(!empty($guess_image_id) && !Yooz_Manager_Utils::get_file_by_id($guess_image_id)){
            array_push($errors , "تصویر کد شانس ، معتبر نیست.");
        }
        if(!empty($expiration_date['year']) && is_numeric($expiration_date['year']) && !empty($expiration_date['month']) && is_numeric($expiration_date['month']) && !empty($expiration_date['day']) && is_numeric($expiration_date['day'])){
            $expire_date = JDate::to_greg_date(intval($expiration_date['year']) , intval($expiration_date['month']) , intval($expiration_date['day']) , 23 , 59 , 59);
        }else{
            array_push($errors , "تاریخ انقضا را وارد کنید.");
        }

        if(count($errors) == 0) {
            $result = $model->add_guess($guess_ID,$guess_code,$guess_description,
                $fine_coins,$gift_coins,$guess_image_id,$expire_date,$guess_status);
            if($result){
                $structure = $model->get_guesses_ui();
                $response = ["response_type"=> "success" , "message" => "اطلاعات با موفقیت ذخیره شد." , "structure" => $structure['structure']];
            }else{
                if($model->has_error()){
                    array_push($errors , $model->get_errors_text());
                }else{
                    array_push($errors , "ثبت اطلاعات ناموفق بود!");
                }
            }
        }

        if(count($errors) > 0){
            $responseText = "خطا :"."<br>";
            $responseText .= implode("<br>" , $errors);
            $response = ["response_type"=>"error" , "message" => $responseText];
        }
        return $response;
    }

    private function delete_guess_ajax(){
        $response = [];
        if(!empty($_POST['guess_ID'])){
            $guessID = intval($_POST['guess_ID']);
            $model = new Guess_Model();
            if($model->delete_guess_item($guessID)){
                $structure = $model->get_guesses_ui();
                $response = ['response_type' => 'success' , 'message' => 'آیتم با موفقیت حذف شد.', "structure" => $structure['structure']];
            }else{
                $this->set_error("عملیات ناموفق. دوباره تلاش کنید.");
            }
        }else{
            $this->set_error("شناسه کد شانس معتبر نیست.");
        }
        return $response;
    }
}